/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.config;

import com.zkteco.tray.config.ConfigSource;
import com.zkteco.tray.service.TrayParamService;
import com.zkteco.tray.service.TrayServerService;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.vo.TrayParamItem;
import com.zkteco.tray.vo.TrayParamsItem;
import com.zkteco.tray.vo.TrayServerItem;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=100)
public class TrayInit
implements CommandLineRunner {
    @Autowired
    private TrayParamService trayParamService;
    @Autowired
    private TrayServerService trayServerService;

    public void run(String ... args) throws Exception {
        System.out.println("Init Tray ...");
        ConfigSource.init();
        String isInit = this.trayParamService.getValueByName("TrayInit", Boolean.FALSE.toString());
        if (StringUtils.equalsIgnoreCase((CharSequence)Boolean.FALSE.toString(), (CharSequence)isInit)) {
            this.initParameter();
            this.initServer();
            this.trayParamService.saveItem(new TrayParamItem("TrayInit", Boolean.TRUE.toString()));
        }
    }

    private void initParameter() {
        System.out.println("Init Tray Parameter...");
        TrayParamItem param = new TrayParamItem();
        param.setParamName("tray.sync.time");
        param.setParamValue("1");
        this.trayParamService.saveItem(param);
        param = new TrayParamItem();
        param.setParamName("tray.sync.check.time");
        param.setParamValue("5");
        this.trayParamService.saveItem(param);
    }

    private void initServer() {
        System.out.println("Init Tray Local Server...");
        TrayParamsItem params = ExecUtils.getNParams((boolean)true);
        TrayServerItem item = this.trayServerService.getLocalServer();
        if (StringUtils.isBlank((CharSequence)item.getId())) {
            item.setName("localhost");
            item.setHost((Boolean.TRUE.toString().equals(params.getServerSslEnable()) ? "https://" : "http://") + CommonUtils.getLocalhost() + ":8200");
            item.setLocal(Boolean.valueOf(true));
            item.setCreateTime(new Date());
        }
        this.trayServerService.save(item);
    }
}

