/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.config;

import com.zkteco.tray.model.BaseModel;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JpaAspect {
    @Pointcut(value="execution(* com.zkteco..dao..save(..)) ")
    public void saveOrUpdate() {
    }

    @Pointcut(value="execution(* com.zkteco.tray.dao.BaseDao.saveAll(..)) || execution(* org.springframework.data.repository.CrudRepository.saveAll(..)) || execution(* org.springframework.data.jpa.repository.JpaRepository.saveAll(..)) ")
    public void saveOrUpdateAll() {
    }

    @Around(value="saveOrUpdateAll() && target(tar) && args(entity)")
    public Object aroundSaveAll(ProceedingJoinPoint point, Object tar, Object entity) throws Throwable {
        return this.aroundSave(point, tar, entity);
    }

    @Around(value="saveOrUpdate() && target(tar) && args(entity)")
    public Object aroundSave(ProceedingJoinPoint point, Object tar, Object entity) throws Throwable {
        if (entity instanceof BaseModel) {
            this.updateBaseInfo(entity);
        } else if (entity instanceof Iterable) {
            Iterable iterable = (Iterable)entity;
            for (Object obj : iterable) {
                if (!(obj instanceof BaseModel)) continue;
                this.updateBaseInfo(obj);
            }
        }
        return point.proceed();
    }

    private void updateBaseInfo(Object entity) throws IllegalAccessException, InvocationTargetException {
        if (Objects.isNull(((BaseModel)entity).getCreateTime())) {
            BeanUtils.setProperty((Object)entity, (String)"createTime", (Object)new Date());
        }
        BeanUtils.setProperty((Object)entity, (String)"updateTime", (Object)new Date());
    }
}

