/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.config;

import com.alibaba.fastjson.annotation.JSONField;
import com.zkteco.tray.bean.BaseColumn;
import com.zkteco.tray.bean.RecordBean;
import com.zkteco.tray.bean.ZKBusinessException;
import com.zkteco.tray.utils.DBUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.utils.IniUtils;
import com.zkteco.tray.vo.TrayColumnItem;
import com.zkteco.tray.vo.TrayParamsItem;
import com.zkteco.tray.vo.TrayServerItem;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigSource {
    private static final Logger log = LoggerFactory.getLogger(ConfigSource.class);
    private static List<RecordBean> tables;
    private static List<String> dirs;
    private static Map<String, Map<String, String>> columns;
    private static Map<String, Map<String, TrayColumnItem>> columnTypes;
    private static Map<String, Map<String, String>> fileMap;
    private static Map<String, Boolean> serverMap;
    private static Map<String, TrayServerItem> servers;
    private static TrayServerItem localServer;
    private static Map<String, String> baseColumns;

    public static TrayServerItem getLocalServer() {
        return localServer;
    }

    public static void setLocalServer(TrayServerItem l) {
        localServer = l;
    }

    public static void addServer(TrayServerItem serve) {
        if (servers == null) {
            servers = new HashMap();
        }
        servers.put(serve.getId(), serve);
    }

    public static Date getSyncTime(TrayServerItem serve) {
        if (servers == null) {
            servers = new HashMap();
        }
        if (servers.containsKey(serve.getId())) {
            return serve.getSyncTime();
        }
        return serve.getSyncTime();
    }

    private static void initTypes(String tableName) {
        try {
            if (columnTypes == null) {
                columnTypes = new HashMap();
            }
            TrayParamsItem params = ExecUtils.getNParams((boolean)true);
            Map tableColumns = DBUtils.getColumnTypes((TrayParamsItem)params, (String)tableName);
            columnTypes.put(tableName, tableColumns);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static void init() {
        serverMap = new HashMap();
        ConfigSource.loadBaseColumns();
        ConfigSource.loadTables();
        ConfigSource.loadDirs();
        fileMap = new HashMap();
    }

    public static void signServer(String server, boolean flag) {
        serverMap.put(server, flag);
    }

    public static boolean isServerNormal(String server) {
        return !serverMap.containsKey(server) || (Boolean)serverMap.get(server) != false;
    }

    public static boolean isFileSync(File file, String server) {
        if (fileMap.containsKey(server)) {
            String key = FileUtils.path((String[])new String[]{file.getPath()});
            String val = (String)((Map)fileMap.get(server)).get(key);
            if (StringUtils.isNotBlank((CharSequence)val)) {
                return val.equals(FileUtils.getMd5((String)file.getPath()));
            }
        }
        return false;
    }

    public static TrayColumnItem getColumnType(String tableName, String columnName) {
        TrayColumnItem c;
        Map tableColumns;
        if (columnTypes == null) {
            columnTypes = new HashMap();
        }
        if ((tableColumns = (Map)columnTypes.get(tableName)) == null || tableColumns.isEmpty()) {
            ConfigSource.initTypes((String)tableName);
        }
        if ((tableColumns = (Map)columnTypes.get(tableName)) != null && (c = (TrayColumnItem)tableColumns.get(columnName)) != null) {
            return c;
        }
        log.error(columnTypes.toString());
        throw new ZKBusinessException("get column error: table[" + tableName + "] column[" + columnName + "]");
    }

    public static void signFile(String filePath, String server) {
        HashMap<String, String> map = (HashMap<String, String>)fileMap.get(server);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (FileUtils.exists((String)filePath)) {
            map.put(FileUtils.path((String[])new String[]{filePath}), FileUtils.getMd5((String)filePath));
        }
        fileMap.put(server, map);
    }

    private static void loadBaseColumns() {
        try {
            baseColumns = new HashMap();
            Field[] fields = FieldUtils.getFieldsWithAnnotation(BaseColumn.class, JSONField.class);
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    JSONField json = field.getAnnotation(JSONField.class);
                    baseColumns.put(json.name(), "1");
                }
            }
        }
        catch (Exception e) {
            log.error("Load Base Column Failed", (Throwable)e);
        }
    }

    private static void loadDirs() {
        dirs = new ArrayList();
        String path = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), "tray.ini"});
        Map map = IniUtils.getSection((String)path, (String)"dirs");
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                dirs.add(entry.getValue());
            }
        }
    }

    private static void loadColumns() {
        columns = new HashMap();
        String path = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), "tray.ini"});
        for (RecordBean table : tables) {
            Map cols = IniUtils.getSection((String)path, (String)table.getTable());
            if (cols.isEmpty()) continue;
            columns.put(table.getTable(), cols);
        }
    }

    private static void loadTables() {
        tables = new ArrayList();
        String path = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), "tray.ini"});
        Map map = IniUtils.getSection((String)path, (String)"tables");
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                RecordBean table = new RecordBean();
                table.setTable((String)entry.getKey());
                table.setUniqueColumn((String)entry.getValue());
                tables.add(table);
                ConfigSource.initTypes((String)table.getTable());
            }
            ConfigSource.loadColumns();
        }
    }

    public static List<RecordBean> getTables() {
        if (tables == null || tables.isEmpty()) {
            ConfigSource.loadTables();
        }
        return tables;
    }

    public static RecordBean getTableByName(String tableName) {
        for (RecordBean table : tables) {
            if (!tableName.equals(table.getTable())) continue;
            return table;
        }
        return null;
    }

    public static List<String> getDirs() {
        if (dirs == null || dirs.isEmpty()) {
            ConfigSource.loadDirs();
        }
        return dirs;
    }

    public static Map<String, String> getColumns(String table) {
        HashMap<String, String> cols = (HashMap<String, String>)columns.get(table);
        if (cols == null) {
            cols = new HashMap<String, String>();
        } else {
            cols.putAll(baseColumns);
        }
        return cols;
    }

    public static Map<String, String> getLinkColumns(String table) {
        Map cols = ConfigSource.getColumns((String)table);
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!cols.isEmpty()) {
            for (Map.Entry entry : cols.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) || "1".equals(entry.getValue())) continue;
                ret.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return ret;
    }

    static {
        ConfigSource.init();
    }
}

