/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.config;

import com.zkteco.tray.annotation.Column;
import com.zkteco.tray.annotation.DateType;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.SQLQuery;
import org.hibernate.type.BooleanType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

/*
 * Exception performing whole class analysis ignored.
 */
public class AddScalar {
    private static final char SEPARATOR = '_';

    public static void addSclar(SQLQuery sqlQuery, Class clazz) {
        Field[] fields;
        if (clazz == null) {
            throw new NullPointerException("[clazz] could not be null!");
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            String columnName = AddScalar.toUnderlineName((String)field.getName());
            columnName = field.getName();
            if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                sqlQuery.addScalar(columnName, (Type)LongType.INSTANCE);
                continue;
            }
            if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                sqlQuery.addScalar(columnName, (Type)IntegerType.INSTANCE);
                continue;
            }
            if (field.getType() == Character.TYPE || field.getType() == Character.class) {
                sqlQuery.addScalar(columnName, (Type)CharacterType.INSTANCE);
                continue;
            }
            if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                sqlQuery.addScalar(columnName, (Type)ShortType.INSTANCE);
                continue;
            }
            if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                sqlQuery.addScalar(columnName, (Type)DoubleType.INSTANCE);
                continue;
            }
            if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                sqlQuery.addScalar(columnName, (Type)FloatType.INSTANCE);
                continue;
            }
            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                sqlQuery.addScalar(columnName, (Type)BooleanType.INSTANCE);
                continue;
            }
            if (field.getType() == String.class) {
                sqlQuery.addScalar(columnName, (Type)StringType.INSTANCE);
                continue;
            }
            if (field.getType() != Date.class && field.getType() != Timestamp.class) continue;
            DateType dateType = field.getAnnotation(DateType.class);
            if (dateType != null) {
                switch (dateType.type()) {
                    case "date": {
                        sqlQuery.addScalar(columnName, (Type)org.hibernate.type.DateType.INSTANCE);
                        break;
                    }
                    case "time": {
                        sqlQuery.addScalar(columnName, (Type)TimeType.INSTANCE);
                        break;
                    }
                    case "timestamp": {
                        sqlQuery.addScalar(columnName, (Type)TimestampType.INSTANCE);
                    }
                }
                continue;
            }
            sqlQuery.addScalar(columnName, (Type)TimestampType.INSTANCE);
        }
    }

    public static String toUnderlineName(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

