/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.utils.HttpUtils;
import com.zkteco.tray.vo.TrayParamsItem;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableAsync;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"com.zkteco"})
@EnableAsync
public class BioSecurityApp {
    private static final Logger log = LoggerFactory.getLogger(BioSecurityApp.class);

    public static void run(String[] args) {
        BioSecurityApp.loadConfigFile();
        TrayParamsItem params = ExecUtils.getNParams((boolean)true);
        BioSecurityApp.checkActive((TrayParamsItem)params);
        System.setProperty("system.language", params.getSystemLanguage());
        BioSecurityApp.copySSL((TrayParamsItem)params);
        SpringApplication springApplication = new SpringApplication(new Class[]{BioSecurityApp.class});
        springApplication.run(args);
    }

    private static void copySSL(TrayParamsItem params) {
        if (Boolean.TRUE.toString().equals(params.getServerSslEnable())) {
            String root = FileUtils.getRootPath(null);
            if (StringUtils.isBlank((CharSequence)root)) {
                return;
            }
            List sslPath = FileUtils.findFiles((String)FileUtils.path((String[])new String[]{root, "service"}), (String)".*\\.p12", null);
            if (sslPath == null || sslPath.isEmpty()) {
                return;
            }
            File p12 = (File)sslPath.get(0);
            String dist = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), p12.getName()});
            FileUtils.deleteFile((String)dist);
            FileUtils.copy((String)p12.getPath(), (String)dist);
            JSONObject config = new JSONObject();
            config.put("security.require-ssl", (Object)"true");
            config.put("server.ssl.protocol", (Object)"TLSv1.2");
            config.put("server.ssl.ciphers", (Object)"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
            config.put("server.ssl.key-store", (Object)p12.getName());
            config.put("server.ssl.key-store-password", (Object)"ZKTeco185***");
            config.put("server.ssl.keyStoreType", (Object)"PKCS12");
            config.put("server.ssl.keyAlias", (Object)"1");
            System.setProperty("SPRING_APPLICATION_JSON", config.toJSONString());
        }
    }

    private static void loadConfigFile() {
        String path = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), "tray.ini"});
        if (!FileUtils.exists((String)path)) {
            FileUtils.saveFile((String)path, (InputStream)BioSecurityApp.class.getResourceAsStream("/script/tray.ini"));
        }
    }

    private static void checkActive(TrayParamsItem params) {
        String url = Boolean.TRUE.toString().equals(params.getServerSslEnable()) ? "https" : "http";
        url = url + "://127.0.0.1:" + params.getPort();
        try {
            HttpUtils.get((String)url);
        }
        catch (Exception e) {
            CommonUtils.sleep((long)30000L);
            log.info("Recheck Server");
            BioSecurityApp.checkActive((TrayParamsItem)params);
        }
    }

    public static void main(String[] args) {
        BioSecurityApp.run((String[])args);
    }
}

