/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisWfFlowRemote;
import com.zkteco.zkbiosecurity.vis.service.VisWfFlowService;
import com.zkteco.zkbiosecurity.vis.vo.VisWfFlowItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWfFlowNodeItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisWfFlowController
extends BaseController
implements VisWfFlowRemote {
    @Autowired
    private VisWfFlowService visWfFlowService;

    public ZKResultMsg getItemByFlowType(String flowType) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        VisWfFlowItem wfFlow = new VisWfFlowItem();
        wfFlow.setFlowType(flowType);
        wfFlow.setValidFlag(Short.valueOf((short)0));
        List wfFlows = this.visWfFlowService.getFlowItemByCondition(wfFlow);
        if (wfFlows != null) {
            zkResultMsg.setData(wfFlows.get(0));
        }
        return zkResultMsg;
    }

    public ModelAndView editFlow(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisWfFlowItem wfFlowItem = this.visWfFlowService.getFlowItemById(id);
            this.request.setAttribute("item", (Object)wfFlowItem);
        }
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("vis/flow/editWfFlow");
    }

    @RequiresPermissions(value={"vis:flow:edit"})
    public ModelAndView editFlowNode() {
        String nodeItem = this.request.getParameter("nodeItem");
        if (StringUtils.isNotBlank((CharSequence)nodeItem)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                VisWfFlowNodeItem item = (VisWfFlowNodeItem)objectMapper.readValue(nodeItem, VisWfFlowNodeItem.class);
                this.request.setAttribute("item", (Object)item);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new ModelAndView("vis/flow/editWfFlowNode");
    }

    public DxGrid nodeList(VisWfFlowNodeItem condition) {
        Pager pager = new Pager();
        pager.setData(new ArrayList());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg save(VisWfFlowItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String wfflowNodeStrs = this.request.getParameter("wfflowNodeStrs");
        List flowNodeItems = JSONArray.parseArray((String)wfflowNodeStrs, VisWfFlowNodeItem.class);
        item.setWfflowNodeItems(flowNodeItems);
        this.visWfFlowService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg checkRuntimeProcessByFlowId(String flowId) {
        this.visWfFlowService.checkRuntimeProcessByFlowId(flowId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

