/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ApplicationPropertiesUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileType;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisWathcListRemote;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListCategoryService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListService;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWatchListCategoryItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWatchListItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWatchListThumbnailsItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class VisWatchListController
extends BaseController
implements VisWathcListRemote {
    @Autowired
    private VisWatchListService visWatchListService;
    @Autowired
    private VisWatchListCategoryService visWatchListCategoryService;
    @Autowired
    private VisVisitorService visVisitorService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    VisTransactionService visTransactionService;
    @Value(value="${system.language}")
    private String sysLanguage;
    private Pattern pattern = Pattern.compile("[0-9]*");

    @RequiresPermissions(value={"vis:watchList"})
    public ModelAndView watchListView() {
        return new ModelAndView("vis/watchList/visWatchList");
    }

    @RequiresPermissions(value={"vis:watchList:refresh"})
    public DxGrid list(VisWatchListItem condition) {
        Pager pager = this.visWatchListService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getWatchListInfo(String cerType, String cerNum) {
        ZKResultMsg res = ZKResultMsg.successMsg();
        VisWatchListItem item = this.visWatchListService.findByCerTypeAndCerNum(cerType, cerNum);
        if (item != null && item.getEnabled() != null && item.getEnabled().equals(1)) {
            res.setData((Object)item);
        }
        return res;
    }

    @RequiresPermissions(value={"vis:watchList:add"})
    public ModelAndView addView(@RequestParam(value="id", required=false) String id, @RequestParam(value="thumb", required=false) String thumb) {
        VisWatchListItem visWatchListItem;
        ModelAndView modelAndView = new ModelAndView("vis/watchList/editWatchList");
        if (thumb != null) {
            modelAndView.addObject("thumb", (Object)",true");
        }
        modelAndView.addObject("blackCategory", (Object)this.visWatchListCategoryService.blackCategoryId());
        if (StringUtils.isNotBlank((CharSequence)id) && (visWatchListItem = this.visWatchListService.findById(id)) != null) {
            if (StringUtils.isNotBlank((CharSequence)visWatchListItem.getCertPhoto())) {
                String certPhotoPath = visWatchListItem.getCertPhoto();
                if (certPhotoPath.indexOf("upload") > 0) {
                    certPhotoPath = certPhotoPath.substring(certPhotoPath.indexOf("upload") - 1);
                }
                String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)certPhotoPath);
                visWatchListItem.setCertPhotoBase64("data:image/jpg;base64," + photoBase64);
            }
            if (StringUtils.isNotBlank((CharSequence)visWatchListItem.getRejectDates())) {
                String rejectDateStr = visWatchListItem.getRejectDates();
                String[] rejectDateArr = rejectDateStr.split(";");
                StringBuilder rejectDates = new StringBuilder();
                for (String rejectDate : rejectDateArr) {
                    rejectDate = rejectDate.trim().replaceAll("\r\n", "");
                    Date date = DateUtil.stringToDate((String)rejectDate, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
                    rejectDate = DateUtil.dateToLocaleString((Date)date, (String)ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateTimeFmt.alias", (String)"yyyy-MM-dd HH:mm:ss"));
                    rejectDates.append(rejectDate + ";\r\n");
                }
                visWatchListItem.setRejectDates(rejectDates.toString());
            }
            modelAndView.addObject("watchList", (Object)visWatchListItem);
        }
        return modelAndView;
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_watchList", opType="common_op_edit", requestParams={"name", "company", "nationalityName"}, opContent="pers_person_name")
    public ZKResultMsg addList(VisWatchListItem visWatchListItem, @RequestParam(value="photoType", required=false) String photoType) {
        String photoPath;
        File photo;
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        if (visWatchListItem.getSetWatchTime() == null || !visWatchListItem.getSetWatchTime().booleanValue()) {
            visWatchListItem.setStartWatchTime(null);
            visWatchListItem.setEndWatchTime(null);
        }
        if (StringUtils.isNotBlank((CharSequence)visWatchListItem.getCertPhoto()) && visWatchListItem.getCertPhoto() != "" && StringUtils.isNotBlank((CharSequence)photoType) && (photo = new File(FileUtil.getLocalFullPath((String)(photoPath = this.visWatchListService.savePhoto(visWatchListItem, photoType))))).exists() && photo.length() > 1L) {
            visWatchListItem.setCertPhoto(photoPath);
        }
        if (StringUtils.isNotBlank((CharSequence)visWatchListItem.getNationality()) && visWatchListItem.getNationality() != null && !this.pattern.matcher(visWatchListItem.getNationality()).matches()) {
            if (StringUtils.isNotBlank((CharSequence)this.visWatchListService.findBaseDicKeyByValue("PersNationality", visWatchListItem.getNationality()))) {
                visWatchListItem.setNationality(this.visWatchListService.findBaseDicKeyByValue("PersNationality", visWatchListItem.getNationality()));
                visWatchListItem.setNationalityName(visWatchListItem.getNationalityName());
            } else {
                throw new ZKBusinessException("no such National info");
            }
        }
        this.visWatchListService.addList(visWatchListItem);
        return zkResultMsg;
    }

    @RequiresPermissions(value={"vis:watchListCategory"})
    public ModelAndView watchListCategoryView() {
        return new ModelAndView("vis/watchList/visWatchListCategory");
    }

    @RequiresPermissions(value={"vis:watchListCategory:refresh"})
    public DxGrid categoryList(VisWatchListCategoryItem condition) {
        Pager pager = this.visWatchListCategoryService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:watchListCategory:add"})
    @LogRequest(module="vis_module", object="vis_leftMenu_watchListCategory", opType="common_op_edit", requestParams={"category"}, opContent="vis_watchList_category")
    public ZKResultMsg postCategory(VisWatchListCategoryItem item) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        this.visWatchListCategoryService.saveCategory(item);
        return resultMsg;
    }

    public ModelAndView categoryView() {
        return new ModelAndView("vis/watchList/editWatchListCategory");
    }

    @RequiresPermissions(value={"vis:watchListCategory:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_watchListCategory", opType="common_op_del", requestParams={"ids"}, opContent="common_number")
    public ZKResultMsg deleteCategorys(String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        this.visWatchListCategoryService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"vis:watchList:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_watchList", opType="common_op_del", requestParams={"ids"}, opContent="common_number")
    public ZKResultMsg deleteWatchLists(String ids) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        this.visWatchListService.deleteByIds(ids);
        return zkResultMsg;
    }

    public ZKResultMsg allCategory(String un) {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        List resLi = this.visWatchListCategoryService.listAll();
        for (VisWatchListCategoryItem v : resLi) {
            selectItemList.add(new SelectItem((Object)I18nUtil.i18nCode((String)v.getCategory(), (Object[])new Object[0]), v.getId()));
        }
        return new ZKResultMsg(selectItemList);
    }

    @RequiresPermissions(value={"vis:watchList:disable", "vis:watchList:enable"})
    @LogRequest(module="vis_module", object="vis_leftMenu_watchList", opType="common_op_edit", requestParams={"enable"}, opContent="vis_emp_enable")
    public ZKResultMsg changeWatchListStatus(String ids, boolean enable) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        this.visWatchListService.changeStatus(ids, enable);
        return zkResultMsg;
    }

    @RequiresPermissions(value={"vis:watchListThumbnails"})
    public ModelAndView watchListThumbnailsView() {
        ModelAndView modelAndView = new ModelAndView("vis/watchList/visWatchListThumbnails");
        return modelAndView;
    }

    @RequiresPermissions(value={"vis:watchList:addToWatchList"})
    public ModelAndView addFromList(@RequestParam(value="id", required=false) String id) {
        VisVisitorItem visVisitorItem;
        ModelAndView modelAndView = new ModelAndView("vis/watchList/editWatchList");
        modelAndView.addObject("blackCategory", (Object)this.visWatchListCategoryService.blackCategoryId());
        if (StringUtils.isNotBlank((CharSequence)id) && (visVisitorItem = this.visVisitorService.getItemById(id)) != null) {
            VisWatchListItem visWatchList;
            VisWatchListItem visWatchListItem = new VisWatchListItem();
            visWatchListItem.setName(visVisitorItem.getName());
            visWatchListItem.setLastName(visVisitorItem.getLastName());
            visWatchListItem.setCertType(visVisitorItem.getCertType());
            visWatchListItem.setCertNumber(visVisitorItem.getCertNumber());
            visWatchListItem.setCategory(visVisitorItem.getStatus());
            VisTransactionItem transaction = this.visTransactionService.getItemByPinAndState(visVisitorItem.getPin());
            if (transaction != null && StringUtils.isNotBlank((CharSequence)transaction.getEnterPhoto())) {
                visWatchListItem.setCertPhoto(transaction.getEnterPhoto());
            }
            if ((visWatchList = this.visWatchListService.findByCerTypeAndCerNum(visVisitorItem.getCertType(), visVisitorItem.getCertNumber())) != null) {
                visWatchListItem.setCategory(visWatchList.getCategory());
                visWatchListItem.setSetWatchTime(visWatchList.getSetWatchTime());
                visWatchListItem.setStartWatchTime(visWatchList.getStartWatchTime());
                visWatchListItem.setEndWatchTime(visWatchList.getEndWatchTime());
                visWatchListItem.setRemark(visWatchList.getRemark());
                visWatchListItem.setRejectCount(visWatchList.getRejectCount());
                visWatchListItem.setRejectDates(visWatchList.getRejectDates());
            }
            modelAndView.addObject("watchList", (Object)visWatchListItem);
            modelAndView.addObject("certificateDisable", (Object)"disable");
        }
        return modelAndView;
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_watchList", opType="common_op_del", requestParams={"ids"}, opContent="common_number")
    @RequiresPermissions(value={"vis:watchList:removeFromWatchList"})
    public ZKResultMsg delFromList(String ids) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        this.visWatchListService.delByVisitorIds(ids);
        return resultMsg;
    }

    public ZKResultMsg matchingWatchList(String cerType, String cerNamber, String firstName, String lastName, String nationality, String company) {
        if (!this.visWatchListService.checkLicense()) {
            JSONObject resJson = new JSONObject();
            resJson.put("rows", null);
            return new ZKResultMsg((Object)resJson);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Map param = this.visParamsService.getVisParams();
        if (param != null) {
            String ckName = (String)param.get("vis.isUseCKName");
            String wlCKName = (String)param.get("vis.wlCKName");
            if (ckName != null && ckName.equals("1")) {
                if (wlCKName.equals("1")) {
                    map.put("name", firstName);
                } else if (wlCKName.equals("2")) {
                    map.put("name", firstName);
                    map.put("lastName", lastName);
                }
            }
            if (param.get("vis.wlCKCertificate") != null && ((String)param.get("vis.wlCKCertificate")).equals("1")) {
                map.put("cerType", cerType);
                map.put("cerNamber", cerNamber);
            }
            if (param.get("vis.wlCKCountry") != null && ((String)param.get("vis.wlCKCountry")).equals("1")) {
                map.put("nationality", nationality);
            }
            if (param.get("vis.wlCKCompany") != null && ((String)param.get("vis.wlCKCompany")).equals("1")) {
                map.put("company", company);
            }
        }
        List visWatchListItemList = this.visWatchListService.matchingWatchList(map);
        return new ZKResultMsg((Object)this.matchListToJsonForShow(visWatchListItemList));
    }

    public ModelAndView matchingView() {
        ModelAndView modelAndView = new ModelAndView("vis/watchList/visWatchListMatch");
        return modelAndView;
    }

    private JSONObject matchListToJsonForShow(List<VisWatchListItem> matchList) {
        JSONObject json = new JSONObject();
        JSONArray rows = new JSONArray();
        try {
            for (VisWatchListItem watchList : matchList) {
                JSONObject temp = new JSONObject();
                JSONObject userdata = new JSONObject();
                JSONArray tempArray = new JSONArray();
                temp.put("id", (Object)watchList.getId());
                tempArray.add((Object)"");
                switch (watchList.getWatchListType()) {
                    case "1": {
                        if (!"zh_CN".equals(this.sysLanguage)) {
                            tempArray.add((Object)(watchList.getName() + (StringUtils.isEmpty((CharSequence)watchList.getLastName()) ? "" : "," + watchList.getLastName())));
                        } else {
                            tempArray.add((Object)watchList.getName());
                        }
                        userdata.put("certType", (Object)this.visWatchListService.findBaseDicValueByKey("certificateType", watchList.getCertType()));
                        userdata.put("certNumber", (Object)watchList.getCertNumber());
                        userdata.put("certPhotoBase64", (Object)watchList.getCertPhotoBase64());
                        break;
                    }
                    case "2": {
                        tempArray.add((Object)watchList.getCompany());
                        userdata.put("address", (Object)watchList.getAddress());
                        break;
                    }
                    case "3": {
                        tempArray.add((Object)watchList.getNationalityName());
                        break;
                    }
                    default: {
                        System.out.println("\u7c7b\u578b\u4e0d\u5c5e\u4e8e123");
                    }
                }
                userdata.put("aliases", (Object)watchList.getAliases());
                userdata.put("type", (Object)watchList.getWatchListType());
                userdata.put("setValidTime", (Object)watchList.getSetWatchTime());
                if (watchList.getSetWatchTime() != null && watchList.getStartWatchTime() != null && watchList.getEndWatchTime() != null) {
                    userdata.put("startTime", (Object)DateUtil.dateToLocaleString((Date)watchList.getStartWatchTime(), (String)ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateTimeFmt.alias", (String)"yyyy-MM-dd HH:mm:ss")));
                    userdata.put("endTime", (Object)DateUtil.dateToLocaleString((Date)watchList.getEndWatchTime(), (String)ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateTimeFmt.alias", (String)"yyyy-MM-dd HH:mm:ss")));
                }
                userdata.put("remark", (Object)watchList.getRemark());
                if (StringUtils.isNotBlank((CharSequence)this.visWatchListCategoryService.findByID(watchList.getCategory()))) {
                    tempArray.add((Object)this.visWatchListCategoryService.findByID(watchList.getCategory()));
                } else {
                    System.err.println("watchList\uff1a---------------\u8fd4\u56de\u5339\u914d\u7ed3\u679c\u65f6\u5c5e\u6027id\u503c\u4e3a\u7a7a-----------");
                }
                tempArray.add((Object)(watchList.getRejectCount() == null ? 0 : watchList.getRejectCount()));
                temp.put("data", (Object)tempArray);
                temp.put("userdata", (Object)userdata);
                rows.add((Object)temp);
            }
            json.put("rows", (Object)rows);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_watchList", opType="vis_watchList_rejection", requestParams={"id"}, opContent="common_number")
    public ZKResultMsg denyPlus(String id, String visTranData) {
        this.visWatchListService.denyPlus(id, this.request.getSession().getId(), visTranData);
        return null;
    }

    @RequiresPermissions(value={"vis:watchListThumbnails:refresh"})
    public DxGrid thumbnailsList(VisWatchListThumbnailsItem condition) {
        Pager pager = this.visWatchListService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        pager.getData().forEach(item -> {
            VisWatchListThumbnailsItem visItem = (VisWatchListThumbnailsItem)item;
            if (Objects.isNull(visItem.getSetWatchTime()) || !visItem.getSetWatchTime().booleanValue()) {
                visItem.setStartWatchTime(null);
                visItem.setEndWatchTime(null);
            }
        });
        DxGrid dxGrid = GridUtil.convert((Pager)pager, condition.getClass());
        List dxRowList = dxGrid.getRows();
        ArrayList<JSONObject> newDxList = new ArrayList<JSONObject>();
        int index = 0;
        String enable = this.visParamsService.getVisParamByName("vis.photo.encryptProp");
        boolean encryptProp = StringUtils.isNotBlank((CharSequence)enable) && "true".equals(enable);
        for (Object jsOb : dxRowList) {
            ++index;
            JSONObject JSOb = (JSONObject)jsOb;
            JSONArray newRow = (JSONArray)JSOb.get((Object)"data");
            String img = "/images/PC/userImage.png";
            if (StringUtils.isNotBlank((CharSequence)(newRow.get(1) + ""))) {
                String photoBase64;
                String certPhotoPath = newRow.get(1) + "";
                if (certPhotoPath.indexOf("upload") > 0) {
                    certPhotoPath = certPhotoPath.substring(certPhotoPath.indexOf("upload") - 1);
                }
                if (StringUtils.isNotBlank((CharSequence)(photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)certPhotoPath))) && encryptProp) {
                    photoBase64 = ImgEncodeUtil.base64BoxBlurFilter((String)photoBase64);
                }
                img = "data:image/jpg;base64," + photoBase64;
            }
            String onloadFun = "";
            if (index == 1) {
                onloadFun = " onload='showVo()' ";
            }
            String showImg = "<img src=' " + img + " ' onerror='thumImgerrorfun()' onclick=' newCategory(\"" + newRow.get(0) + "\") ' " + onloadFun + " class='thumImg' />";
            newRow.set(1, (Object)showImg);
            JSOb.put("data", (Object)newRow);
            newDxList.add(JSOb);
        }
        dxGrid.setRows(newDxList);
        return dxGrid;
    }

    public ModelAndView editCategory(String id) {
        VisWatchListCategoryItem visWatchListCategoryItem;
        if (StringUtils.isNotBlank((CharSequence)id) && !Objects.isNull(visWatchListCategoryItem = this.visWatchListCategoryService.findItemById(id))) {
            this.request.setAttribute("item", (Object)visWatchListCategoryItem);
        }
        return new ModelAndView("vis/watchList/editWatchListCategory");
    }

    public String isExecCategory(String category) {
        boolean isExec = this.visWatchListCategoryService.isExecCategory(category);
        isExec = !isExec;
        return String.valueOf(isExec);
    }

    public String isExecWatchList(String carType, String carNumber) {
        VisWatchListItem visWatchListItem = this.visWatchListService.findByCert(carType, carNumber);
        if (Objects.isNull(visWatchListItem) || StringUtils.isBlank((CharSequence)visWatchListItem.getId())) {
            return String.valueOf(true);
        }
        return String.valueOf(false);
    }

    public String isExecWatchListCompany(String company) {
        VisWatchListItem visWatchListItem = this.visWatchListService.findByCompany(company);
        if (Objects.isNull(visWatchListItem) || StringUtils.isBlank((CharSequence)visWatchListItem.getId())) {
            return String.valueOf(true);
        }
        return String.valueOf(false);
    }

    public String isExecWatchListNationality(String nationality) {
        VisWatchListItem visWatchListItem = this.visWatchListService.findByNationality(nationality);
        if (Objects.isNull(visWatchListItem) || StringUtils.isBlank((CharSequence)visWatchListItem.getId())) {
            return String.valueOf(true);
        }
        return String.valueOf(false);
    }

    public ModelAndView opWatchListCapture() {
        String imgSrc;
        String imgId = this.request.getParameter("imgId");
        if (StringUtils.isNotBlank((CharSequence)imgId)) {
            this.request.setAttribute("imgId", (Object)imgId);
        }
        if (StringUtils.isNotBlank((CharSequence)(imgSrc = this.request.getParameter("imgSrc")))) {
            if (imgSrc.contains(".")) {
                String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)imgSrc);
                this.request.setAttribute("imgSrc", (Object)("data:image/jpg;base64," + photoBase64));
            } else {
                this.request.setAttribute("imgSrc", (Object)imgSrc);
            }
        }
        return new ModelAndView("vis/watchList/opWatchListContent");
    }

    public String validPhoto(@RequestParam(value="personPhoto") MultipartFile file) {
        boolean jpgImage = false;
        try {
            InputStream inputStream = file.getInputStream();
            jpgImage = ImgEncodeUtil.isSupportImageType((InputStream)inputStream, (FileType[])new FileType[]{FileType.GIF, FileType.JPEG, FileType.PNG, FileType.BMP});
        }
        catch (IOException e) {
            this.log.error("validPhoto error", (Throwable)e);
        }
        return jpgImage + "";
    }
}

