/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisVisitedPersonLevelRemote;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonLevelItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VisVisitedPersonLevelController
extends BaseController
implements VisVisitedPersonLevelRemote {
    @Autowired
    private VisVisitedPersonLevelService visVisitedPersonLevelService;

    @RequiresPermissions(value={"vis:personLevel:refresh"})
    public DxGrid list(VisVisitedPersonLevelItem condition) {
        Pager pager = this.visVisitedPersonLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:selectPersonLevel", "vis:level:selectBatchPersonLevel"})
    @LogRequest(module="vis_module", object="vis_leftMenu_person", opType="vis_level_visitedLevel", requestParams={"persPins", "levelName"}, opContent="common_level_name")
    public ZKResultMsg addLevel() {
        String perIds = this.request.getParameter("perIds");
        String levelIds = this.request.getParameter("levelIds");
        this.visVisitedPersonLevelService.addBatchLevel(perIds, levelIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:personLevel:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_person", opType="common_op_del", requestParams={"persPin", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visVisitedPersonLevelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

