/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisVisitedPersonRemote;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisAlertTemplatePersonSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonSelectItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisVisitedPersonController
extends BaseController
implements VisVisitedPersonRemote {
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;
    @Autowired
    private VisVisitorLevelService visVisitorLevelService;
    private Logger logger = LoggerFactory.getLogger(VisVisitedPersonController.class);

    @RequiresPermissions(value={"vis:visitedPerson"})
    public ModelAndView index() {
        return new ModelAndView("vis/visitedPerson/visVisitedPerson");
    }

    @RequiresPermissions(value={"vis:visitedPerson:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visVisitedPersonService.getItemById(id));
        }
        return new ModelAndView("vis/person/editVisPerson");
    }

    @RequiresPermissions(value={"vis:visitedPerson:edit"})
    public ZKResultMsg save(VisVisitedPersonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visVisitedPersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:visitedPerson:refresh"})
    public DxGrid list(VisVisitedPersonItem condition) {
        Pager pager = this.visVisitedPersonService.getItemsByPageFilterDept(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:visitedPerson:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_person", opType="common_op_del", requestParams={"persPins"}, opContent="vis_record_visitedPin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visVisitedPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:visitedPerson:edit"})
    @LogRequest(module="vis_module", object="vis_leftMenu_person", opType="common_op_new", requestParams={"persPins"}, opContent="vis_record_visitedPin")
    public ZKResultMsg savePerson() {
        String personIds = this.request.getParameter("personIds");
        String deptIds = this.request.getParameter("deptIds");
        String checkVal = this.request.getParameter("checkVal");
        if ("2".equals(checkVal) && StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.visVisitedPersonService.getPersonIdsFilterByDeptIds(deptIds);
        }
        if ("3".equals(checkVal)) {
            personIds = this.visVisitedPersonService.getAllPersonIds();
        }
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            try {
                List personIdList = StrUtil.strToList((String)personIds);
                List personArrayIds = this.visVisitorLevelService.cutVisIdsToArray(personIdList, 200);
                int total = personArrayIds.size();
                for (int i = 0; i < total; ++i) {
                    this.visVisitedPersonService.savePerson((String)personArrayIds.get(i));
                    personArrayIds.set(i, null);
                    System.gc();
                }
            }
            catch (Exception e) {
                this.logger.error("savePerson error", (Throwable)e);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:visitedPerson:refresh"})
    public DxGrid selectVisitedPersonlist(VisVisitedPersonSelectItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.visVisitedPersonService.getNoExistPersonFilterDept(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getPersonCountByDeptIds(@RequestParam(value="deptIds") String deptIds) {
        int personCount = this.visVisitedPersonService.getPersonCountByDeptIds(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    public DxGrid selectTemplatePersonlist(VisAlertTemplatePersonSelectItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.visVisitedPersonService.getNoExistTemplatePerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:visitedPerson:authorized"})
    public ModelAndView authorizedExemptionInvitation(@RequestParam(value="ids") String ids) {
        String persPins = this.visVisitedPersonService.getPersonPinsByIds(ids);
        this.request.setAttribute("selectedPersPins", (Object)persPins);
        return new ModelAndView("vis/visitedPerson/authorizedExemptionInvitation");
    }

    @RequiresPermissions(value={"vis:visitedPerson:authorized"})
    public ZKResultMsg saveExemptionInvitation(@RequestParam(value="persPins") String persPins, @RequestParam(value="isAuthorized") String isAuthorized) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        VisVisitedPersonItem visVisitedPersonItem = new VisVisitedPersonItem();
        visVisitedPersonItem.setInPersonPin(persPins);
        List visVisitedPersonItems = this.visVisitedPersonService.getByCondition(visVisitedPersonItem);
        if (CollectionUtils.isNotEmpty((Collection)visVisitedPersonItems)) {
            for (VisVisitedPersonItem visitedPersonItem : visVisitedPersonItems) {
                if (StringUtils.equals((CharSequence)"true", (CharSequence)isAuthorized)) {
                    visitedPersonItem.setVisExemptInvite("1");
                } else {
                    visitedPersonItem.setVisExemptInvite("0");
                }
                this.visVisitedPersonService.saveItem(visitedPersonItem);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

