/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisTransactionRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisTransactionController
extends ExportController
implements VisTransactionRemote {
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisAttributeService visAttributeService;
    @Autowired
    private VisVisitorService visVisitorService;

    @RequiresPermissions(value={"vis:transaction"})
    public ModelAndView index() {
        return new ModelAndView("vis/transaction/visTransaction");
    }

    @RequiresPermissions(value={"vis:transaction:refresh"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisTransactionItem item = this.visTransactionService.getItemById(id);
            item = this.visTransactionService.decryptVisPhoto(item);
            this.request.setAttribute("item", (Object)item);
            Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisEmpId());
            this.request.setAttribute("map1", (Object)valueMap);
        }
        String supportDevice = this.visParamsService.getVisParamByName("vis.supportDevice");
        this.request.setAttribute("supportDevice", (Object)supportDevice);
        this.request.setAttribute("showSignature", (Object)this.visTransactionService.isShowSignature());
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        return new ModelAndView("vis/transaction/editVisTransaction");
    }

    private void getAttribute(List<VisAttributeItem> attributeItems) {
        ArrayList rows = new ArrayList();
        ArrayList<Integer> rowInts = new ArrayList<Integer>();
        HashMap<String, ArrayList<Integer>> maxTds = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, VisAttributeItem> attrs = new HashMap<String, VisAttributeItem>();
        for (VisAttributeItem attributeItem : attributeItems) {
            ArrayList<Integer> colList;
            Integer row = attributeItem.getPositionX();
            Integer col = attributeItem.getPositionY();
            if (!rowInts.contains(row)) {
                rowInts.add(row);
            }
            if ((colList = (ArrayList<Integer>)maxTds.get("" + row)) == null) {
                colList = new ArrayList<Integer>();
            }
            colList.add(col);
            Collections.sort(colList);
            maxTds.put("" + row, colList);
            attrs.put("" + row + col, attributeItem);
        }
        Collections.sort(rowInts);
        CollectionUtils.collect(rowInts, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return o.toString();
            }
        }, rows);
        this.request.setAttribute("attrs", attrs);
        this.request.setAttribute("tds", maxTds);
        this.request.setAttribute("trs", rows);
    }

    @RequiresPermissions(value={"vis:transaction:edit"})
    public ZKResultMsg save(VisTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:transaction:refresh"})
    public DxGrid list(VisTransactionItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.visTransactionService.getItemsAndAttrByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"vis:transaction:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_record", opType="common_op_del", requestParams={"visEmpPins", "visitedEmpPins"}, opContent="vis_emp_pin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        ZKResultMsg zKResultMsg = this.visTransactionService.deleteByTransactionIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"vis:transaction:export"})
    @LogRequest(module="vis_module", object="vis_leftMenu_record", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VisTransactionItem visTransactionItem = new VisTransactionItem();
        this.setConditionValue((BaseItem)visTransactionItem);
        List itemList = this.visTransactionService.getItemData(VisTransactionItem.class, (BaseItem)visTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, VisTransactionItem.class);
    }
}

