/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisReservationInvitationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisReservationInvitationService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationInvitationItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisReservationInvitationController
extends BaseController
implements VisReservationInvitationRemote {
    @Autowired
    private VisReservationInvitationService visReservationInvitationService;

    @RequiresPermissions(value={"vis:reservationInvitation"})
    public ModelAndView index() {
        return new ModelAndView("vis/reservation/visReservationInvitation");
    }

    @RequiresPermissions(value={"vis:reservationInvitation:refresh"})
    public DxGrid list(VisReservationInvitationItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.visReservationInvitationService.getItemListByPage(condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"vis:reservationInvitation:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visReservationInvitationService.getItemById(id));
        }
        return new ModelAndView("vis/reservation/editVisReservationInvitation");
    }

    @RequiresPermissions(value={"vis:reservationInvitation:add"})
    public ZKResultMsg save(VisReservationInvitationItem item) {
        String[] emails;
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String emailStr = item.getVisitorEmail();
        emailStr = StringUtils.replace((String)emailStr, (String)",", (String)";");
        for (String email : emails = StringUtils.split((String)emailStr, (char)';')) {
            item.setVisitorEmail(email);
            item = this.visReservationInvitationService.saveItem(item);
            if ("1".equals(item.getSendFailMsg())) {
                zkResultMsg.setRet("fail");
                zkResultMsg.setMsg(I18nUtil.i18nCode((String)"base_mail_undefineMailCallAdmin", (Object[])new Object[0]));
            }
            if ("2".equals(item.getSendFailMsg())) {
                zkResultMsg.setRet("fail");
                zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_reservation_invitationMailFail", (Object[])new Object[0]));
            }
            item.setId("");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"vis:reservationInvitation:del"})
    public ZKResultMsg del(String ids) {
        this.visReservationInvitationService.deleteByIds(ids);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"vis:reservationInvitation:resend"})
    public ZKResultMsg resend(@RequestParam String ids) {
        this.visReservationInvitationService.resend(ids);
        return ZKResultMsg.successMsg();
    }
}

