/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.constants.VisConstants;
import com.zkteco.zkbiosecurity.vis.remote.VisReservationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import com.zkteco.zkbiosecurity.vis.vo.VisBatchCheckInItem;
import com.zkteco.zkbiosecurity.vis.vo.VisRegistrationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationExportExcelItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisReservationController
extends BaseController
implements VisReservationRemote {
    @Autowired
    private VisReservationService visReservationService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisAttributeService visAttributeService;
    @Autowired
    private VisVisitorService visVisitorService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${system.language:zh_CN}")
    private String language;

    @RequiresPermissions(value={"vis:reservation"})
    public ModelAndView index() {
        return new ModelAndView("vis/reservation/visFollowReservation");
    }

    @RequiresPermissions(value={"vis:reservation:edit", "vis:reservation:add", "vis:invitation:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        Map visParams = this.visParamsService.getVisParams();
        this.request.setAttribute("visParams", (Object)visParams);
        try {
            if (StringUtils.isNotBlank((CharSequence)id)) {
                VisReservationItem item = this.visReservationService.getItemById(id);
                boolean isExpired = false;
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                calendar.setTimeInMillis(sdf.parse(item.getVisitEndDate()).getTime());
                int visitEndDate = calendar.get(6);
                calendar.setTimeInMillis(System.currentTimeMillis());
                int today = calendar.get(6);
                isExpired = !StringUtils.equals((CharSequence)item.getIsVisited(), (CharSequence)"1") && !StringUtils.equals((CharSequence)item.getIsVisited(), (CharSequence)"6") || !VisConstants.RESERVATION_NOT_AUDIT.equals(item.getAuditStatus()) || visitEndDate < today;
                this.request.setAttribute("isExpired", (Object)String.valueOf(isExpired));
                item = this.visReservationService.decryptReservationPhoto(item);
                this.request.setAttribute("item", (Object)item);
                Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisitorId());
                this.request.setAttribute("map1", (Object)valueMap);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        return new ModelAndView("vis/reservation/editVisReservation");
    }

    public ModelAndView editMessageInfo(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Map visParams = this.visParamsService.getVisParams();
            this.request.setAttribute("visParams", (Object)visParams);
            VisReservationItem item = this.visReservationService.getItemById(id);
            if (item == null) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
            }
            this.request.setAttribute("isExpired", (Object)true);
            item = this.visReservationService.decryptReservationPhoto(item);
            this.request.setAttribute("item", (Object)item);
            Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisitorId());
            this.request.setAttribute("map1", (Object)valueMap);
            List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
            this.getAttribute(attributes);
        }
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("vis/reservation/editVisReservation");
    }

    private void getAttribute(List<VisAttributeItem> attributeItems) {
        ArrayList rows = new ArrayList();
        ArrayList<Integer> rowInts = new ArrayList<Integer>();
        HashMap<String, ArrayList<Integer>> maxTds = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, VisAttributeItem> attrs = new HashMap<String, VisAttributeItem>();
        for (VisAttributeItem attributeItem : attributeItems) {
            ArrayList<Integer> colList;
            Integer row = attributeItem.getPositionX();
            Integer col = attributeItem.getPositionY();
            if (!rowInts.contains(row)) {
                rowInts.add(row);
            }
            if ((colList = (ArrayList<Integer>)maxTds.get("" + row)) == null) {
                colList = new ArrayList<Integer>();
            }
            colList.add(col);
            Collections.sort(colList);
            maxTds.put("" + row, colList);
            attrs.put("" + row + col, attributeItem);
        }
        Collections.sort(rowInts);
        CollectionUtils.collect(rowInts, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return o.toString();
            }
        }, rows);
        this.request.setAttribute("attrs", attrs);
        this.request.setAttribute("tds", maxTds);
        this.request.setAttribute("trs", rows);
    }

    @RequiresPermissions(value={"vis:reservation:edit", "vis:reservation:add"})
    @LogRequest(module="vis_module", object="vis_leftMenu_reservation", opType="common_op_edit", requestParams={"visitorName"}, opContent="pers_person_name")
    public ZKResultMsg save(VisReservationItem item, @RequestParam Map<String, String> attrMap) {
        ZKResultMsg res = new ZKResultMsg();
        item.setAttrMap(attrMap);
        this.visReservationService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:reservation:refresh"})
    public DxGrid list(VisReservationItem condition) {
        long limit = this.getLimitCount();
        if (StringUtils.isBlank((CharSequence)condition.getParentReservationId())) {
            condition.setIsNullParentReservationId("NULL");
        }
        if ("zh_CN".equalsIgnoreCase(this.language)) {
            condition.setReservationTypeEq("0");
        }
        Pager pager = this.visReservationService.getItemsAndAttrByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"vis:reservation:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_reservation", opType="common_op_del", requestParams={"visitorNames", "visitEmpNames"}, opContent="pers_person_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visReservationService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg loadVisInfo() {
        String certNumber = this.request.getParameter("certNumber");
        String certType = this.request.getParameter("certType");
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isBlank((CharSequence)certType)) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"vis_message_certTypeRequired", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)certNumber)) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"vis_message_certNumberRequired", (Object[])new Object[0]));
        }
        zkResultMsg = this.visReservationService.loadVisInfo(certType, certNumber);
        return zkResultMsg;
    }

    @RequiresPermissions(value={"vis:reservation:syncReservationToDev"})
    public ModelAndView syncReservationToDev(@RequestParam(value="ids") String ids) {
        this.request.setAttribute("reservationIds", (Object)ids);
        return new ModelAndView("vis/reservation/syncReservationToDev");
    }

    @RequiresPermissions(value={"vis:reservation:getVisitorSyncToDevice"})
    public ZKResultMsg getVisitorSyncToDevice(@RequestParam(value="reservationIds") String reservationIds, @RequestParam(value="placeIds") String placeIds) {
        this.visReservationService.getVisitorSyncToDevice(reservationIds, placeIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:reservation:edit", "vis:reservation:add"})
    public ModelAndView editAudit(String id) {
        Map visParams = this.visParamsService.getVisParams();
        this.request.setAttribute("visParams", (Object)visParams);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisReservationItem item = this.visReservationService.getItemById(id);
            boolean isExpired = true;
            this.request.setAttribute("isExpired", (Object)String.valueOf(isExpired));
            item = this.visReservationService.decryptReservationPhoto(item);
            this.request.setAttribute("item", (Object)item);
            Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisitorId());
            this.request.setAttribute("map1", (Object)valueMap);
        }
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        return new ModelAndView("vis/reservation/editVisReservation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"vis:reservation:import"})
    @LogRequest(module="system_module", object="pers_department", opType="common_op_import", requestParams={}, opContent="common_op_import")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        if (!upload.getOriginalFilename().toLowerCase().matches(".*?(xls|xlsx)$")) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_import_selectCorrectFile"));
        }
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), VisReservationItem.class);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.visReservationService.importReservationData(itemList, progress += 10));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import VisReservation Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"vis:reservation:exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean isMSIE;
            String reportType = this.request.getParameter("reportType");
            JSONObject json = this.visReservationService.getJsonColumByItem((BaseItem)new VisReservationExportExcelItem());
            String fileName = I18nUtil.i18nCode((String)"vis_reservation_exportTemplateFileName", (Object[])new Object[0]);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileName);
            sheet.setDefaultColumnWidth(json.size());
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont font = workbook.createFont();
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setAlignment(HorizontalAlignment.CENTER);
            font.setFontHeightInPoints((short)14);
            style.setFont(font);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(fileName);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, json.size() - 1));
            cell.setCellStyle(style);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            row = sheet.createRow(1);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            int i = 0;
            for (String key : json.keySet()) {
                sheet.setColumnWidth(i, 5400);
                cell = row.createCell(i);
                cell.setCellValue((String)json.get((Object)key));
                cell.setCellStyle(style);
                Map commentMap = this.visReservationService.getPersAttributeComment();
                String attrComment = (String)commentMap.get(key);
                if (StringUtils.isNotBlank((CharSequence)attrComment)) {
                    HSSFComment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
                    comment.setString((RichTextString)new HSSFRichTextString(attrComment));
                    cell.setCellComment((Comment)comment);
                }
                ++i;
            }
            response.setCharacterEncoding("UTF-8");
            String agent = request.getHeader("User-Agent");
            boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
            if (isMSIE) {
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replaceAll("\\+", " ");
            } else {
                fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "ISO-8859-1");
                fileName = fileName.replace("%2520", " ");
            }
            response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase() + "\"");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outStream = response.getOutputStream();
            workbook.write((OutputStream)outStream);
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            return;
        }
        catch (Exception e) {
            this.log.error("export error", (Throwable)e);
            throw new ZKBusinessException("common_report_exportFaild");
        }
    }

    public DxGrid getVisitList(VisBatchCheckInItem condition) {
        ArrayList<String> notInAuditStatusList = new ArrayList<String>();
        notInAuditStatusList.add("" + VisConstants.RESERVATION_NOT_AUDIT);
        notInAuditStatusList.add("" + VisConstants.RESERVATION_NOT_FAIL);
        condition.setNotInAuditStatus(StringUtils.join(notInAuditStatusList, (String)","));
        condition.setIsVisited("1");
        Pager pager = this.visReservationService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg saveVisReservation(VisRegistrationItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String bioTemplateJson = this.request.getParameter("bioTemplateJson");
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("bioTemplateJson", bioTemplateJson);
        if (item.getValidStartTime() != null && item.getValidEndTime() != null && item.getValidStartTime().after(item.getValidEndTime())) {
            throw new ZKBusinessException("500", "common_startEndDateCompare");
        }
        if (StringUtils.isBlank((CharSequence)item.getVisitedEmpId())) {
            throw new ZKBusinessException("500", "vis_api_visitorEmpNotNull");
        }
        if (StringUtils.isBlank((CharSequence)item.getPhone())) {
            throw new ZKBusinessException("500", "vis_api_phoneNotNull");
        }
        if (StringUtils.isNotBlank((CharSequence)item.getHeadPortrait())) {
            item.setHeadPortrait(item.getHeadPortrait().replaceAll("[\\s*\t\n\r]", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getEnterPhoto())) {
            item.setEnterPhoto(item.getEnterPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCertPhoto())) {
            item.setCertPhoto(item.getCertPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        zkResultMsg = this.visReservationService.registerVisReservation(item, attrMap);
        VisReservationItem visReservationItem = this.visReservationService.getItemById(zkResultMsg.getData().toString());
        zkResultMsg.setData((Object)visReservationItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg exit(VisRegistrationItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getExitPhoto())) {
            item.setExitPhoto(item.getExitPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        this.visReservationService.visReservationExit(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getPhoto(String photoPath) {
        return new ZKResultMsg((Object)this.visReservationService.getPhotoByPath(photoPath));
    }

    public String checkMaxVisitorForPersons(@RequestParam(value="reservationIds") String reservationIds) {
        return this.visReservationService.checkMaxVisitorForPersons(reservationIds);
    }
}

