/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisReservationAuditRemote;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationAuditItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisReservationAuditController
extends BaseController
implements VisReservationAuditRemote {
    @Autowired
    private VisReservationService visReservationService;
    @Value(value="${system.language}")
    private String sysLanguage;

    @RequiresPermissions(value={"vis:reservationAudit"})
    public ModelAndView index() {
        return new ModelAndView("vis/reservation/visReservationAudit");
    }

    @RequiresPermissions(value={"vis:reservationAudit:refresh"})
    public DxGrid list(VisReservationAuditItem condition) {
        long limit = this.getLimitCount();
        if (!"zh_CN".equals(this.sysLanguage)) {
            condition.setIsFromIn("h5_web_offline,INS");
        }
        Pager pager = this.visReservationService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"vis:reservationAudit:audit"})
    public ZKResultMsg audit(String ids) {
        return this.visReservationService.audit(ids);
    }

    @RequiresPermissions(value={"vis:reservationAudit:refuse"})
    public ZKResultMsg refuse(String ids) {
        return this.visReservationService.refuse(ids);
    }

    public ZKResultMsg getVisReservation(@RequestParam(value="deviceSn") String deviceSn) {
        ZKResultMsg zkResultMsg = this.visReservationService.getVisReservation(deviceSn);
        return zkResultMsg;
    }

    public ZKResultMsg visReservationAudit(VisReservationItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getEnterPhoto())) {
            item.setEnterPhoto(item.getEnterPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        item.setIsAutoRegister("1");
        return I18nUtil.i18nMsg((ZKResultMsg)this.visReservationService.visReservationAudit(item));
    }

    public ZKResultMsg getExitVisReservation(@RequestParam(value="deviceSn") String deviceSn) {
        return this.visReservationService.getExitVisReservation(deviceSn);
    }

    public ZKResultMsg getSignInVisReservation(@RequestParam(value="deviceSn") String deviceSn) {
        return this.visReservationService.getSignInVisReservation(deviceSn);
    }

    public ZKResultMsg checkVisReservation(VisReservationItem item) {
        return this.visReservationService.checkVisReservation(item);
    }
}

