/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisParamsRemote;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisParamsController
extends BaseController
implements VisParamsRemote {
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisWatchListService visWatchListService;

    @RequiresPermissions(value={"vis:params"})
    public ModelAndView index() {
        Map visParams = this.visParamsService.getVisParams();
        boolean showCarAuthorization = this.visParamsService.isShowCarAuthorization();
        String autoExitValidEndTime = (String)visParams.get("vis.autoExitValidEndTime");
        visParams.put("vis.autoExitValidEndTime", autoExitValidEndTime.split(" ")[1].replace("0/", ""));
        this.request.setAttribute("visParams", (Object)visParams);
        this.request.setAttribute("showCarAuthorization", (Object)showCarAuthorization);
        if (this.visWatchListService.checkLicense()) {
            this.request.setAttribute("advancedLicense", (Object)true);
        }
        return new ModelAndView("vis/params/params");
    }

    @RequiresPermissions(value={"vis:params:edit"})
    @LogRequest(module="vis_module", object="common_leftMenu_paramSet", opType="common_op_edit", opContent="common_op_edit")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        String receiver;
        String goodsPhotograph = params.get("vis.goodsPhotograph");
        String openExit = params.get("vis.openExit");
        String enableCardAutoExit = params.get("vis.enableCardAutoExit");
        String enableAutoExit = params.get("vis.enableAutoExit");
        String isNeedIssueCard = params.get("vis.isNeedIssueCard");
        String isNeedFP = params.get("vis.isNeedFP");
        String isNeedPwd = params.get("vis.isNeedPwd");
        String isNeedSC = params.get("vis.isNeedSC");
        String requiredVisitedEmp = params.get("vis.requiredVisitedEmp");
        String requiredVisitedDept = params.get("vis.requiredVisitedDept");
        String openFloatBox = params.get("vis.openFloatBox");
        String openMaxVisitorForDay = params.get("vis.openMaxVisitorForDay");
        String openMaxVisitorForPerson = params.get("vis.openMaxVisitorForPerson");
        String openInfoBox = params.get("vis.openInfoBox");
        String backFillFingerprint = params.get("vis.backFillFingerprint");
        String backFillPhoto = params.get("vis.backFillPhoto");
        String defense = params.get("vis.defense");
        String isUseCKName = params.get("vis.isUseCKName");
        String wlCKName = params.get("vis.wlCKName");
        String wlCKCertificate = params.get("vis.wlCKCertificate");
        String wlCKCountry = params.get("vis.wlCKCountry");
        String wlCKCompany = params.get("vis.wlCKCompany");
        String copyCardNumber = params.get("vis.copyCardNumber");
        if (isUseCKName == null) {
            params.put("vis.isUseCKName", "0");
        }
        if (wlCKName == null) {
            params.put("vis.wlCKName", "0");
        }
        if (wlCKCertificate == null) {
            params.put("vis.wlCKCertificate", "0");
        }
        if (wlCKCountry == null) {
            params.put("vis.wlCKCountry", "0");
        }
        if (wlCKCompany == null) {
            params.put("vis.wlCKCompany", "0");
        }
        if (goodsPhotograph == null) {
            params.put("vis.goodsPhotograph", "0");
        }
        if (openExit == null) {
            params.put("vis.openExit", "0");
        }
        if (enableCardAutoExit == null) {
            params.put("vis.enableCardAutoExit", "0");
        }
        if (enableAutoExit == null) {
            params.put("vis.enableAutoExit", "0");
        }
        if (isNeedIssueCard == null) {
            params.put("vis.isNeedIssueCard", "0");
        }
        if (isNeedFP == null) {
            params.put("vis.isNeedFP", "0");
        }
        if (isNeedPwd == null) {
            params.put("vis.isNeedPwd", "0");
        }
        if (isNeedSC == null) {
            params.put("vis.isNeedSC", "0");
        }
        if (requiredVisitedEmp == null) {
            params.put("vis.requiredVisitedEmp", "0");
        }
        if (requiredVisitedDept == null) {
            params.put("vis.requiredVisitedDept", "0");
        }
        if (openFloatBox == null) {
            params.put("vis.openFloatBox", "0");
        }
        if (openMaxVisitorForDay == null) {
            params.put("vis.openMaxVisitorForDay", "0");
        }
        if (openMaxVisitorForPerson == null) {
            params.put("vis.openMaxVisitorForPerson", "0");
        }
        if (openInfoBox == null) {
            params.put("vis.openInfoBox", "0");
        }
        if (backFillFingerprint == null) {
            params.put("vis.backFillFingerprint", "0");
        }
        if (backFillPhoto == null) {
            params.put("vis.backFillPhoto", "0");
        }
        if (StringUtils.isBlank((CharSequence)copyCardNumber)) {
            params.put("vis.copyCardNumber", "0");
        }
        if (StringUtils.isBlank((CharSequence)defense)) {
            params.put("vis.defense", "0");
        }
        if (StringUtils.isNotBlank((CharSequence)(receiver = this.request.getParameter("mail")))) {
            params.put("vis.receiver", receiver.replaceAll(";", ","));
            this.visParamsService.setMailReceiver(receiver.replaceAll(";", ","));
        } else {
            params.put("vis.receiver", "");
            this.visParamsService.delMailReceiver();
        }
        String sendMailHour = params.get("vis.alertTimeHour");
        String sendMailMinute = params.get("vis.alertTimeMinute");
        StringBuffer strBuf = new StringBuffer("0 ").append(sendMailMinute + " " + sendMailHour).append(" * * ?");
        params.put("vis.sendMailTime", strBuf.toString());
        StringBuffer autoExitValidEndTime = new StringBuffer("0 0/").append(params.get("vis.autoExitValidEndTime")).append(" * * * ?");
        params.put("vis.autoExitValidEndTime", autoExitValidEndTime.toString());
        String recognition = StringUtils.join((Object[])this.request.getParameterValues("vis.recognition"), (String)",");
        recognition = (String)StringUtils.defaultIfEmpty((CharSequence)recognition, (CharSequence)"");
        params.put("vis.recognition", recognition);
        params.put("vis.ocrCertNoType", params.get("certNoType"));
        params.put("vis.ocrDriveVerson", params.get("driverLink"));
        this.visParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg setHighDevParam(@RequestParam Map<String, String> params) {
        this.visParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg setOpenFloatBox() {
        String openFloatBox = this.request.getParameter("openFloatBox");
        this.visParamsService.saveValueByName("vis.openFloatBox", openFloatBox);
        return new ZKResultMsg();
    }

    public ZKResultMsg isOpenFloatBox() {
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.visParamsService.getVisParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public Boolean isShowOpenExit() {
        return this.visParamsService.isShowOpenExit();
    }

    public ZKResultMsg disableDevice() {
        String[] ids;
        for (String id : ids = this.request.getParameterValues("ids")) {
            this.visParamsService.disableDeviceById(id);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getVisCompanyName() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.visParamsService.getVisParamByName("vis.companyName"));
        return zkResultMsg;
    }
}

