/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisLevelRemote;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisAccLevelSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisEleLevelSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisLevelItem;
import com.zkteco.zkbiosecurity.vis.vo.VisPsgLevelSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedDepartmentSelectLevelItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonSelectLevelItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorSelectItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisLevelController
extends BaseController
implements VisLevelRemote {
    @Autowired
    private VisLevelService visLevelService;
    @Value(value="${system.language:zh_CN}")
    private String language;

    @RequiresPermissions(value={"vis:level"})
    public ModelAndView index() {
        boolean existAcc = this.visLevelService.isExistAcc();
        boolean existEle = this.visLevelService.isExistEle();
        this.request.setAttribute("existAcc", (Object)existAcc);
        this.request.setAttribute("existEle", (Object)existEle);
        this.request.setAttribute("existPsg", (Object)this.visLevelService.isExistModuleByCode("psg"));
        this.request.setAttribute("existPid", (Object)this.visLevelService.isExistModuleByCode("pid"));
        return new ModelAndView("vis/level/visLevel");
    }

    @RequiresPermissions(value={"vis:level:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visLevelService.getItemById(id));
        }
        return new ModelAndView("vis/level/editVisLevel");
    }

    @RequiresPermissions(value={"vis:level:edit"})
    public ZKResultMsg save(VisLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visLevelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:level:refresh"})
    public DxGrid list(VisLevelItem condition) {
        Pager pager = this.visLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="common_op_del", requestParams={"levelNames", "levelModules"}, opContent="common_level_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visLevelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getVisLevel() {
        HashMap moduleMap = Maps.newHashMap();
        moduleMap.put("acc", I18nUtil.i18nCode((String)"vis_module_acc", (Object[])new Object[0]));
        moduleMap.put("ele", I18nUtil.i18nCode((String)"vis_module_ele", (Object[])new Object[0]));
        moduleMap.put("psg", I18nUtil.i18nCode((String)"vis_module_psg", (Object[])new Object[0]));
        moduleMap.put("pid", I18nUtil.i18nCode((String)"vis_module_pid", (Object[])new Object[0]));
        List visLevelItems = this.visLevelService.getByCondition(new VisLevelItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = new TreeItem("0");
        for (VisLevelItem visLevelItem : visLevelItems) {
            item = new TreeItem();
            item.setId(visLevelItem.getId());
            item.setText(visLevelItem.getLevelName() + "(" + (String)moduleMap.get(visLevelItem.getLevelModule()) + ")");
            item.setParent(pItem);
            items.add(item);
        }
        Collections.sort(items, new Comparator<TreeItem>(){

            @Override
            public int compare(TreeItem o1, TreeItem o2) {
                String o2Text;
                String[] o2Texts;
                String o1Text = o1.getText();
                String[] o1Texts = o1Text.split("\\(");
                if (o1Texts[1].equals((o2Texts = (o2Text = o2.getText()).split("\\("))[1])) {
                    return o1Text.compareTo(o2Text);
                }
                if ("zh_CN".equals(VisLevelController.this.language)) {
                    return o2Texts[1].compareTo(o1Texts[1]);
                }
                return o1Texts[1].compareTo(o2Texts[1]);
            }
        });
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_accLevel", requestParams={"levelNames"}, opContent="common_level_name")
    public ZKResultMsg saveAccLevel() {
        this.saveLevel("acc");
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_psgLevel", requestParams={"levelNames"}, opContent="common_level_name")
    public ZKResultMsg savePsgLevel() {
        this.saveLevel("psg");
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_pidDevice", opContent="vis_level_pidDevice")
    public ZKResultMsg savePidDevice() {
        boolean pidExist = this.visLevelService.checkLevelModuleIsUsed("pid");
        if (pidExist) {
            throw new ZKBusinessException("500", I18nUtil.i18nCode((String)"vis_message_existPid", (Object[])new Object[0]));
        }
        VisLevelItem visLevelItem = new VisLevelItem();
        visLevelItem.setLevelModule("pid");
        visLevelItem.setLevelName(I18nUtil.i18nCode((String)"vis_level_pidLevel", (Object[])new Object[0]));
        visLevelItem.setModuleId("pid");
        this.visLevelService.saveItem(visLevelItem);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private void saveLevel(String moduleName) {
        String levelIds = this.request.getParameter("levelIds");
        String levelNames = this.request.getParameter("levelNames");
        if (StringUtils.isNotBlank((CharSequence)levelIds)) {
            String[] levelIdArray = levelIds.split(",");
            String[] levelNameArray = levelNames.split(",");
            for (int i = 0; i < levelIdArray.length; ++i) {
                VisLevelItem visLevelItem = new VisLevelItem();
                visLevelItem.setLevelModule(moduleName);
                visLevelItem.setLevelName(levelNameArray[i]);
                visLevelItem.setModuleId(levelIdArray[i]);
                this.visLevelService.saveItem(visLevelItem);
            }
        }
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_eleLevel", requestParams={"levelNames"}, opContent="common_level_name")
    public ZKResultMsg saveEleLevel() {
        this.saveLevel("ele");
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:level:selectPersonLevel"})
    public DxGrid getVisitedPersonSelectLevel(VisVisitedPersonSelectLevelItem condition) {
        String visVisitedPersonId = this.request.getParameter("visVisitedPersonId");
        ArrayList<String> selectLevelIds = new ArrayList<String>();
        selectLevelIds.add("-1");
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectLevelIds.remove(0);
            selectLevelIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        }
        if (selectLevelIds.size() == 0) {
            selectLevelIds.add("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(StringUtils.join(selectLevelIds, (String)","));
        } else if (condition.getType().equals("selected")) {
            condition.setInId(StringUtils.join(selectLevelIds, (String)","));
        }
        if (StringUtils.isNotBlank((CharSequence)visVisitedPersonId)) {
            condition.setFilterId(visVisitedPersonId);
        }
        Pager pager = this.visLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:selectDeptLevel"})
    public DxGrid getVisitedDepartmentSelectLevel(VisVisitedDepartmentSelectLevelItem condition) {
        String visVisitedDepartmentId = this.request.getParameter("visVisitedDepartmentId");
        ArrayList<String> selectLevelIds = new ArrayList<String>();
        selectLevelIds.add("-1");
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectLevelIds.remove(0);
            selectLevelIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(StringUtils.join(selectLevelIds, (String)","));
        } else if (condition.getType().equals("selected")) {
            condition.setInId(StringUtils.join(selectLevelIds, (String)","));
        }
        condition.setFilterId(visVisitedDepartmentId);
        Pager pager = this.visLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:saveAccLevel"})
    public DxGrid getAccList(VisAccLevelSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visLevelService.getNoExistAccLevel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:saveEleLevel"})
    public DxGrid getEleList(VisEleLevelSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visLevelService.getNoExistEleLevel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:savePsgLevel"})
    public DxGrid getPsgList(VisPsgLevelSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visLevelService.getNoExistPsgLevel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:selectVisitor"})
    public DxGrid getVisitorlist(VisVisitorSelectItem condition) {
        String visLevelId = this.request.getParameter("visLevelId");
        ArrayList<String> selectPersonIds = new ArrayList<String>();
        selectPersonIds.add("-1");
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectPersonIds.remove(0);
            selectPersonIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(StringUtils.join(selectPersonIds, (String)","));
        } else if (condition.getType().equals("selected")) {
            condition.setInId(StringUtils.join(selectPersonIds, (String)","));
        }
        condition.setFilterId(visLevelId);
        Pager pager = this.visLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getVisDefaultLevel() {
        List defaultFloorIds;
        ZKResultMsg msg = new ZKResultMsg();
        JSONObject dataJson = new JSONObject();
        String deptId = this.request.getParameter("deptId");
        String personId = this.request.getParameter("personId");
        String placeId = this.request.getParameter("placeId");
        List visLevelIds = this.visLevelService.getVisDefaultLevel(deptId, personId, placeId);
        String levelIds = StringUtils.join((Iterable)visLevelIds, (String)",");
        dataJson.put("levelIds", (Object)levelIds);
        if (StringUtils.isNotBlank((CharSequence)personId) && (defaultFloorIds = this.visLevelService.getDefaultFloorIdsByPersonId(personId)) != null && defaultFloorIds.size() > 0) {
            dataJson.put("defaultFloorIds", (Object)StringUtils.join((Iterable)defaultFloorIds, (String)","));
        }
        msg.setData((Object)dataJson);
        return msg;
    }

    public boolean isExistEle() {
        return this.visLevelService.isExistEle();
    }

    public boolean isExistAcc() {
        return this.visLevelService.isExistAcc();
    }

    public boolean isExistPsg() {
        return this.visLevelService.isExistModuleByCode("psg");
    }

    public boolean isExistPid() {
        return this.visLevelService.isExistModuleByCode("pid");
    }

    public TreeItem getDefaultFloorTree() {
        List treeItems = this.visLevelService.getDefaultFloorTree(this.request.getSession().getId());
        return new TreeItem("0", treeItems);
    }
}

