/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisInvitationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.vo.VisInvitationItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisInvitationController
extends BaseController
implements VisInvitationRemote {
    @Autowired
    private VisReservationService visReservationService;

    @RequiresPermissions(value={"vis:invitation"})
    public ModelAndView index() {
        return new ModelAndView("vis/invitation/visInvitation");
    }

    @RequiresPermissions(value={"vis:invitation:refresh"})
    public DxGrid list(VisInvitationItem condition) {
        condition.setReservationType("1");
        if (StringUtils.isBlank((CharSequence)condition.getParentReservationId())) {
            condition.setIsNullParentReservationId("NULL");
        }
        long limit = this.getLimitCount();
        Pager pager = this.visReservationService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"vis:invitation:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.visReservationService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"vis:invitation:cancel"})
    public ZKResultMsg revokeInvitation(String ids) {
        return this.visReservationService.revokeInvitation(ids, Boolean.valueOf(true));
    }

    @RequiresPermissions(value={"vis:invitation:audit"})
    public ZKResultMsg audit(String ids) {
        return this.visReservationService.audit(ids);
    }
}

