/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApi4InsReservationItem;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApiResultMessage;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApiVisitorHistoryItem;
import com.zkteco.zkbiosecurity.vis.constants.VisConstants;
import com.zkteco.zkbiosecurity.vis.remote.VisInsRegistrationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisInsRegistrationService;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.service.VisLinkageService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisReasonService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReasonItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;

@Controller
public class VisInsRegistrationController
extends BaseController
implements VisInsRegistrationRemote {
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;
    @Autowired
    private VisReservationService visReservationService;
    @Autowired
    private VisPlaceService visPlaceService;
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisReasonService visReasonService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisVisitorService visVisitorService;
    @Autowired
    private VisLinkageService visLinkageService;
    @Autowired
    private VisInsRegistrationService visInsRegistrationService;
    @Autowired
    private VisLevelService visLevelService;

    public VisApiResultMessage getEmpByNameAndDept(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        String name = map.get("name");
        String deptId = map.get("deptId");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        return this.visInsRegistrationService.getEmpByNameAndDept(name, deptId);
    }

    public VisApiResultMessage saveVisReservation(@RequestBody VisReservationItem visReservationItem) {
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(visReservationItem.getPhysicalKey());
        if (visReservationItem.getPhysicalKey() == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        try {
            visReservationItem.setEnterPlace(placeItem.getName());
            visReservationItem.setVisitorCount(Integer.valueOf(1));
            visReservationItem = this.visReservationService.saveVisReservationFromIns(visReservationItem);
        }
        catch (ZKBusinessException e) {
            if ("vis_reservation_auditing".equals(e.getMessage())) {
                return VisApiResultMessage.failMsg((int)-33, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-33)));
            }
            if ("vis_reservation_already".equals(e.getMessage())) {
                return VisApiResultMessage.failMsg((int)-34, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-34)));
            }
            if ("vis_message_registrationed".equals(e.getMessage())) {
                return VisApiResultMessage.failMsg((int)-35, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-35)));
            }
            if ("vis_message_disabledEmp".equals(e.getMessage())) {
                return VisApiResultMessage.failMsg((int)-31, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-31)));
            }
            return VisApiResultMessage.failMsg((int)-30, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-30)));
        }
        VisVisitorItem visitorItem = this.visVisitorService.getItemById(visReservationItem.getVisitorId());
        if (StringUtils.isNotBlank((CharSequence)visitorItem.getCertPhoto())) {
            visitorItem.setCertPhoto(FileUtils.getFileBase64Str((String)FileUtils.getLocalFullPath((String)visitorItem.getCertPhoto())));
        }
        VisApiVisitorHistoryItem visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItem(visReservationItem);
        visApiVisitorHistoryItem.setInterviewImgPath(null);
        visApiVisitorHistoryItem.setVisitorImgPath(null);
        ArrayList<VisApi4InsReservationItem> results = new ArrayList<VisApi4InsReservationItem>();
        visApiVisitorHistoryItem.setInterviewImgPath(null);
        visApiVisitorHistoryItem.setVisitorImgPath(null);
        results.add(new VisApi4InsReservationItem(visitorItem, visApiVisitorHistoryItem));
        if (VisConstants.RESERVATION_AUDIT.equals(visReservationItem.getAuditStatus())) {
            this.visLinkageService.reservationLinkage((short)7, visReservationItem);
        }
        return VisApiResultMessage.successMsg(results);
    }

    public VisApiResultMessage visReservationAudit(@RequestBody Map<String, String> map) {
        ArrayList<VisApiVisitorHistoryItem> items;
        block6: {
            String physicalKey = map.get("physicalKey");
            VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
            if (physicalKey == null || placeItem == null) {
                return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
            }
            String certType = map.get("certType");
            String certNumber = map.get("certNumber");
            VisVisitorItem visitorItem = this.visVisitorService.getItemByCertTypeAndCertNumber(Short.valueOf(certType), certNumber);
            if (visitorItem != null && !visitorItem.getEnabled().booleanValue()) {
                return VisApiResultMessage.failMsg((int)-31, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-31)));
            }
            items = new ArrayList<VisApiVisitorHistoryItem>();
            try {
                String historyPin = map.get("historyPin");
                VisReservationItem reservationItem = this.visReservationService.getItemById(historyPin);
                if (reservationItem != null) {
                    if (VisConstants.RESERVATION_NOT_AUDIT.equals(reservationItem.getAuditStatus())) {
                        return VisApiResultMessage.failMsg((int)-41, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-41)));
                    }
                    reservationItem.setCheckInDate(new Date());
                    reservationItem.setVisitDate(DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
                    List visLevelIds = this.visLevelService.getVisDefaultLevel(reservationItem.getVisitEmpDeptId(), reservationItem.getVisitedEmpId(), placeItem.getId());
                    String levelIds = StringUtils.join((Iterable)visLevelIds, (String)",");
                    reservationItem.setLevelIds(levelIds);
                    reservationItem.setVisitorCount(Integer.valueOf(1));
                    reservationItem.setEnterPlace(placeItem.getId());
                    this.visReservationService.autoVisiteRegister(reservationItem);
                    VisApiVisitorHistoryItem visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItem(reservationItem);
                    visApiVisitorHistoryItem.setCheckStatus((int)VisConstants.RESERVATION_INS_SIGN_OUT.shortValue());
                    visApiVisitorHistoryItem.setCheckInDate(System.currentTimeMillis());
                    visApiVisitorHistoryItem.setInterviewImg(null);
                    visApiVisitorHistoryItem.setVisitorImg(null);
                    items.add(visApiVisitorHistoryItem);
                }
            }
            catch (ZKBusinessException e) {
                if (!"vis_message_cardSent".equals(e.getMessage())) break block6;
                return VisApiResultMessage.failMsg((int)-30, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-30)));
            }
        }
        return VisApiResultMessage.successMsg(items);
    }

    public VisApiResultMessage exitVisVisitor(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        String certType = map.get("certType");
        String certNumber = map.get("certNumber");
        VisVisitorItem visitorItem = this.visVisitorService.getItemByCertTypeAndCertNumber(Short.valueOf(certType), certNumber);
        if (visitorItem != null && !visitorItem.getEnabled().booleanValue()) {
            return VisApiResultMessage.failMsg((int)-31, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-31)));
        }
        String historyPin = map.get("historyPin");
        VisReservationItem reservationItem = this.visReservationService.getItemById(historyPin);
        if (reservationItem != null) {
            ZKResultMsg resultMsg = this.visTransactionService.exitVisVisitor(historyPin, placeItem.getId());
            if ("fail".equals(resultMsg.getRet())) {
                return VisApiResultMessage.failMsg((int)-40, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-40)));
            }
            ArrayList<VisApiVisitorHistoryItem> items = new ArrayList<VisApiVisitorHistoryItem>();
            VisApiVisitorHistoryItem visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItem(reservationItem);
            visApiVisitorHistoryItem.setCheckStatus((int)VisConstants.RESERVATION_INS_SIGN_OVER.shortValue());
            visApiVisitorHistoryItem.setCheckOutDate(System.currentTimeMillis());
            visApiVisitorHistoryItem.setInterviewImg(null);
            visApiVisitorHistoryItem.setVisitorImg(null);
            items.add(visApiVisitorHistoryItem);
            return VisApiResultMessage.successMsg(items);
        }
        return VisApiResultMessage.failMsg((int)-40, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-40)));
    }

    public VisApiResultMessage getVisInfo(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        String visPin = map.get("visPin");
        String certType = map.get("certType");
        String certNumber = map.get("certNumber");
        String status = map.get("status");
        String phone = map.get("phone");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        VisReservationItem reservationItem = new VisReservationItem();
        if (StringUtils.isNotBlank((CharSequence)status)) {
            reservationItem.setAuditStatus(Short.valueOf(Short.parseShort(status)));
            List reservationItemList = this.visReservationService.getItemByStatus(reservationItem);
            List visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItemList(reservationItemList);
            return VisApiResultMessage.successMsg((Object)visApiVisitorHistoryItem);
        }
        if (StringUtils.isNotBlank((CharSequence)visPin)) {
            reservationItem.setVisitorPin(visPin);
            List reservationItemList = this.visReservationService.getByCondition(reservationItem);
            List visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItemList(reservationItemList);
            return VisApiResultMessage.successMsg((Object)visApiVisitorHistoryItem);
        }
        if (StringUtils.isNotBlank((CharSequence)certType) && StringUtils.isNotBlank((CharSequence)certNumber)) {
            List reservationItemList = this.visReservationService.getItemsByVisitorCertNumberAndCertType(certNumber, certType);
            List visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItemList(reservationItemList);
            return VisApiResultMessage.successMsg((Object)visApiVisitorHistoryItem);
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            reservationItem.setPhone(phone);
            List reservationItemList = this.visReservationService.getByCondition(reservationItem);
            List visApiVisitorHistoryItem = this.visInsRegistrationService.createApiVisitorHistoryItemList(reservationItemList);
            return VisApiResultMessage.successMsg((Object)visApiVisitorHistoryItem);
        }
        return VisApiResultMessage.failMsg((int)-1, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-1)));
    }

    public VisApiResultMessage getVisReason(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        List visReasonItems = this.visReasonService.getByCondition(new VisReasonItem());
        return VisApiResultMessage.successMsg((Object)visReasonItems);
    }

    public VisApiResultMessage firstVisVisitor(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        String visitorPin = map.get("visitorPin");
        String certNum = map.get("certNum");
        String certType = map.get("certType");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        if (StringUtils.isNotBlank((CharSequence)visitorPin)) {
            VisVisitorItem condition = new VisVisitorItem();
            condition.setPin(visitorPin);
            List visVisitorItemList = this.visVisitorService.getByCondition(condition);
            return VisApiResultMessage.successMsg((Object)visVisitorItemList);
        }
        if (StringUtils.isNotBlank((CharSequence)certNum) && StringUtils.isNotBlank((CharSequence)certType)) {
            VisVisitorItem condition = new VisVisitorItem();
            condition.setCertType(certType);
            condition.setCertNumber(certNum);
            condition.setEquals(Boolean.valueOf(true));
            List visVisitorItemList = this.visVisitorService.getByCondition(condition);
            return VisApiResultMessage.successMsg((Object)visVisitorItemList);
        }
        return VisApiResultMessage.failMsg((int)-1, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-1)));
    }

    public VisApiResultMessage testServiceIsConnected(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        return VisApiResultMessage.successMsg();
    }

    public VisApiResultMessage enableReservation(@RequestBody Map<String, String> map) {
        VisVisitorItem visitorItem;
        String physicalKey = map.get("physicalKey");
        String visitorPin = map.get("visitorPin");
        String certNum = map.get("certNumber");
        String certType = map.get("certType");
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        VisReservationItem item = new VisReservationItem();
        if (StringUtils.isNotBlank((CharSequence)visitorPin)) {
            item.setVisitorPin(visitorPin);
            visitorItem = this.visVisitorService.getItemByPin(visitorPin);
            if (visitorItem != null && !visitorItem.getEnabled().booleanValue()) {
                return VisApiResultMessage.failMsg((int)-31, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-31)));
            }
        } else if (StringUtils.isNotBlank((CharSequence)certNum) && StringUtils.isNotBlank((CharSequence)certType)) {
            visitorItem = this.visVisitorService.getItemByCertTypeAndCertNumber(Short.valueOf(certType), certNum);
            if (visitorItem != null && !visitorItem.getEnabled().booleanValue()) {
                return VisApiResultMessage.failMsg((int)-31, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-31)));
            }
            item.setCertNumber(certNum);
            item.setCertType(certType);
        } else {
            return VisApiResultMessage.failMsg((int)-1, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-1)));
        }
        String ret = zkResultMsg.getRet();
        if (zkResultMsg.isSuccess()) {
            return VisApiResultMessage.successMsg();
        }
        if ("-1".equals(ret)) {
            return VisApiResultMessage.failMsg((int)-32, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-32)));
        }
        if ("-2".equals(ret)) {
            return VisApiResultMessage.failMsg((int)-31, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-31)));
        }
        if ("-3".equals(ret)) {
            return VisApiResultMessage.failMsg((int)-30, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-30)));
        }
        if (String.valueOf(-34).equals(ret)) {
            return VisApiResultMessage.failMsg((int)-34, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-34)));
        }
        if (String.valueOf(-33).equals(ret)) {
            return VisApiResultMessage.failMsg((int)-33, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-33)));
        }
        if (String.valueOf(-35).equals(ret)) {
            return VisApiResultMessage.failMsg((int)-35, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-35)));
        }
        return VisApiResultMessage.failMsg((int)-1, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-1)));
    }

    public VisApiResultMessage queryReservationAudit(@RequestBody Map<String, String> map) {
        String physicalKey = map.get("physicalKey");
        VisPlaceItem placeItem = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        if (physicalKey == null || placeItem == null) {
            return VisApiResultMessage.failMsg((int)-20, (String)((String)VisConstants.BUSINESS_ERROR_MAP.get(-20)));
        }
        JSONArray array = new JSONArray();
        JSONObject obj = new JSONObject();
        String reservationAuditState = this.visParamsService.getVisParamByName("vis.reservation.auditOffline");
        if ("0".equals(reservationAuditState)) {
            obj.put("reservationAuditState", (Object)"1");
        }
        if ("1".equals(reservationAuditState)) {
            obj.put("reservationAuditState", (Object)"0");
        }
        array.add((Object)obj);
        return VisApiResultMessage.successMsg((Object)array);
    }
}

