/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.vis.remote.VisEmployeeSelectRemote;
import com.zkteco.zkbiosecurity.vis.service.VisEmployeeSelectService;
import com.zkteco.zkbiosecurity.vis.vo.VisEmployeeSelectItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class VisEmployeeSelectController
extends BaseController
implements VisEmployeeSelectRemote {
    @Autowired
    private VisEmployeeSelectService visEmployeeSelectService;

    public DxGrid list(VisEmployeeSelectItem condition) {
        Pager pager = new Pager();
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            String selectedVisitedEmpId = this.request.getParameter("selectedVisitedEmpId");
            condition.setSelectId(selectedVisitedEmpId);
        }
        if (condition.getType().equals("noSelected")) {
            pager = this.visEmployeeSelectService.getNoSelectPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public void filterEmployee() {
        try {
            this.response.setContentType("text/xml;charset=utf-8");
            this.response.setHeader("Cache-Control", "no-cache");
            StringBuffer result = new StringBuffer();
            result.append("<complete>");
            String hostId = this.request.getParameter("hostId");
            if (StringUtils.isNotBlank((CharSequence)hostId)) {
                List idList = StrUtil.strToList((String)hostId);
                List employeeList = this.visEmployeeSelectService.getByIds(idList);
                for (VisEmployeeSelectItem employee : employeeList) {
                    employee.setEnabledCredential(Boolean.valueOf(true));
                    this.setEmployeeInfo(result, employee);
                }
                result.append("</complete>");
                this.response.getWriter().write(result.toString());
                return;
            }
            String mask = this.request.getParameter("mask");
            if (StringUtils.isBlank((CharSequence)mask)) {
                this.response.getWriter().write("<complete></complete>");
                return;
            }
            String pos = this.request.getParameter("pos");
            List employeeList = this.visEmployeeSelectService.getEmployee(mask, pos);
            for (VisEmployeeSelectItem employee : employeeList) {
                this.setEmployeeInfo(result, employee);
            }
            result.append("</complete>");
            this.response.getWriter().write(result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setEmployeeInfo(StringBuffer result, VisEmployeeSelectItem employee) {
        if (employee.getEnabledCredential() != null && employee.getEnabledCredential().booleanValue()) {
            result.append("<option value=\"" + employee.getId() + "\">");
            result.append("<text>");
            result.append("<photo>");
            result.append("<![CDATA[" + (String)StringUtils.defaultIfEmpty((CharSequence)employee.getPhotoBase64(), (CharSequence)("/images/PC/" + SpringContextUtil.getProperty((String)"system.skin", (String)"") + "/userImage.png")) + "]]>");
            result.append("</photo>");
            result.append("<pin>");
            result.append(employee.getPersPin());
            result.append("</pin>");
            result.append("<name>");
            result.append(StringUtils.isNotEmpty((CharSequence)employee.getPersName()) ? employee.getPersName() : "");
            result.append("</name>");
            result.append("<lastName>");
            result.append(StringUtils.isNotEmpty((CharSequence)employee.getPersLastName()) ? employee.getPersLastName() : "");
            result.append("</lastName>");
            result.append("<deptName>");
            result.append(employee.getDeptName());
            result.append("</deptName>");
            result.append("<deptId>");
            result.append(employee.getDeptId());
            result.append("</deptId>");
            result.append("</text>");
            result.append("</option>");
        }
    }
}

