/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisCommonLevelRemote;
import com.zkteco.zkbiosecurity.vis.service.VisCommonLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisAccLevelSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisCommonLevelItem;
import com.zkteco.zkbiosecurity.vis.vo.VisEleLevelSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisPsgLevelSelectItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorSelectItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisCommonLevelController
extends BaseController
implements VisCommonLevelRemote {
    @Autowired
    private VisCommonLevelService visCommonLevelService;
    @Value(value="${system.language:zh_CN}")
    private String language;

    @RequiresPermissions(value={"vis:commonLevel"})
    public ModelAndView index() {
        boolean existAcc = this.visCommonLevelService.isExistAcc();
        boolean existEle = this.visCommonLevelService.isExistEle();
        boolean existPsg = this.visCommonLevelService.isExistPsg();
        boolean existPid = this.visCommonLevelService.isExistPid();
        this.request.setAttribute("existAcc", (Object)existAcc);
        this.request.setAttribute("existEle", (Object)existEle);
        this.request.setAttribute("existPsg", (Object)existPsg);
        this.request.setAttribute("existPid", (Object)existPid);
        return new ModelAndView("vis/commonLevel/visCommonLevel");
    }

    @RequiresPermissions(value={"vis:level:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visCommonLevelService.getItemById(id));
        }
        return new ModelAndView("industrial/visext/level/editVisLevel");
    }

    public ZKResultMsg save(VisCommonLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visCommonLevelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:commonLevel:refresh"})
    public DxGrid list(VisCommonLevelItem condition) {
        Pager pager = this.visCommonLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:commonLevel:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="common_op_del", requestParams={"levelNames", "levelModules"}, opContent="common_level_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visCommonLevelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getVisLevel() {
        HashMap moduleMap = Maps.newHashMap();
        moduleMap.put("acc", I18nUtil.i18nCode((String)"vis_module_acc", (Object[])new Object[0]));
        moduleMap.put("ele", I18nUtil.i18nCode((String)"vis_module_ele", (Object[])new Object[0]));
        List visLevelItems = this.visCommonLevelService.getByCondition(new VisCommonLevelItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = new TreeItem("0");
        for (VisCommonLevelItem visLevelItem : visLevelItems) {
            item = new TreeItem();
            item.setId(visLevelItem.getId());
            item.setText(visLevelItem.getLevelName() + "(" + (String)moduleMap.get(visLevelItem.getLevelModule()) + ")");
            item.setParent(pItem);
            items.add(item);
        }
        Collections.sort(items, new Comparator<TreeItem>(){

            @Override
            public int compare(TreeItem o1, TreeItem o2) {
                String o2Text;
                String[] o2Texts;
                String o1Text = o1.getText();
                String[] o1Texts = o1Text.split("\\(");
                if (o1Texts[1].equals((o2Texts = (o2Text = o2.getText()).split("\\("))[1])) {
                    return o1Text.compareTo(o2Text);
                }
                if ("zh_CN".equals(VisCommonLevelController.this.language)) {
                    return o2Texts[1].compareTo(o1Texts[1]);
                }
                return o1Texts[1].compareTo(o2Texts[1]);
            }
        });
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_accLevel", requestParams={"levelNames"}, opContent="common_level_name")
    public ZKResultMsg saveAccLevel() {
        String moduleName = "acc";
        this.saveLevel(moduleName);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private void saveLevel(String moduleName) {
        String levelIds = this.request.getParameter("levelIds");
        String levelNames = this.request.getParameter("levelNames");
        if (StringUtils.isNotBlank((CharSequence)levelIds)) {
            String[] levelIdArray = levelIds.split(",");
            String[] levelNameArray = levelNames.split(",");
            for (int i = 0; i < levelIdArray.length; ++i) {
                VisCommonLevelItem visLevelItem = new VisCommonLevelItem();
                visLevelItem.setLevelModule(moduleName);
                visLevelItem.setLevelName(levelNameArray[i]);
                visLevelItem.setModuleId(levelIdArray[i]);
                this.visCommonLevelService.saveItem(visLevelItem);
            }
        }
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_eleLevel", requestParams={"levelNames"}, opContent="common_level_name")
    public ZKResultMsg saveEleLevel() {
        String moduleName = "ele";
        this.saveLevel(moduleName);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg savePsgLevel() {
        String moduleName = "psg";
        this.saveLevel(moduleName);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:commonLevel:saveAccLevel"})
    public DxGrid getAccList(VisAccLevelSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visCommonLevelService.getNoExistAccLevel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:commonLevel:saveEleLevel"})
    public DxGrid getEleList(VisEleLevelSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visCommonLevelService.getNoExistEleLevel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:commonLevel:savePsgLevel"})
    public DxGrid getPsgList(VisPsgLevelSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visCommonLevelService.getNoExistPsgLevel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:selectVisitor"})
    public DxGrid getVisitorlist(VisVisitorSelectItem condition) {
        String visLevelId = this.request.getParameter("visLevelId");
        ArrayList<String> selectPersonIds = new ArrayList<String>();
        selectPersonIds.add("-1");
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectPersonIds.remove(0);
            selectPersonIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(StringUtils.join(selectPersonIds, (String)","));
        } else if (condition.getType().equals("selected")) {
            condition.setInId(StringUtils.join(selectPersonIds, (String)","));
        }
        condition.setFilterId(visLevelId);
        Pager pager = this.visCommonLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public boolean isExistEle() {
        return this.visCommonLevelService.isExistEle();
    }

    public boolean isExistAcc() {
        return this.visCommonLevelService.isExistAcc();
    }

    public boolean isExistPsg() {
        return this.visCommonLevelService.isExistPsg();
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_pidDevice", opContent="vis_level_pidDevice")
    @RequiresPermissions(value={"vis:commonLevel:savePidDevice"})
    public ZKResultMsg savePidDevice() {
        boolean pidExist = this.visCommonLevelService.checkLevelModuleIsUsed("pid");
        if (pidExist) {
            throw new ZKBusinessException("500", I18nUtil.i18nCode((String)"vis_message_existPid", (Object[])new Object[0]));
        }
        VisCommonLevelItem visCommonLevelItem = new VisCommonLevelItem();
        visCommonLevelItem.setLevelModule("pid");
        visCommonLevelItem.setLevelName(I18nUtil.i18nCode((String)"vis_level_pidLevel", (Object[])new Object[0]));
        visCommonLevelItem.setModuleId("pid");
        this.visCommonLevelService.saveItem(visCommonLevelItem);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

