/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.vis.remote.VisCardPrintTemplateRemote;
import com.zkteco.zkbiosecurity.vis.service.VisCardPrintTemplateService;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisCardPrintTemplateController
extends BaseController
implements VisCardPrintTemplateRemote {
    @Autowired
    private VisCardPrintTemplateService visCardPrintTemplateService;
    private Font font = new Font("Arial,\u5fae\u8f6f\u96c5\u9ed1", 0, 24);
    private Graphics2D g = null;
    private BufferedImage buffImage = null;
    private int x = 0;
    private int y = 0;

    public ZKResultMsg getPicTemplate(@RequestParam(value="templateId") String templateId, @RequestParam(value="visTranId", required=false) String visTranId) {
        HashMap<String, String> imgBase64Map = new HashMap<String, String>();
        Map templateMap = this.visCardPrintTemplateService.getPrintTemplate(templateId);
        if (templateMap != null) {
            String imgBase64Str = "";
            String templateWidth = (String)templateMap.get("width");
            String templateHeight = (String)templateMap.get("height");
            String frontData = (String)templateMap.get("frontData");
            String oppositeData = (String)templateMap.get("oppositeData");
            Map tranMap = this.visCardPrintTemplateService.getPreviewTrans(visTranId);
            JSONArray frontJsonArray = JSONArray.parseArray((String)frontData);
            imgBase64Str = this.getCardTemplate(Integer.parseInt(templateWidth), Integer.parseInt(templateHeight), frontJsonArray, tranMap);
            imgBase64Map.put("front", imgBase64Str);
            JSONArray oppositeJsonArray = JSONArray.parseArray((String)oppositeData);
            imgBase64Str = this.getCardTemplate(Integer.parseInt(templateWidth), Integer.parseInt(templateHeight), oppositeJsonArray, tranMap);
            imgBase64Map.put("opposite", imgBase64Str);
            imgBase64Map.put("visEmpPin", (String)tranMap.get("printData.visTransaction.visEmpPin"));
        }
        return new ZKResultMsg(imgBase64Map);
    }

    public ModelAndView preview(@RequestParam(value="templateId") String templateId) {
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            this.request.setAttribute("item", (Object)this.visCardPrintTemplateService.getPrintTemplateData(templateId));
        }
        return new ModelAndView("vis/printTemplate/previewPrintTemplate");
    }

    public ZKResultMsg getVisPrintTemplateData(@RequestParam(value="templateId") String templateId) {
        Map templateDateMap = this.visCardPrintTemplateService.getPrintTemplateData(templateId);
        return new ZKResultMsg((Object)templateDateMap);
    }

    private String getCardTemplate(int templateWidth, int templateHeight, JSONArray jsonArrayData, Map<String, String> tranMap) {
        JSONObject data;
        int i;
        int left = 0;
        int top = 0;
        int width = 0;
        int height = 0;
        int fontSize = 0;
        String leftPoint = "";
        String topPoint = "";
        String colorStr = "";
        String fontSizeStr = "";
        Color color = new Color(0, 0, 0);
        String imagesPath = "upload/vis/printTemplate/cardPrintImages/";
        String fullPath = FileUtil.systemFilePath + File.separator + imagesPath;
        File outputfile = null;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        this.buffImage = new BufferedImage(templateWidth, templateHeight, 1);
        this.g = this.buffImage.createGraphics();
        this.g.setColor(Color.WHITE);
        this.g.fillRect(0, 0, this.buffImage.getWidth(), this.buffImage.getHeight());
        String imgBase64Str = "";
        JSONArray bgArray = new JSONArray();
        for (i = 0; i < jsonArrayData.size(); ++i) {
            BufferedImage b;
            data = jsonArrayData.getJSONObject(i);
            if (!"background".equals(data.getString("printType"))) continue;
            if (StringUtils.isNotBlank((CharSequence)data.getString("printValue")) && (b = this.loadImageLocal(data.getString("printValue"))) != null) {
                this.g.drawImage(b, 0, 0, this.buffImage.getWidth(), this.buffImage.getHeight(), null);
            }
            bgArray.add((Object)data);
        }
        jsonArrayData.removeAll((Collection)bgArray);
        block21: for (i = 0; i < jsonArrayData.size(); ++i) {
            data = jsonArrayData.getJSONObject(i);
            leftPoint = data.getString("leftPoint");
            left = Integer.parseInt(leftPoint.substring(0, leftPoint.length() - 2));
            topPoint = data.getString("topPoint");
            top = Integer.parseInt(topPoint.substring(0, topPoint.length() - 2));
            fontSizeStr = data.getString("fontSize");
            fontSize = Integer.parseInt(fontSizeStr.substring(0, fontSizeStr.length() - 2)) * 2;
            width = Double.valueOf(data.getString("width")).intValue();
            height = Double.valueOf(data.getString("height")).intValue();
            colorStr = data.getString("color");
            String[] cArray = colorStr.split(",");
            for (String c : cArray) {
                colors.add(Integer.parseInt(c.trim()));
            }
            color = new Color((Integer)colors.get(0), (Integer)colors.get(1), (Integer)colors.get(2));
            switch (data.getString("printType")) {
                case "photo": {
                    BufferedImage d;
                    String decryFilePath = tranMap.get(data.getString("cell"));
                    String photoPath = decryFilePath.replaceAll("\\\\", "/");
                    byte[] decPhoto = FileEncryptUtil.getDecryptFile((String)photoPath);
                    if (decPhoto != null) {
                        String fileName = photoPath.substring(photoPath.lastIndexOf("/") + 1);
                        decryFilePath = FileUtils.saveByte2Image((String)"vis", (String)"printTemplate/cardPrintImages/decrypt", (String)fileName, (byte[])decPhoto);
                    }
                    if ((d = this.loadImageLocal(decryFilePath)) != null) {
                        d = this.imageZoom(d, width * 2, height * 2);
                        this.modifyImagetogeter(d, left * 2, top * 2);
                    }
                    if (decPhoto == null) continue block21;
                    FileUtils.deleteFile((String)FileUtil.getLocalFullPath((String)decryFilePath));
                    continue block21;
                }
                case "images": {
                    BufferedImage imgs = this.loadImageLocal(data.getString("cell"));
                    if (imgs == null) continue block21;
                    imgs = this.imageZoom(imgs, width * 2, height * 2);
                    this.modifyImagetogeter(imgs, left * 2, top * 2);
                    continue block21;
                }
                case "qrcode": {
                    outputfile = new File(new File(fullPath), "qr" + tranMap.get(data.getString("cell")) + ".png");
                    if (!outputfile.getParentFile().exists()) {
                        outputfile.getParentFile().mkdirs();
                    } else if (outputfile.exists()) {
                        outputfile.delete();
                    }
                    this.visCardPrintTemplateService.encoderQRCode(tranMap.get(data.getString("cell")), fullPath + "qr" + tranMap.get(data.getString("cell")) + ".png", 300, 300);
                    BufferedImage qrcode = this.loadImageLocal(imagesPath + "qr" + tranMap.get(data.getString("cell")) + ".png");
                    if (qrcode != null) {
                        BufferedImage newImage = new BufferedImage(width * 2, height * 2, qrcode.getType());
                        newImage.getGraphics().drawImage(qrcode, 0, 0, width * 2, height * 2, null);
                        this.modifyImagetogeter(newImage, left * 2, top * 2);
                    }
                    new File(fullPath + "qr" + tranMap.get(data.getString("cell")) + ".png").delete();
                    continue block21;
                }
                case "barcode": {
                    try {
                        outputfile = new File(new File(fullPath), "bar" + tranMap.get(data.getString("cell")) + ".png");
                        if (!outputfile.getParentFile().exists()) {
                            outputfile.getParentFile().mkdirs();
                        } else if (outputfile.exists()) {
                            outputfile.delete();
                        }
                        BufferedImage localBufferedImage = this.visCardPrintTemplateService.getJBarcodeImage(tranMap.get(data.getString("cell")));
                        ImageIO.write((RenderedImage)localBufferedImage, "png", new File(fullPath + "bar" + tranMap.get(data.getString("cell")) + ".png"));
                        BufferedImage barcode = this.loadImageLocal(imagesPath + "bar" + tranMap.get(data.getString("cell")) + ".png");
                        if (barcode != null) {
                            barcode = this.imageZoom(barcode, width * 2, height * 2);
                            this.modifyImagetogeter(barcode, left * 2, top * 2);
                        }
                        new File(fullPath + "bar" + tranMap.get(data.getString("cell")) + ".png").delete();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block21;
                }
                case "line": {
                    this.g.setColor(color);
                    this.g.drawLine(left * 2, top * 2, (left + width) * 2, (top + height) * 2);
                    continue block21;
                }
                case "txt": {
                    this.g.setColor(color);
                    if (data.getString("style").contains("textTitle")) {
                        FontMetrics fm = this.g.getFontMetrics(this.font);
                        int textWidth = fm.stringWidth(data.getString("cell"));
                        left = (templateWidth / 2 - textWidth) / 2 + 15;
                    }
                    this.modifyImage(data.getString("cell"), left * 2, top * 2 + 25, data.getString("fontFamily"), fontSize);
                    continue block21;
                }
                case "text": {
                    this.g.setColor(color);
                    this.modifyImage(tranMap.get(data.getString("cell")), left * 2, top * 2 + 25, data.getString("fontFamily"), fontSize);
                    continue block21;
                }
            }
        }
        imgBase64Str = this.saveImage(System.currentTimeMillis() + ".jpg");
        return imgBase64Str.replaceAll("[\\s*\t\n\r]", "");
    }

    private BufferedImage loadImageLocal(String imgName) {
        try {
            if (new File(FileUtil.systemFilePath + File.separator + imgName).exists()) {
                File decryFile = new File(FileUtils.getLocalFullPath((String)imgName));
                if (decryFile.exists()) {
                    return ImageIO.read(decryFile);
                }
            } else if (((Object)((Object)this)).getClass().getResource("/static" + imgName) != null) {
                return ImageIO.read(((Object)((Object)this)).getClass().getResource("/static" + imgName).openStream());
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private void modifyImagetogeter(BufferedImage d, int x, int y) {
        int w = d.getWidth();
        int h = d.getHeight();
        this.g.drawImage(d, x, y, w, h, null);
    }

    private BufferedImage imageZoom(BufferedImage d, int newWidth, int newHeight) {
        int w = d.getWidth();
        int h = d.getHeight();
        float wRatio = (float)w / (float)newWidth;
        float hRatio = (float)h / (float)newHeight;
        float newRatio = (float)newWidth / (float)newHeight;
        d = wRatio > hRatio ? d.getSubimage((int)((float)w - (float)h * newRatio) / 2, 0, (int)((float)h * newRatio), h) : d.getSubimage(0, (int)((float)h - (float)w / newRatio) / 2, w, (int)((float)w / newRatio));
        BufferedImage r = new BufferedImage(newWidth, newHeight, 1);
        r.getGraphics().drawImage(d.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
        return r;
    }

    private void modifyImage(Object content, int x, int y, String fontStyle, int fontSize) {
        this.setFont(fontStyle, fontSize);
        this.g.setFont(this.font);
        this.x = x;
        this.y = y;
        if (content != null) {
            this.g.drawString(content.toString(), this.x, this.y);
        }
    }

    private void setFont(String fontStyle, int fontSize) {
        this.font = new Font("Arial,\u5fae\u8f6f\u96c5\u9ed1", 0, fontSize);
    }

    private String saveImage(String newImage) {
        String imgBase64Str = "";
        if (this.buffImage != null) {
            try {
                String xmlPath = "upload/vis/printTemplate/cardPrintImages/";
                String fullPath = FileUtil.systemFilePath + File.separator + xmlPath;
                File outputfile = new File(new File(fullPath), newImage);
                if (!outputfile.getParentFile().exists()) {
                    outputfile.getParentFile().mkdirs();
                } else if (outputfile.exists()) {
                    outputfile.delete();
                }
                ImageIO.write((RenderedImage)this.buffImage, "jpg", outputfile);
                imgBase64Str = ImgEncodeUtil.encodeBase64((String)outputfile.getAbsolutePath());
                this.g.dispose();
                this.g = null;
                this.buffImage.flush();
                this.buffImage = null;
                FileUtils.deleteFile((String)outputfile.getAbsolutePath());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return imgBase64Str;
    }
}

