/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vis.remote.VisAutoSignRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAutoSignService;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoExitSelectReaderItem;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAutoSignController
extends BaseController
implements VisAutoSignRemote {
    @Autowired
    private VisAutoSignService visAutoSignService;

    public ModelAndView index() {
        String autoExitType = this.request.getParameter("autoSign");
        List visAutoSignItemList = null;
        if ("0".equals(autoExitType)) {
            return new ModelAndView("vis/autoSign/visAutoSign");
        }
        if ("1".equals(autoExitType)) {
            visAutoSignItemList = this.visAutoSignService.synchronousReaders();
            this.request.setAttribute("tempAccList", (Object)visAutoSignItemList);
            return new ModelAndView("vis/autoSign/visAutoSignAcc");
        }
        if ("2".equals(autoExitType)) {
            visAutoSignItemList = this.visAutoSignService.synchronousChennel();
            this.request.setAttribute("tempParkList", (Object)visAutoSignItemList);
            return new ModelAndView("vis/autoSign/visAutoSignPark");
        }
        visAutoSignItemList = this.visAutoSignService.synchronousPsgReaders();
        this.request.setAttribute("tempPsgList", (Object)visAutoSignItemList);
        return new ModelAndView("vis/autoSign/visAutoSignPsg");
    }

    public DxGrid selectAutoSignReaderList(VisAutoExitSelectReaderItem condition) {
        String autoExitReaderType = this.request.getParameter("autoSignReaderType");
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            if ("acc".equals(autoExitReaderType)) {
                pager = this.visAutoSignService.getAccNoExistAutoSign(condition, this.getPageNo(), this.getPageSize());
            } else if ("park".equals(autoExitReaderType)) {
                pager = this.visAutoSignService.getParkNoExistAutoSign(condition, this.getPageNo(), this.getPageSize());
            } else if ("psg".equals(autoExitReaderType)) {
                pager = this.visAutoSignService.getPsgNoExistAutoSign(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
            }
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg savePoint() {
        ZKResultMsg res = new ZKResultMsg();
        this.visAutoSignService.savePoint(this.request.getParameter("accDelIds"), this.request.getParameter("autoSignAccIds"), this.request.getParameter("accDevSnReaderName"), this.request.getParameter("autoSignAccType"));
        this.visAutoSignService.savePoint(this.request.getParameter("delParkIds"), this.request.getParameter("autoSignParkIds"), this.request.getParameter("parkSentryName"), this.request.getParameter("autoSignParkType"));
        this.visAutoSignService.savePoint(this.request.getParameter("delPsgIds"), this.request.getParameter("autoSignPsgIds"), this.request.getParameter("psgDevSnReaderName"), this.request.getParameter("autoSignPsgType"));
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

