/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisAutoExitReportRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAutoExitReportService;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoExitReportItem;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAutoExitReportController
extends ExportController
implements VisAutoExitReportRemote {
    @Autowired
    private VisAutoExitReportService visAutoExitReportService;

    @RequiresPermissions(value={"vis:autoExitReport"})
    public ModelAndView index() {
        return new ModelAndView("vis/autoExitReport/visAutoExitReport");
    }

    @RequiresPermissions(value={"vis:autoExitReport:refresh"})
    public DxGrid list(VisAutoExitReportItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.visAutoExitReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"vis:autoExitReport:export"})
    @LogRequest(module="vis_module", object="vis_leftMenu_lastAddr", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VisAutoExitReportItem visAutoExitReportItem = new VisAutoExitReportItem();
        this.setConditionValue((BaseItem)visAutoExitReportItem);
        List itemList = this.visAutoExitReportService.getItemData(VisAutoExitReportItem.class, (BaseItem)visAutoExitReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, VisAutoExitReportItem.class);
    }
}

