/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisAutoExitRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAutoExitService;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoExitItem;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoExitSelectReaderItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAutoExitController
extends BaseController
implements VisAutoExitRemote {
    @Autowired
    private VisAutoExitService visAutoExitService;
    @Value(value="${system.language:zh_CN}")
    private String language;

    @RequiresPermissions(value={"vis:autoExit:view"})
    public ModelAndView index() {
        String autoExitType = this.request.getParameter("AutoExit");
        List visAutoExitItemList = null;
        if ("0".equals(autoExitType)) {
            return new ModelAndView("vis/autoExit/visAutoExitMain");
        }
        if ("1".equals(autoExitType)) {
            visAutoExitItemList = this.visAutoExitService.synchronousExitPoint(autoExitType);
            this.request.setAttribute("tempList", (Object)visAutoExitItemList);
            return new ModelAndView("vis/autoExit/visAutoExitAcc");
        }
        if ("2".equals(autoExitType)) {
            visAutoExitItemList = this.visAutoExitService.synchronousExitPoint(autoExitType);
            this.request.setAttribute("tempParkList", (Object)visAutoExitItemList);
            return new ModelAndView("vis/autoExit/visAutoExitPark");
        }
        visAutoExitItemList = this.visAutoExitService.synchronousPsgReaders();
        this.request.setAttribute("tempPsgList", (Object)visAutoExitItemList);
        return new ModelAndView("vis/autoExit/visAutoExitPsg");
    }

    @RequiresPermissions(value={"vis:autoExit:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visAutoExitService.getItemById(id));
        }
        return new ModelAndView("vis/autoExit/editVisAutoExit");
    }

    @RequiresPermissions(value={"vis:autoExit:edit"})
    public ZKResultMsg save(VisAutoExitItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visAutoExitService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VisAutoExitItem condition) {
        Pager pager = this.visAutoExitService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.visAutoExitService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectAutoExitReaderList(VisAutoExitSelectReaderItem condition) {
        Pager pager = new Pager();
        String selectIds = this.request.getParameter("selectValue");
        if (StringUtils.isBlank((CharSequence)selectIds)) {
            selectIds = "";
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectIds = StringUtils.isNotBlank((CharSequence)selectIds) ? selectIds + "," + condition.getSelectId() : condition.getSelectId();
        }
        condition.setSelectId(selectIds);
        if (condition.getType().equals("noSelected")) {
            String autoExitReaderType = this.request.getParameter("autoExitReaderType");
            pager = "acc".equals(autoExitReaderType) ? this.visAutoExitService.getNoExistAutoExit(condition, this.getPageNo(), this.getPageSize()) : ("park".equals(autoExitReaderType) ? this.visAutoExitService.getParkNoExistAutoExit(condition, this.getPageNo(), this.getPageSize()) : ("psg".equals(autoExitReaderType) ? this.visAutoExitService.getPsgNoExistAutoExit(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize()) : this.visAutoExitService.getNoExistAutoExitFilterArea(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize())));
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_autoExitPlace", opType="vis_leftMenu_autoExitPlace", requestParams={"delIds", "devSnReaderName"}, opContent="vis_leftMenu_autoExitPlace")
    public ZKResultMsg savePoint() {
        ZKResultMsg res = new ZKResultMsg();
        String delIds = this.request.getParameter("delIds");
        String autoExitIds = this.request.getParameter("autoExitIds");
        String autoExitType = this.request.getParameter("autoExitType");
        String devSnReaderName = this.request.getParameter("devSnReaderName");
        this.visAutoExitService.savePoint(delIds, autoExitIds, devSnReaderName, autoExitType);
        String autoExitParkType = this.request.getParameter("autoExitParkType");
        String autoParkExitIds = this.request.getParameter("autoExitParkIds");
        String delParkIds = this.request.getParameter("delParkIds");
        String parkSentryName = this.request.getParameter("parkSentryName");
        if (StringUtils.isNotBlank((CharSequence)autoExitParkType)) {
            this.visAutoExitService.savePoint(delParkIds, autoParkExitIds, parkSentryName, autoExitParkType);
        }
        this.visAutoExitService.savePoint(this.request.getParameter("delPsgIds"), this.request.getParameter("autoExitPsgIds"), this.request.getParameter("psgDevSnReaderName"), this.request.getParameter("autoExitPsgType"));
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

