/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.constants.VisTemplateConstants;
import com.zkteco.zkbiosecurity.vis.remote.VisAlertTemplateRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAlertTemplateService;
import com.zkteco.zkbiosecurity.vis.vo.VisAlertTemplateItem;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAlertTemplateController
extends BaseController
implements VisAlertTemplateRemote {
    @Autowired
    private VisAlertTemplateService visAlertTemplateService;

    @RequiresPermissions(value={"vis:alertTemplate"})
    public ModelAndView index() {
        this.request.setAttribute("showSMS", (Object)this.visAlertTemplateService.checkShowSMS());
        return new ModelAndView("vis/alertTemplate/visAlertTemplate");
    }

    @RequiresPermissions(value={"vis:alertTemplate:refresh"})
    public DxGrid list(VisAlertTemplateItem condition) {
        Pager pager = this.visAlertTemplateService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:alertTemplate:edit", "vis:alertTemplate:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visAlertTemplateService.getItemById(id));
        }
        this.request.setAttribute("showSMS", (Object)this.visAlertTemplateService.checkShowSMS());
        this.request.setAttribute("showWhatsapp", (Object)this.visAlertTemplateService.checkShowWhatsapp());
        return new ModelAndView("vis/alertTemplate/editVisAlertTemplate");
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_alertTemplate", opType="common_op_edit", requestParams={"name"}, opContent="vis_leftMenu_alertTemplate")
    @RequiresPermissions(value={"vis:alertTemplate:edit", "vis:alertTemplate:add"})
    public ZKResultMsg save(VisAlertTemplateItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visAlertTemplateService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getFieldByEventType() {
        String eventType = this.request.getParameter("eventType");
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)eventType)) {
            short type = Short.parseShort(eventType);
            JSONObject data = new JSONObject();
            switch (type) {
                case 1: {
                    this.packJsonForEventType("1,2,3,4,5,6,7,8,9,10,11,17,18,24", data);
                    break;
                }
                case 2: {
                    this.packJsonForEventType("1,2,3,4,6,9,10,12,22", data);
                    break;
                }
                case 3: {
                    this.packJsonForEventType("1,2,3,4,5,7,8,16,17", data);
                    break;
                }
                case 4: {
                    this.packJsonForEventType("1,4,5,6,7,8,9,11,15,21", data);
                    break;
                }
                case 5: {
                    this.packJsonForEventType("1,4,6,7,8,11,13,14", data);
                    break;
                }
                case 6: {
                    this.packJsonForEventType("1,4,7,8,16", data);
                    break;
                }
                case 7: {
                    this.packJsonForEventType("1,2,3,4,5,7,8,16,17,23", data);
                }
            }
            zkResultMsg.setData((Object)data);
        }
        return zkResultMsg;
    }

    private void packJsonForEventType(String ids, JSONObject json) {
        String[] keys = ids.split(",");
        for (int i = 0; i < keys.length; ++i) {
            json.put(keys[i], (Object)I18nUtil.i18nCode((String)((String)VisTemplateConstants.fieldMap.get(keys[i])), (Object[])new Object[0]));
        }
    }

    @LogRequest(module="system_module", object="vis_leftMenu_alertTemplate", opType="common_op_del", requestParams={"names"}, opContent="vis_leftMenu_alertTemplate")
    @RequiresPermissions(value={"vis:alertTemplate:del"})
    public ZKResultMsg del(String ids) {
        ZKResultMsg zkResultMsg = this.visAlertTemplateService.delFilterInit(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public String validName(String name) {
        VisAlertTemplateItem item = this.visAlertTemplateService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getAlertTemplateTree(@RequestParam(value="eventType") String eventType, @RequestParam(value="templateType") String templateType, @RequestParam(value="linkageId", required=false) String linkageId) {
        List selectItems = this.visAlertTemplateService.getAlertTemplateList(eventType, templateType, linkageId);
        return new ZKResultMsg((Object)selectItems);
    }
}

