/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApiRegisterItem;
import com.zkteco.zkbiosecurity.vis.app.service.VisAppService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@RequestMapping(value={"/app/v2/vis"})
public class VisAppV2Controller {
    @Autowired
    private VisAppService visAppService;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;

    @RequestMapping(value={"/getVisTodayVisitCount"}, method={RequestMethod.POST})
    public AppResultMessage getVisTodayVisitCount(@RequestBody JSONObject data) {
        String userName = this.request.getParameter("user_name");
        String loginType = data.getString("loginType");
        return this.visAppService.getVisTodayVisitCount(userName, loginType);
    }

    @RequestMapping(value={"/getPlaceList"}, method={RequestMethod.POST})
    public AppResultMessage getPlaceList(@RequestBody JSONObject data) {
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        return this.visAppService.getPlaceList(new VisPlaceItem(), pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getVisTransactionByFilters"}, method={RequestMethod.POST})
    public AppResultMessage getVisTransactionByFilters(@RequestBody JSONObject data) {
        String filters = data.getString("filters");
        String loginType = data.getString("loginType");
        String userName = this.request.getParameter("user_name");
        String startTimeStr = data.getString("startTime");
        String endTimeStr = data.getString("endTime");
        String visitState = data.getString("visitState");
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        VisTransactionItem condition = new VisTransactionItem();
        if (StringUtils.isNotBlank((CharSequence)startTimeStr) && StringUtils.isNotBlank((CharSequence)endTimeStr)) {
            Date startTime = DateUtil.stringToDate((String)startTimeStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
            Date endTime = DateUtil.stringToDate((String)endTimeStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
            condition.setStartEnterTime(startTime);
            condition.setEndEnterTime(endTime);
        } else {
            condition.setStartEnterTime(DateUtil.getTodayBeginTime());
            condition.setEndEnterTime(DateUtil.getTodayEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            condition.setLikeName(filters);
        }
        if (StringUtils.isNotBlank((CharSequence)visitState)) {
            condition.setVisitState(Short.valueOf(visitState));
        }
        return this.visAppService.getVisTransactionPage(userName, loginType, condition, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/visitorRegistration"}, method={RequestMethod.POST})
    public AppResultMessage visitorRegistration(@RequestBody VisApiRegisterItem apiVisRegisterItem) {
        if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getPersPersonPin())) {
            String requiredVisitedEmp = this.visParamsService.getVisParamByName("vis.requiredVisitedEmp");
            if ("1".equals(requiredVisitedEmp)) {
                return AppResultMessage.failMessage().setRet("-240").setMessage(I18nUtil.i18nCode((String)"vis_api_persPersonPinNotNull", (Object[])new Object[0]));
            }
        } else {
            if (apiVisRegisterItem.getCertType() == null) {
                return AppResultMessage.failMessage().setRet("-241").setMessage(I18nUtil.i18nCode((String)"vis_api_certTypeNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getCertNum())) {
                return AppResultMessage.failMessage().setRet("-242").setMessage(I18nUtil.i18nCode((String)"vis_api_certNumNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getVisEmpName())) {
                return AppResultMessage.failMessage().setRet("-243").setMessage(I18nUtil.i18nCode((String)"vis_api_visitEmpNameNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getStartTime()) || StringUtils.isBlank((CharSequence)apiVisRegisterItem.getEndTime())) {
                return AppResultMessage.failMessage().setRet("-247").setMessage(I18nUtil.i18nCode((String)"vis_api_visitDateNotNull", (Object[])new Object[0]));
            }
            if (apiVisRegisterItem.getVisitorCount() == null || apiVisRegisterItem.getVisitorCount() <= 0) {
                return AppResultMessage.failMessage().setRet("-258").setMessage(I18nUtil.i18nCode((String)"vis_api_wrongVisitorCount", (Object[])new Object[0]));
            }
        }
        AppResultMessage resultMessage = AppResultMessage.successMessage();
        try {
            ApiResultMessage rs = this.visTransactionService.saveApiVisRegister(apiVisRegisterItem);
            if (rs.getCode() != 0) {
                return AppResultMessage.failMessage().setRet(rs.getCode() + "").setMessage(rs.getMessage());
            }
            resultMessage.setData(rs.getData());
        }
        catch (ZKBusinessException e) {
            if ("common_startEndDateCompare".equals(e.getMessage())) {
                return AppResultMessage.failMessage().setRet("-252").setMessage(I18nUtil.i18nCode((String)"common_startEndDateCompare", (Object[])new Object[0]));
            }
            if ("vis_message_reservationEndTimeLessNowTime".equals(e.getMessage())) {
                return AppResultMessage.failMessage().setRet("-252").setMessage(I18nUtil.i18nCode((String)"vis_message_reservationEndTimeLessNowTime", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            return AppResultMessage.failMessage().setRet("-1");
        }
        return resultMessage;
    }

    @RequestMapping(value={"/reservationInvitation"}, method={RequestMethod.POST})
    public AppResultMessage reservationInvitation(@RequestBody VisAutoReservationItem appReservationItem) {
        return this.visAppService.reservationInvitation(appReservationItem);
    }

    @RequestMapping(value={"/getVisReservationByFilters"}, method={RequestMethod.POST})
    public AppResultMessage getVisReservationByFilters(@RequestBody JSONObject message) {
        String filters = message.getString("filters");
        String reservationType = message.getString("reservationType");
        String userId = this.request.getParameter("user_id");
        String auditStatus = message.getString("auditStatus");
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        VisReservationItem reservationItem = new VisReservationItem();
        reservationItem.setReservationType(reservationType);
        reservationItem.setVisitedEmpId(userId);
        if (StringUtils.isNotBlank((CharSequence)auditStatus)) {
            reservationItem.setAuditStatus(Short.valueOf(auditStatus));
        }
        return this.visAppService.getVisReservationByFilters(filters, reservationItem, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/audit"}, method={RequestMethod.POST})
    public AppResultMessage audit(@RequestBody JSONObject message) {
        String id = message.getString("id");
        String type = message.getString("type");
        return this.visAppService.audit(id, type);
    }

    @RequestMapping(value={"/confirmInvite"}, method={RequestMethod.POST})
    public AppResultMessage confirmInvite(@RequestBody VisAutoReservationItem item) {
        return this.visAppService.confirmInvite(item);
    }

    @RequestMapping(value={"/visitorReservation"}, method={RequestMethod.POST})
    public AppResultMessage visitorReservation(@RequestBody VisAutoReservationItem item) {
        return this.visAppService.visAutoRes(item);
    }

    @RequestMapping(value={"/getReservationById"}, method={RequestMethod.POST})
    public AppResultMessage getReservationById(@RequestBody JSONObject message) {
        String id = message.getString("id");
        return this.visAppService.getReservationById(id);
    }

    @RequestMapping(value={"/getVisitedName"}, method={RequestMethod.POST})
    public AppResultMessage getVisitedName(@RequestBody JSONObject message) {
        String name = message.getString("name");
        List items = this.visVisitedPersonService.getPersonListByName(name);
        return AppResultMessage.successMessage().setData((Object)items);
    }
}

