/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.app.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.vis.app.service.VisAppService;
import com.zkteco.zkbiosecurity.vis.app.vo.VisAppParamItem;
import com.zkteco.zkbiosecurity.vis.app.vo.VisAppReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@RequestMapping(value={"/app/v1"})
public class VisAppController {
    @Autowired
    private VisAppService visAppService;

    @RequestMapping(value={"/getVisLevels"}, method={RequestMethod.POST})
    public AppResultMessage getVisLevels(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String levelName = StringUtils.isNotBlank((CharSequence)message.getString("levelName")) ? message.getString("levelName") : "";
        String moduleName = StringUtils.isNotBlank((CharSequence)message.getString("moduleName")) ? message.getString("moduleName") : "";
        return this.visAppService.getVisLevels(moduleName, levelName, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/delVisLevel"}, method={RequestMethod.POST})
    public AppResultMessage delVisLevel(@RequestBody JSONObject message) {
        AppResultMessage appResultMessage = new AppResultMessage();
        String levelId = message.getString("id");
        if (StringUtils.isBlank((CharSequence)levelId)) {
            appResultMessage.setRet(String.valueOf(-259));
            appResultMessage.setMessage(I18nUtil.i18nCode((String)"common_prompt_selectObj", (Object[])new Object[0]));
            return appResultMessage;
        }
        return this.visAppService.delVisLevel(levelId);
    }

    @RequestMapping(value={"/loadAccLevel"}, method={RequestMethod.POST})
    public AppResultMessage loadAccLevel(@RequestBody JSONObject message) {
        String levelName = message.getString("levelName");
        String token = message.getString("token");
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.visAppService.loadAccLevel(token, levelName, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/loadEleLevel"}, method={RequestMethod.POST})
    public AppResultMessage loadEleLevel(@RequestBody JSONObject message) {
        String levelName = message.getString("levelName");
        String token = message.getString("token");
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.visAppService.loadEleLevel(token, levelName, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/addAccLevel"}, method={RequestMethod.POST})
    public AppResultMessage addAccLevel(@RequestBody JSONObject message) {
        String levelIds = message.getString("levelIds");
        String levelNames = message.getString("levelNames");
        return this.visAppService.saveLevel(levelIds, levelNames, "acc");
    }

    @RequestMapping(value={"/addEleLevel"}, method={RequestMethod.POST})
    public AppResultMessage addEleLevel(@RequestBody JSONObject message) {
        String levelIds = message.getString("levelIds");
        String levelNames = message.getString("levelNames");
        return this.visAppService.saveLevel(levelIds, levelNames, "ele");
    }

    @RequestMapping(value={"/synchronousLevel"}, method={RequestMethod.POST})
    public AppResultMessage synchronousLevel() {
        return this.visAppService.synchronousLevel();
    }

    @RequestMapping(value={"/getLevelPersonByFilter"}, method={RequestMethod.POST})
    public AppResultMessage getLevelPersonByFilter(@RequestBody JSONObject message) {
        String levelId = message.getString("levelId");
        String filter = message.getString("filter");
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.visAppService.getLevelPersonByFilter(levelId, filter, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getAllCertType"}, method={RequestMethod.POST})
    public AppResultMessage getAllCertType() {
        return this.visAppService.getAllCertType();
    }

    @RequestMapping(value={"/getDeptByVisitEmpPin"}, method={RequestMethod.POST})
    public AppResultMessage getDeptByVisitEmpPin(@RequestBody JSONObject message) {
        String empPin = message.getString("empPin");
        String token = message.getString("token");
        return this.visAppService.getDeptByVisitEmpPin(empPin, token);
    }

    @RequestMapping(value={"/editVisReservation"}, method={RequestMethod.POST})
    public AppResultMessage editVisReservation(@RequestBody VisAppReservationItem visAppReservationItem) {
        return this.visAppService.editVisReservation(visAppReservationItem);
    }

    @RequestMapping(value={"/getVisReservationByFilters"}, method={RequestMethod.POST})
    public AppResultMessage getVisReservationByFilters(@RequestBody JSONObject message) {
        String filters = message.getString("filters");
        String startTimeStr = message.getString("startTime");
        String endTimeStr = message.getString("endTime");
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.visAppService.getVisReservationByFilters(filters, startTimeStr, endTimeStr, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getVisTransactionByFilters"}, method={RequestMethod.POST})
    public AppResultMessage getVisTransactionByFilters(@RequestBody JSONObject message) {
        String filters = message.getString("filters");
        String token = message.getString("token");
        String startTimeStr = message.getString("startTime");
        String endTimeStr = message.getString("endTime");
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.visAppService.getVisTransactionByFilters(token, filters, startTimeStr, endTimeStr, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getVisTransactionById"}, method={RequestMethod.POST})
    public AppResultMessage getVisTransactionById(@RequestBody JSONObject message) {
        AppResultMessage appResultMessage = new AppResultMessage();
        String id = message.getString("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            appResultMessage = this.visAppService.getVisTransactionById(id);
        }
        return appResultMessage;
    }

    @RequestMapping(value={"/delReservationByIds"}, method={RequestMethod.POST})
    public AppResultMessage delReservationByIds(@RequestBody JSONObject message) {
        return this.visAppService.delReservationByIds(message.getString("id"));
    }

    @RequestMapping(value={"/getVisParam"}, method={RequestMethod.POST})
    public AppResultMessage getVisParam() {
        return this.visAppService.getVisParam();
    }

    @RequestMapping(value={"/setVisParam"}, method={RequestMethod.POST})
    public AppResultMessage setVisParam(@RequestBody VisAppParamItem visAppParamItem) {
        AppResultMessage appResultMessage = this.visAppService.setVisParam(visAppParamItem);
        return appResultMessage;
    }

    @RequestMapping(value={"/getCriteriaByType"}, method={RequestMethod.POST})
    public AppResultMessage getCriteriaByType(@RequestBody JSONObject message) {
        AppResultMessage appResultMessage = new AppResultMessage();
        JSONArray jsonArray = new JSONArray();
        String type = message.getString("type");
        JSONObject dataJson1 = new JSONObject();
        JSONObject dataJson2 = new JSONObject();
        JSONObject dataJson3 = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            if ("visLevel".equals(type)) {
                dataJson1.put("criteriaCore", (Object)"acc");
                dataJson1.put("criteriaName", (Object)"VIS_APP_ACCMODULE");
                dataJson2.put("criteriaCore", (Object)"ele");
                dataJson2.put("criteriaName", (Object)"VIS_APP_ELEMODULE");
                jsonArray.add((Object)dataJson1);
                jsonArray.add((Object)dataJson2);
            } else if ("visReservation".equals(type)) {
                dataJson1.put("criteriaCore", (Object)"hasVisited");
                dataJson1.put("criteriaName", (Object)"VIS_RESERVATION_HASVISITED");
                dataJson2.put("criteriaCore", (Object)"notVisited");
                dataJson2.put("criteriaName", (Object)"VIS_RESERVATION_NOTVISITED");
                dataJson3.put("criteriaCore", (Object)"waste");
                dataJson3.put("criteriaName", (Object)"VIS_RESERVATION_WASTE");
                jsonArray.add((Object)dataJson1);
                jsonArray.add((Object)dataJson2);
                jsonArray.add((Object)dataJson3);
            } else if ("visTransaction".equals(type)) {
                dataJson1.put("criteriaCore", (Object)"notExitToday");
                dataJson1.put("criteriaName", (Object)"VIS_TITLE_NOTEXITTODAY");
                dataJson2.put("criteriaCore", (Object)"checkInToday");
                dataJson2.put("criteriaName", (Object)"VIS_TITLE_CHECKINTODAY");
                jsonArray.add((Object)dataJson1);
                jsonArray.add((Object)dataJson2);
            }
            appResultMessage.setData((Object)jsonArray);
        }
        return appResultMessage;
    }

    @RequestMapping(value={"/getVisReason"}, method={RequestMethod.POST})
    public AppResultMessage getVisReason() {
        return this.visAppService.getVisReason();
    }

    @RequestMapping(value={"/getVisInfoByCertTypeAndCertNumber"}, method={RequestMethod.POST})
    public String getVisInfoByCertTypeAndCertNumber(@RequestBody JSONObject message) {
        VisVisitorItem visVisitorItem;
        JSONObject retJson = new JSONObject();
        String certType = message.getString("visCertType");
        String certNumber = message.getString("visCertNumber");
        if (certType != null && StringUtils.isNotBlank((CharSequence)certNumber) && (visVisitorItem = this.visAppService.getVisInfoByCertTypeAndCertNumber(certType, certNumber)) != null) {
            if (!visVisitorItem.getEnabled().booleanValue()) {
                retJson.put("ret", (Object)String.valueOf(-254));
                retJson.put("message", (Object)I18nUtil.i18nCode((String)"vis_message_disabledEmp", (Object[])new Object[0]));
                return retJson.toString();
            }
            retJson.put("visName", (Object)visVisitorItem.getName());
            if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
                retJson.put("visLastName", (Object)visVisitorItem.getLastName());
            }
            retJson.put("visCompany", (Object)visVisitorItem.getCompany());
            retJson.put("visPhone", (Object)visVisitorItem.getPhone());
            retJson.put("ret", (Object)"OK");
        }
        return retJson.toString();
    }
}

