/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.api.controller;

import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/visReservation"})
public class VisCloudApiReservationController {
    private static final Logger log = LoggerFactory.getLogger(VisCloudApiReservationController.class);
    @Autowired
    private VisReservationService visReservationService;

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/checkBlackCarPlate"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg checkBlackCarPlate(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = new ZKResultMsg();
        try {
            String carPlate = MapUtils.getString((Map)zkMessage.getContent(), (Object)"carPlate");
            String certType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"certType");
            String certNumber = MapUtils.getString((Map)zkMessage.getContent(), (Object)"certNumber");
            boolean blackCarPlate = this.visReservationService.checkBlackCarPlate(carPlate);
            if (blackCarPlate) {
                rs.setData((Object)blackCarPlate);
                rs.setMsg(I18nUtil.i18nCode((String)"vis_message_cannotSaveVis", (Object[])new Object[0]));
                return I18nUtil.i18nMsg((ZKResultMsg)rs);
            }
            boolean isExistWhitePlate = this.visReservationService.checkWhiteListCarPlate(certType, certNumber, carPlate);
            if (isExistWhitePlate) {
                rs.setData((Object)isExistWhitePlate);
                rs.setMsg(I18nUtil.i18nCode((String)"vis_message_existWhiteCarNumber", (Object[])new Object[0]));
                return I18nUtil.i18nMsg((ZKResultMsg)rs);
            }
            return ZKResultMsg.successMsg();
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }
}

