/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.api.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.vis.api.service.VisCloudApiInvitationService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/visInvitation"})
public class VisCloudApiInvitationController {
    private static final Logger log = LoggerFactory.getLogger(VisCloudApiInvitationController.class);
    @Autowired
    private VisCloudApiInvitationService visCloudApiInvitationService;
    @Autowired
    private VisReservationService visReservationService;

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/inviteVisitor"})
    public ZKResultMsg inviteVisitor(@RequestBody ZKMessage zkMessage) {
        try {
            List visReservationItems = new ArrayList();
            VisReservationItem visReservationItem = new VisReservationItem();
            List visReservationMessageList = zkMessage.getListContent();
            if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
                visReservationItems = JSONArray.parseArray((String)JSON.toJSONString((Object)visReservationMessageList), VisReservationItem.class);
                visReservationItem = (VisReservationItem)visReservationItems.get(0);
                visReservationItem = this.visCloudApiInvitationService.saveVisitorReservation(visReservationItem);
            }
            return new ZKResultMsg((Object)visReservationItem);
        }
        catch (ZKBusinessException e) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]), (Object[])new Object[0]);
        }
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/revokeInvitation"})
    public ZKResultMsg revokeInvitation(@RequestBody ZKMessage zkMessage) {
        String id = MapUtils.getString((Map)zkMessage.getContent(), (Object)"id");
        String type = MapUtils.getString((Map)zkMessage.getContent(), (Object)"type");
        String auditorPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"auditorPin");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisReservationItem visReservationItem = new VisReservationItem();
            visReservationItem.setId(id);
            visReservationItem.setAuditorPin(auditorPin);
            if ("1".equals(type)) {
                return this.visReservationService.revokeInvitation(id, Boolean.valueOf(true));
            }
            return this.visReservationService.revokeReservation(visReservationItem);
        }
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/confirmInvite"})
    public ZKResultMsg confirmInvite(@RequestBody ZKMessage zkMessage) {
        try {
            List visReservationItems = new ArrayList();
            VisReservationItem visReservationItem = new VisReservationItem();
            List visReservationMessageList = zkMessage.getListContent();
            if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
                visReservationItems = JSONArray.parseArray((String)JSON.toJSONString((Object)visReservationMessageList), VisReservationItem.class);
                visReservationItem = (VisReservationItem)visReservationItems.get(0);
                visReservationItem = this.visCloudApiInvitationService.confirmInvite(visReservationItem);
            }
            return new ZKResultMsg((Object)visReservationItem);
        }
        catch (ZKBusinessException e) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]), (Object[])new Object[0]);
        }
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/confirmReservation"})
    public ZKResultMsg confirmReservation(@RequestBody ZKMessage zkMessage) {
        String id = MapUtils.getString((Map)zkMessage.getContent(), (Object)"id");
        String auditType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"auditType");
        String remark = MapUtils.getString((Map)zkMessage.getContent(), (Object)"remark");
        String auditorPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"auditorPin");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)auditType)) {
            VisReservationItem item = new VisReservationItem();
            item.setId(id);
            item.setAuditRemark(remark);
            item.setAuditorPin(auditorPin);
            ZKResultMsg msg = this.visCloudApiInvitationService.confirmReservation(item, auditType);
            if (ZKResultMsg.successMsg().getRet().equals(msg.getRet()) && msg.getData() != null) {
                item = (VisReservationItem)msg.getData();
                msg.setData((Object)item.getAppId());
            }
            return msg;
        }
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisitedPersonInfo"})
    public ZKResultMsg getVisitedPersonInfo(@RequestBody ZKMessage zkMessage) {
        String page = MapUtils.getString((Map)zkMessage.getContent(), (Object)"page");
        String pageSize = MapUtils.getString((Map)zkMessage.getContent(), (Object)"pageSize");
        String filter = MapUtils.getString((Map)zkMessage.getContent(), (Object)"filter");
        if (StringUtils.isBlank((CharSequence)page) || StringUtils.isBlank((CharSequence)pageSize)) {
            throw ZKBusinessException.errorException((String)"vis_cloud_pageNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)filter)) {
            throw ZKBusinessException.errorException((String)"vis_cloud_filterNull", (Object[])new Object[0]);
        }
        return this.visCloudApiInvitationService.getItemByPersonNameOrMobilePhone(filter, Integer.parseInt(page), Integer.parseInt(pageSize));
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisitRecord"})
    public ZKResultMsg getVisitRecord(@RequestBody ZKMessage zkMessage) {
        String page = MapUtils.getString((Map)zkMessage.getContent(), (Object)"page");
        String pageSize = MapUtils.getString((Map)zkMessage.getContent(), (Object)"pageSize");
        String filter = MapUtils.getString((Map)zkMessage.getContent(), (Object)"filter");
        String persPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"pin");
        if (StringUtils.isBlank((CharSequence)page) || StringUtils.isBlank((CharSequence)pageSize)) {
            throw ZKBusinessException.errorException((String)"vis_cloud_pageNull", (Object[])new Object[0]);
        }
        return this.visCloudApiInvitationService.getVisitRecord(filter, persPin, Integer.parseInt(page), Integer.parseInt(pageSize));
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getCertType"})
    public ZKResultMsg getCertType() {
        return this.visCloudApiInvitationService.getCertType();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getInviteAuthorize"})
    public ZKResultMsg getInviteAuthorize(@RequestBody ZKMessage zkMessage) {
        String pin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"pin");
        return this.visCloudApiInvitationService.getInviteAuthorize(pin);
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisitorDynamicCode"})
    public ZKResultMsg getVisitorDynamicCode(@RequestBody ZKMessage zkMessage) {
        String id = MapUtils.getString((Map)zkMessage.getContent(), (Object)"id");
        String wxOpenId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"wxOpenId");
        return this.visCloudApiInvitationService.getVisitorDynamicCode(id, wxOpenId);
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getReservationInfo"})
    public ZKResultMsg getReservationInfo(@RequestBody ZKMessage zkMessage) {
        String id = MapUtils.getString((Map)zkMessage.getContent(), (Object)"id");
        return this.visCloudApiInvitationService.getReservationInfo(id);
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getInviteRecord"})
    public ZKResultMsg getInviteRecord(@RequestBody ZKMessage zkMessage) {
        String type = MapUtils.getString((Map)zkMessage.getContent(), (Object)"type");
        String perPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"visitEmpPin");
        String filter = MapUtils.getString((Map)zkMessage.getContent(), (Object)"filter");
        String wxOpenId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"wxOpenId");
        String wxOriginalId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"wxOriginalId");
        String auditStatus = MapUtils.getString((Map)zkMessage.getContent(), (Object)"auditStatus");
        String page = MapUtils.getString((Map)zkMessage.getContent(), (Object)"page");
        String pageSize = MapUtils.getString((Map)zkMessage.getContent(), (Object)"pageSize");
        VisReservationItem visReservationItem = new VisReservationItem();
        if (StringUtils.isNotBlank((CharSequence)perPin)) {
            visReservationItem.setVisitEmpPin(perPin);
        }
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            visReservationItem.setWxOpenId(wxOpenId);
        }
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            visReservationItem.setWxOriginalId(wxOriginalId);
        }
        if (StringUtils.isNotBlank((CharSequence)auditStatus)) {
            visReservationItem.setAuditStatus(Short.valueOf(Short.parseShort(auditStatus)));
        }
        return this.visCloudApiInvitationService.getInviteRecord(visReservationItem, type, filter, Integer.parseInt(page), Integer.parseInt(pageSize));
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisAttribute"})
    public ZKResultMsg getVisAttribute(@RequestBody ZKMessage zkMessage) {
        return this.visCloudApiInvitationService.getVisAttribute();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisReason"})
    public ZKResultMsg getVisReason(@RequestBody ZKMessage zkMessage) {
        return this.visCloudApiInvitationService.getVisReason();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getRecentVisit"})
    public ZKResultMsg getRecentVisit(@RequestBody ZKMessage zkMessage) {
        String phone = MapUtils.getString((Map)zkMessage.getContent(), (Object)"phone");
        String wxOpenId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"wxOpenId");
        String wxOriginalId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"wxOriginalId");
        String appId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"appId");
        VisReservationItem item = new VisReservationItem();
        item.setPhone(phone);
        item.setWxOpenId(wxOpenId);
        item.setWxOriginalId(wxOriginalId);
        item.setAppId(appId);
        return this.visCloudApiInvitationService.getRecentVisit(item);
    }
}

