/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApiLevelItem;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisLevelItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/visLevel"})
@Api(tags={"VisLevel"}, description="visitor level")
public class VisApiV2VisLevelController {
    private static final Logger log = LoggerFactory.getLogger(VisApiV2VisLevelController.class);
    @Autowired
    private VisLevelService visLevelService;

    @ApiOperation(value="Get Vis Level List", notes="Return Vis Level List", response=ApiResultMessage.class)
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getVisLevelList(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        ApiResultMessage rs = null;
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.failedMessage((int)-90);
        }
        try {
            ArrayList visApiLevelItems = Lists.newArrayList();
            Pager pager = this.visLevelService.getItemsByPage((BaseItem)new VisLevelItem(), pageNo - 1, pageSize.intValue());
            List visLevelItemList = pager.getData();
            if (!visLevelItemList.isEmpty()) {
                visLevelItemList.forEach(visLevelItem -> {
                    VisApiLevelItem visApiLevelItem = VisApiLevelItem.createApiLevel((VisLevelItem)visLevelItem);
                    if (visApiLevelItem != null) {
                        visApiLevelItems.add(visApiLevelItem);
                    }
                });
            }
            pager.setData((List)visApiLevelItems);
            rs = ApiResultMessage.successMessage((Object)pager);
        }
        catch (Exception e) {
            log.error("api visLevel/list error ", (Throwable)e);
            rs = ApiResultMessage.failedMessage((int)-1);
        }
        return rs;
    }
}

