/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=130)
public class InsInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("InsInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initInsParams();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("InsInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        AuthPermissionItem systemItem = new AuthPermissionItem("Ins", "ins_module", "ins", "system", "true", Integer.valueOf(13));
        systemItem = this.authPermissionService.saveItem(systemItem);
        parentMenuItem = new AuthPermissionItem("InsDeviceManager", "ins_device_manager", "ins:device:manager", "menu", "true", Integer.valueOf(1));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setActionLink("insDevice.do");
        parentMenuItem.setImg("ins_device.png");
        parentMenuItem.setImgHover("ins_device_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("InsDevice", "ins_leftMenu_device", "ins:device", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insDevice.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceRefresh", "common_op_refresh", "ins:device:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceEdit", "common_op_edit", "ins:device:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceDel", "common_op_del", "ins:device:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceSearch", "common_dev_searchDev", "ins:device:search", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceEnable", "common_enable", "ins:device:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceDisable", "common_disable", "ins:device:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceReboot", "common_dev_reboot", "ins:device:reboot", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceSyncDev", "ins_op_syncDev", "ins:device:syncdev", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceGetDevOpt", "common_dev_getDevOpt", "Ins:device:getdevopt", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceQueryOption", "ins_deviceOption_query", "ins:device:queryOption", "button", "true", Integer.valueOf(10));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceSetStamp", "ins_op_check", "ins:device:setstamp", "button", "true", Integer.valueOf(11));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceFillPin", "ins_device_getPin", "ins:device:fillpin", "button", "true", Integer.valueOf(12));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceDeleteCmd", "ins_op_deleteCmd", "ins:device:deletecmd", "button", "true", Integer.valueOf(13));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceClearInsLog", "ins_op_clearInsLog", "ins:device:clearinslog", "button", "true", Integer.valueOf(14));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceClearInsPic", "ins_op_clearInsPic", "ins:device:clearinspic", "button", "true", Integer.valueOf(15));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsDeviceSendQrAddress", "ins_op_sendQrAddress", "ins:device:sendqraddress", "button", "true", Integer.valueOf(16));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("InsAreaPersonByArea", "common_setByArea", "ins:areaPersonByArea", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insAreaPersonByArea.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByAreaRefresh", "common_op_refresh", "ins:areaPersonByArea:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByAreaSync", "common_dev_syncPersonInArea", "ins:areaPerson:syncPerToDev", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByAreaAddPerson", "pers_common_addPerson", "ins:areaPersonByArea:addPerson", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByAreaDelPerson", "pers_common_delPerson", "ins:areaPerson:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("InsAreaPersonByPerson", "common_setByPerson", "ins:areaPersonByPerson", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insAreaPersonByPerson.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByPersonRefresh", "common_op_refresh", "ins:areaPersonByPerson:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByPersonAddArea", "common_level_addPersonArea", "ins:areaPersonByPerson:addArea", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAreaPersonByPersonDelPerson", "base_area_delArea", "ins:areaPerson:delArea", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("InsParams", "common_leftMenu_paramSet", "ins:params", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insParams.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("InsParamsEdit", "common_op_edit", "ins:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(childMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        parentMenuItem = new AuthPermissionItem("InsAdMediaManager", "ins_ad_media_manager", "ins:admedia:manager", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setActionLink("insAdMedia.do");
        parentMenuItem.setImg("ins_adMedia.png");
        parentMenuItem.setImgHover("ins_adMedia_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("InsAdMedia", "ins_ad_media_adMediaResource", "ins:admedia", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insAdMedia.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaRefresh", "common_op_refresh", "ins:admedia:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaAdd", "common_op_add", "ins:admedia:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaEdit", "common_op_edit", "ins:admedia:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaDel", "common_op_del", "ins:admedia:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaExport", "common_op_export", "ins:admedia:export", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaImport", "common_op_import", "ins:admedia:import", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("InsAdMediaSet", "ins_ad_media_adMediaSet", "ins:adMediaDevice", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insAdMediaDevice.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaDeviceRefresh", "common_op_refresh", "ins:adMediaDevice:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaDeviceAdd", "common_op_add", "ins:adMediaDevice:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaDeviceEdit", "common_op_edit", "ins:adMediaDevice:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaDeviceDel", "common_op_del", "ins:adMediaDevice:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsAdMediaDeviceAddAd", "ins_ad_media_addAdMedia", "ins:adMediaDevice:addAd", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("InsReports", "ins_leftMenu_reports", "ins:transaction:manager", "menu", "true", Integer.valueOf(3));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("comm_reports.png");
        parentMenuItem.setImgHover("comm_reports_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("InsTransaction", "ins_transaction_manager", "ins:transaction", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("insTransaction.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsTransactionRefresh", "common_op_refresh", "ins:transaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("InsTransactionExport", "common_op_export", "ins:transaction:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != childMenuItem) {
            buttonMenuItem = new AuthPermissionItem("PersPersonInsEdit", "pers_person_insSet", "pers:person:insEdit", "button", "true", Integer.valueOf(106));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.initData(buttonMenuItem);
        }
    }

    public void initInsParams() {
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"01:00:00");
        BaseSysParamItem item = new BaseSysParamItem("insReportDataClean", values.toString(), "base_dataClean_insTrans");
        this.baseSysParamService.initData(item);
        this.baseSysParamService.initData(new BaseSysParamItem("ins.verifyPhoto.encryptProp", "true", "\u4eba\u5458\u654f\u611f\u4fe1\u606f\u4fdd\u62a4-\u9a8c\u8bc1\u7167\u7247"));
    }

    private void initUpgradeVersion() {
        BaseSysParamItem baseSysParamItem;
        String curVersion = VersionUtil.getReleaseGitTags((String)"ins");
        if (StringUtils.isNotBlank((CharSequence)curVersion) && StringUtils.isBlank((CharSequence)(baseSysParamItem = this.baseSysParamService.findByParamName("InsUpgradeVersion")).getId())) {
            baseSysParamItem = new BaseSysParamItem("InsUpgradeVersion", curVersion, "Ins Upgrade Version", Boolean.valueOf(true));
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

