/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.utils.ZKBaseFontUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EsdcExcelUtil {
    private static final Logger loger = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String XSLM = "xlsm";
    public static final String PDF = "pdf";
    public static final String CSV = "csv";
    public static final String TXT = "txt";

    public static <T> void excelExport(List<T> list, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map, Map<String, String> addReportDetailMap, String exportLocal, String capturePrivacyEnable) throws IOException {
        BufferedOutputStream ops = new BufferedOutputStream(outputStream, 8192);
        Object workbook = null;
        workbook = XLS.equals(reportType) ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(fileName);
        Drawing patriarch = sheet.createDrawingPatriarch();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonColumn, (Feature[])new Feature[]{Feature.OrderedField});
        Object extraDataMap = new LinkedMap();
        ArrayList<Object> fieldList = new ArrayList<Object>();
        String extraDataName = "";
        try {
            for (String s : jsonObject.keySet()) {
                Field field = cls.getDeclaredField(s);
                field.setAccessible(true);
                if (field.getAnnotation(GridColumn.class) != null && !field.getAnnotation(GridColumn.class).isExportExcel()) continue;
                if ("java.util.Map".equals(cls.getDeclaredField(s).getType().getTypeName())) {
                    extraDataMap = (Map)field.get(list.get(0));
                    extraDataName = s;
                    for (Map.Entry entry : extraDataMap.entrySet()) {
                        fieldList.add(entry.getKey());
                    }
                    continue;
                }
                fieldList.add(s);
            }
            CellStyle headStyle = workbook.createCellStyle();
            Font headFont = workbook.createFont();
            headFont.setFontName("ARIAL");
            headFont.setFontHeightInPoints((short)10);
            headFont.setBold(true);
            headStyle.setFont(headFont);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            CellStyle dataStyle = workbook.createCellStyle();
            dataStyle.setBorderBottom(BorderStyle.THIN);
            dataStyle.setBorderLeft(BorderStyle.THIN);
            dataStyle.setBorderTop(BorderStyle.THIN);
            dataStyle.setBorderRight(BorderStyle.THIN);
            dataStyle.setWrapText(true);
            dataStyle.setAlignment(HorizontalAlignment.CENTER);
            dataStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            Row row = sheet.createRow(0);
            Cell cell = row.createCell(0);
            cell.setCellStyle(headStyle);
            cell.setCellValue(fileName);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
            int isMergedRegion = 0;
            Row columnRow = null;
            Row columnRow3 = null;
            if (addReportDetailMap == null || addReportDetailMap.size() == 0) {
                isMergedRegion = 2;
                columnRow = sheet.createRow(1);
                columnRow3 = sheet.createRow(2);
            } else {
                if ("personSearchLocal".equals(exportLocal)) {
                    EsdcExcelUtil.addReportDetailData(addReportDetailMap, sheet);
                    isMergedRegion = 15;
                    columnRow = sheet.createRow(14);
                    columnRow3 = sheet.createRow(15);
                }
                if ("leavePostLocal".equals(exportLocal)) {
                    EsdcExcelUtil.addLeavePostReportDetailData(addReportDetailMap, sheet);
                    isMergedRegion = 14;
                    columnRow = sheet.createRow(13);
                    columnRow3 = sheet.createRow(14);
                }
            }
            int mergedRow = 0;
            int mergedRowj = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                CellRangeAddress region;
                String width = "";
                String columValue = "";
                String secHeader = "";
                if (!extraDataMap.containsKey(fieldList.get(i))) {
                    width = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).width();
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).label();
                    secHeader = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).secHeader();
                } else {
                    width = "90";
                    columValue = (String)fieldList.get(i);
                }
                if (StringUtils.isEmpty((Object)columValue)) {
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getName();
                }
                if (!StringUtils.isEmpty((Object)width) && !"*".equals(width)) {
                    sheet.setColumnWidth(i, 50 * Integer.parseInt(width));
                }
                Cell columCell = columnRow.createCell(i);
                if (!"".equals(secHeader) && !"#cspan".equals(columValue)) {
                    Cell columCell3 = columnRow3.createCell(i);
                    columCell3.setCellStyle(dataStyle);
                    columCell3.setCellValue(I18nUtil.i18nCode((String)secHeader, (Object[])new Object[0]));
                }
                if (!"".equals(secHeader) && "#cspan".equals(columValue)) {
                    ++mergedRow;
                    ++mergedRowj;
                    columCell = columnRow3.createCell(i);
                    columValue = secHeader;
                    isMergedRegion = 3;
                } else {
                    if (mergedRowj != 0) {
                        region = new CellRangeAddress(1, 1, i - mergedRowj - 1, i - 1);
                        sheet.addMergedRegion(region);
                        EsdcExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                    }
                    mergedRowj = 0;
                }
                if (mergedRowj != 0 && i == fieldList.size() - 1) {
                    region = new CellRangeAddress(1, 1, i - mergedRowj, i);
                    sheet.addMergedRegion(region);
                    EsdcExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                if ("".equals(secHeader) && mergedRow != 0) {
                    region = new CellRangeAddress(1, 2, i, i);
                    sheet.addMergedRegion(region);
                    EsdcExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                columCell.setCellStyle(dataStyle);
                columCell.setCellValue(I18nUtil.i18nCode((String)columValue, (Object[])new Object[0]));
            }
            String cellValue = "";
            CreationHelper creationHelper = workbook.getCreationHelper();
            for (int i = 0; i < list.size(); ++i) {
                Row dataRows = sheet.createRow(i + isMergedRegion);
                for (int j = 0; j < fieldList.size(); ++j) {
                    Field field;
                    Cell dataCell = dataRows.createCell(j);
                    dataCell.setCellStyle(dataStyle);
                    if (!extraDataMap.containsKey(fieldList.get(j))) {
                        field = cls.getDeclaredField((String)fieldList.get(j));
                        field.setAccessible(true);
                        Object cellObject = field.get(list.get(i));
                        if (EsdcExcelUtil.checkImg(field.getName()) && cellObject != null) {
                            Object bufferedImage = null;
                            Object byteArrayOut = null;
                            try {
                                dataRows.setHeight((short)2048);
                                Object anchor = null;
                                anchor = XLS.equals(reportType) ? new HSSFClientAnchor(0, 2, 2, 255, (short)j, i + isMergedRegion, (short)(j + 1), i + isMergedRegion) : new XSSFClientAnchor(0, 2, 2, 255, (int)((short)j), i + isMergedRegion, (int)((short)(j + 1)), i + isMergedRegion);
                                anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                                if (!StringUtils.isEmpty((Object)cellObject.toString())) {
                                    patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(EsdcExcelUtil.imgUrlToByte(capturePrivacyEnable, cellObject.toString()), 5));
                                }
                            }
                            catch (Exception e) {
                                loger.error("", (Throwable)e);
                            }
                        }
                        if (!StringUtils.isEmpty((Object)cellObject)) {
                            if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                                DateType dateType = field.getAnnotation(DateType.class);
                                String format = EsdcExcelUtil.getDateFormt(dateType);
                                cellValue = new SimpleDateFormat(format).format(cellObject);
                            } else if (map != null && map.containsKey(field.getName())) {
                                cellValue = String.valueOf(cellObject);
                                if (map.get(field.getName()).containsKey(cellValue)) {
                                    cellValue = I18nUtil.i18nCode((String)map.get(field.getName()).get(cellValue), (Object[])new Object[0]);
                                }
                            } else {
                                cellValue = String.valueOf(cellObject);
                                if (field.getAnnotation(GridColumn.class).i18n()) {
                                    cellValue = I18nUtil.i18nCode((String)cellValue, (Object[])new Object[0]);
                                }
                                if (!StringUtils.isEmpty((Object)field.getAnnotation(GridColumn.class).format())) {
                                    cellValue = I18nUtil.i18nCode((String)GridUtil.getDictionaryVal((String)field.getAnnotation(GridColumn.class).format(), (Object)cellValue), (Object[])new Object[0]);
                                }
                            }
                        } else {
                            cellValue = "";
                        }
                    } else {
                        field = cls.getDeclaredField(extraDataName);
                        field.setAccessible(true);
                        Map extraDataMaps = (Map)field.get(list.get(i));
                        cellValue = String.valueOf(extraDataMaps.get(fieldList.get(j)));
                    }
                    dataCell.setCellValue(cellValue);
                    if (!StringUtils.isEmpty((Object)cellValue) && !"null".equals(cellValue)) continue;
                    dataCell.setCellValue("");
                }
            }
            if (PDF.equals(reportType)) {
                EsdcExcelUtil.ExecltoPdf((Workbook)workbook, ops, capturePrivacyEnable);
            } else if (CSV.equals(reportType) || TXT.equals(reportType)) {
                EsdcExcelUtil.ExecltoCsv((Workbook)workbook, ops);
            } else {
                workbook.write((OutputStream)ops);
            }
        }
        catch (Exception e) {
            loger.error("", (Throwable)e);
        }
        ((OutputStream)ops).flush();
        ((OutputStream)ops).close();
        outputStream.close();
    }

    public static void addReportDetailData(Map<String, String> addReportDetailMap, Sheet sheet) {
        if (addReportDetailMap != null && addReportDetailMap.size() != 0) {
            Row headInfoRow = sheet.createRow(1);
            Cell headInfoCell = headInfoRow.createCell(0);
            headInfoCell.setCellValue(I18nUtil.i18nCode((String)"esdc_track_report_head_info", (Object[])new Object[0]));
            Row rowOne = sheet.createRow(2);
            Cell rowOneCellOne = rowOne.createCell(0);
            Cell rowOneCellTwo = rowOne.createCell(1);
            Row rowTwo = sheet.createRow(3);
            Cell rowTwoCellOne = rowTwo.createCell(0);
            Cell rowTwoCellTwo = rowTwo.createCell(1);
            Row rowThree = sheet.createRow(4);
            Cell rowThreeCellOne = rowThree.createCell(0);
            Cell rowThreeCellTwo = rowThree.createCell(1);
            Row rowFour = sheet.createRow(5);
            Cell rowFourCellOne = rowFour.createCell(0);
            Cell rowFourCellTwo = rowFour.createCell(1);
            Row targetRow = sheet.createRow(6);
            Cell targetCell = targetRow.createCell(0);
            targetCell.setCellValue(I18nUtil.i18nCode((String)"esdc_track_report_target_detail", (Object[])new Object[0]));
            Row rowFive = sheet.createRow(7);
            Cell rowFiveCellOne = rowFive.createCell(0);
            Row rowSix = sheet.createRow(8);
            Cell rowSixCellOne = rowSix.createCell(0);
            Cell rowSixCellTwo = rowSix.createCell(1);
            Cell rowSixCellThree = rowSix.createCell(2);
            Cell rowSixCellFour = rowSix.createCell(3);
            Row rowSeven = sheet.createRow(9);
            Cell rowSevenCellOne = rowSeven.createCell(0);
            Cell rowSevenCellTwo = rowSeven.createCell(1);
            Cell rowSevenCellThree = rowSeven.createCell(2);
            Cell rowSevenCellFour = rowSeven.createCell(3);
            Row rowEight = sheet.createRow(10);
            Cell rowEightCellOne = rowEight.createCell(0);
            Cell rowEightCellTwo = rowEight.createCell(1);
            Cell rowEightCellThree = rowEight.createCell(2);
            Cell rowEightCellFour = rowEight.createCell(3);
            Row travelRow = sheet.createRow(11);
            Cell travelCell = travelRow.createCell(0);
            travelCell.setCellValue(I18nUtil.i18nCode((String)"esdc_track_report_track_detail", (Object[])new Object[0]));
            Row rowNine = sheet.createRow(12);
            Cell rowNineCellOne = rowNine.createCell(0);
            Row recordRow = sheet.createRow(13);
            Cell recordCell = recordRow.createCell(0);
            recordCell.setCellValue(I18nUtil.i18nCode((String)"esdc_track_report_record_detail", (Object[])new Object[0]));
            sheet.setColumnWidth(1, 6000);
            for (Map.Entry<String, String> entry : addReportDetailMap.entrySet()) {
                if (I18nUtil.i18nCode((String)"esdc_track_report_report_name", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowOneCellOne.setCellValue(entry.getKey());
                    rowOneCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_personSearch_report_describe", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowTwoCellOne.setCellValue(entry.getKey());
                    rowTwoCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_personSearch_report_creater", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowThreeCellOne.setCellValue(entry.getKey());
                    rowThreeCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_time", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowFourCellOne.setCellValue(entry.getKey());
                    rowFourCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_target_detail", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowFiveCellOne.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_target_name", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSixCellOne.setCellValue(entry.getKey());
                    rowSixCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_pin", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSixCellThree.setCellValue(entry.getKey());
                    rowSixCellFour.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_target_gender", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSevenCellOne.setCellValue(entry.getKey());
                    rowSevenCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_deptName", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSevenCellThree.setCellValue(entry.getKey());
                    rowSevenCellFour.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_time_slot", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowEightCellOne.setCellValue(entry.getKey());
                    rowEightCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_personSearch_record_type", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowEightCellThree.setCellValue(entry.getKey());
                    rowEightCellFour.setCellValue(entry.getValue());
                    continue;
                }
                if (!I18nUtil.i18nCode((String)"esdc_track_report_track_detail", (Object[])new Object[0]).equals(entry.getKey())) continue;
                rowNineCellOne.setCellValue(entry.getValue());
            }
        }
    }

    public static void addLeavePostReportDetailData(Map<String, String> addReportDetailMap, Sheet sheet) {
        if (addReportDetailMap != null && addReportDetailMap.size() != 0) {
            Row headInfoRow = sheet.createRow(1);
            Cell headInfoCell = headInfoRow.createCell(0);
            headInfoCell.setCellValue(I18nUtil.i18nCode((String)"esdc_track_report_head_info", (Object[])new Object[0]));
            Row rowOne = sheet.createRow(2);
            Cell rowOneCellOne = rowOne.createCell(0);
            Cell rowOneCellTwo = rowOne.createCell(1);
            Row rowTwo = sheet.createRow(3);
            Cell rowTwoCellOne = rowTwo.createCell(0);
            Cell rowTwoCellTwo = rowTwo.createCell(1);
            Row rowThree = sheet.createRow(4);
            Cell rowThreeCellOne = rowThree.createCell(0);
            Cell rowThreeCellTwo = rowThree.createCell(1);
            Row rowFour = sheet.createRow(5);
            Cell rowFourCellOne = rowFour.createCell(0);
            Cell rowFourCellTwo = rowFour.createCell(1);
            Row targetRow = sheet.createRow(6);
            Cell targetCell = targetRow.createCell(0);
            targetCell.setCellValue(I18nUtil.i18nCode((String)"esdc_leave_post_situation", (Object[])new Object[0]));
            Row rowFive = sheet.createRow(7);
            Cell rowFiveCellOne = rowFive.createCell(0);
            Cell rowFiveCellTwo = rowFive.createCell(1);
            Cell rowFiveCellThree = rowFive.createCell(2);
            Cell rowFiveCellFour = rowFive.createCell(3);
            Row rowSix = sheet.createRow(8);
            Cell rowSixCellOne = rowSix.createCell(0);
            Cell rowSixCellTwo = rowSix.createCell(1);
            Cell rowSixCellThree = rowSix.createCell(2);
            Cell rowSixCellFour = rowSix.createCell(3);
            Row rowSeven = sheet.createRow(9);
            Cell rowSevenCellOne = rowSeven.createCell(0);
            Cell rowSevenCellTwo = rowSeven.createCell(1);
            Cell rowSevenCellThree = rowSeven.createCell(2);
            Cell rowSevenCellFour = rowSeven.createCell(3);
            Row travelRow = sheet.createRow(10);
            Cell travelCell = travelRow.createCell(0);
            travelCell.setCellValue(I18nUtil.i18nCode((String)"esdc_leave_post_check_result_pic", (Object[])new Object[0]));
            Row rowEight = sheet.createRow(11);
            Cell rowEightCellOne = rowEight.createCell(0);
            Row recordRow = sheet.createRow(12);
            Cell recordCell = recordRow.createCell(0);
            recordCell.setCellValue(I18nUtil.i18nCode((String)"esdc_track_report_record_detail", (Object[])new Object[0]));
            sheet.setColumnWidth(1, 6000);
            for (Map.Entry<String, String> entry : addReportDetailMap.entrySet()) {
                if (I18nUtil.i18nCode((String)"esdc_track_report_report_name", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowOneCellOne.setCellValue(entry.getKey());
                    rowOneCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_personSearch_report_describe", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowTwoCellOne.setCellValue(entry.getKey());
                    rowTwoCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_personSearch_report_creater", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowThreeCellOne.setCellValue(entry.getKey());
                    rowThreeCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_track_report_time", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowFourCellOne.setCellValue(entry.getKey());
                    rowFourCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_leave_post_point", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowFiveCellOne.setCellValue(entry.getKey());
                    rowFiveCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_leave_post_count", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowFiveCellThree.setCellValue(entry.getKey());
                    rowFiveCellFour.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_leave_post_sum_time", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSixCellOne.setCellValue(entry.getKey());
                    rowSixCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_leave_post_rate", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSixCellThree.setCellValue(entry.getKey());
                    rowSixCellFour.setCellValue(entry.getValue() + "%");
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_leave_post_recently", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSevenCellOne.setCellValue(entry.getKey());
                    rowSevenCellTwo.setCellValue(entry.getValue());
                    continue;
                }
                if (I18nUtil.i18nCode((String)"esdc_leave_post_longest", (Object[])new Object[0]).equals(entry.getKey())) {
                    rowSevenCellThree.setCellValue(entry.getKey());
                    rowSevenCellFour.setCellValue(entry.getValue());
                    continue;
                }
                if (!I18nUtil.i18nCode((String)"esdc_leave_post_check_result_pic", (Object[])new Object[0]).equals(entry.getKey())) continue;
                rowEightCellOne.setCellValue(entry.getValue());
            }
        }
    }

    public static String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return format;
    }

    public static void ExecltoPdf(Workbook workbook, OutputStream out, String capturePrivacyEnable) throws DocumentException, FileNotFoundException {
        try {
            Document iText_xls_2_pdf = new Document(PageSize.A3, 50.0f, 50.0f, 50.0f, 50.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)iText_xls_2_pdf, (OutputStream)out);
            Header header = new Header();
            writer.setPageEvent((PdfPageEvent)header);
            iText_xls_2_pdf.open();
            int sheetSize = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetSize; ++i) {
                Sheet my_worksheet = workbook.getSheetAt(i);
                for (Row row : my_worksheet) {
                    int num = row.getPhysicalNumberOfCells();
                    if (num == 0) continue;
                    PdfPTable my_table = new PdfPTable(num);
                    my_table.setWidthPercentage(100.0f);
                    int[] widths = new int[num];
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        Cell cell = (Cell)cellIterator.next();
                        switch (cell.getCellType()) {
                            case STRING: {
                                PdfPCell table_cell;
                                if (cell.getStringCellValue().endsWith(".jpg") || cell.getStringCellValue().endsWith(".png")) {
                                    Image imgs;
                                    String echartsImg;
                                    String path;
                                    File file;
                                    String stringCellValue = cell.getStringCellValue();
                                    if (cell.getStringCellValue().endsWith("esdc_door_open.png")) {
                                        stringCellValue = "upload/esdc/defaultImage/esdc_door_open.png";
                                    }
                                    if (!(file = new File(path = FileUtils.systemFilePath + File.separator + stringCellValue)).isAbsolute()) {
                                        path = ClassUtil.getRootPath() + "/" + path;
                                        file = new File(path);
                                    }
                                    if (!file.exists()) {
                                        EsdcExcelUtil.changeDefaultImg(file, cell);
                                    }
                                    if ("report".equals(echartsImg = cell.getStringCellValue().substring(12, 18)) || "defaul".equals(echartsImg) || EsdcExcelUtil.checkLeavePostPic(cell.getStringCellValue())) {
                                        imgs = Image.getInstance((String)file.toString());
                                        table_cell = new PdfPCell(imgs);
                                        imgs.scaleToFit(700.0f, 140.0f);
                                        table_cell.setHorizontalAlignment(1);
                                        table_cell.setVerticalAlignment(5);
                                        table_cell.setMinimumHeight(150.0f);
                                    } else {
                                        imgs = Image.getInstance((byte[])EsdcExcelUtil.imgUrlToByte(capturePrivacyEnable, stringCellValue));
                                        table_cell = new PdfPCell(imgs);
                                        table_cell.setMinimumHeight(70.0f);
                                        imgs.scaleToFit(60.0f, 60.0f);
                                        table_cell.setVerticalAlignment(5);
                                        table_cell.setHorizontalAlignment(1);
                                    }
                                } else {
                                    table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), ZKBaseFontUtil.getBodyFont((String)cell.getStringCellValue())));
                                    table_cell.setHorizontalAlignment(1);
                                    table_cell.setVerticalAlignment(5);
                                    table_cell.setMinimumHeight(20.0f);
                                }
                                BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                                com.itextpdf.text.Font FontChinese1 = new com.itextpdf.text.Font(bfChinese, 12.0f, 1);
                                if (I18nUtil.i18nCode((String)"esdc_track_report_target_detail", (Object[])new Object[0]).equals(cell.getStringCellValue()) || I18nUtil.i18nCode((String)"esdc_track_report_head_info", (Object[])new Object[0]).equals(cell.getStringCellValue()) || I18nUtil.i18nCode((String)"esdc_track_report_track_detail", (Object[])new Object[0]).equals(cell.getStringCellValue()) || I18nUtil.i18nCode((String)"esdc_track_report_record_detail", (Object[])new Object[0]).equals(cell.getStringCellValue()) || I18nUtil.i18nCode((String)"esdc_leave_post_check_result_pic", (Object[])new Object[0]).equals(cell.getStringCellValue()) || I18nUtil.i18nCode((String)"esdc_leave_post_situation", (Object[])new Object[0]).equals(cell.getStringCellValue())) {
                                    table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), FontChinese1));
                                    table_cell.setBackgroundColor(new BaseColor(217, 217, 217));
                                    table_cell.setHorizontalAlignment(0);
                                    table_cell.setVerticalAlignment(5);
                                }
                                if (1 == cell.getRowIndex()) {
                                    table_cell.setBackgroundColor(new BaseColor(217, 217, 217));
                                } else if (0 == cell.getRowIndex()) {
                                    table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), ZKBaseFontUtil.getTitleFont((String)cell.getStringCellValue())));
                                    table_cell.setBorder(0);
                                    table_cell.setPaddingBottom(20.0f);
                                    table_cell.setHorizontalAlignment(1);
                                }
                                widths[cell.getColumnIndex()] = my_worksheet.getColumnWidth(cell.getColumnIndex());
                                my_table.addCell(table_cell);
                                break;
                            }
                        }
                    }
                    my_table.setWidths(widths);
                    iText_xls_2_pdf.add((Element)my_table);
                }
            }
            iText_xls_2_pdf.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ExecltoCsv(Workbook workbook, OutputStream out) throws IOException {
        byte[] uft8bom = new byte[]{-17, -69, -65};
        out.write(uft8bom);
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        Sheet my_worksheet = workbook.getSheetAt(0);
        Iterator rowIterator = my_worksheet.iterator();
        try {
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                int num = row.getPhysicalNumberOfCells();
                if (num == 0) continue;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case STRING: {
                            bw.append("\"" + cell.getStringCellValue() + "\"");
                            bw.append(",");
                        }
                    }
                }
                bw.append(System.getProperty("line.separator"));
            }
            bw.flush();
            out.close();
            bw.close();
            osw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setBorderStyle(BorderStyle border, CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
    }

    private static boolean checkImg(String str) {
        return str.contains("facePic") || str.contains("captureImage");
    }

    private static void changeDefaultImg(File file, Cell cell) {
        if (cell.getStringCellValue().endsWith("esdc_door_open.png")) {
            String defaultImg = ClassUtil.getRootPath() + "/" + FileUtils.systemFilePath + File.separator + "upload/esdc/defaultImage/" + "esdc_open_door_img.jpg";
            file = new File(defaultImg);
        } else {
            String defaultImg = ClassUtil.getRootPath() + "/" + FileUtils.systemFilePath + File.separator + "upload/esdc/defaultImage/" + "esdc_default_img.jpg";
            file = new File(defaultImg);
        }
    }

    private static boolean checkLeavePostPic(String url) {
        int index = url.indexOf("leavepostreport");
        return index != -1;
    }

    private static byte[] imgUrlToByte(String enable, String imgUrl) {
        byte[] decode = null;
        if ("true".equals(enable)) {
            if (!Objects.equals(imgUrl, "")) {
                String fileBase64Str = FileEncryptUtil.getDecryptFileBase64((String)imgUrl);
                String imgStr = ImgEncodeUtil.base64BoxBlurFilter((String)fileBase64Str);
                decode = Base64.getDecoder().decode(imgStr);
            }
        } else {
            decode = Base64.getDecoder().decode(FileEncryptUtil.getDecryptFileBase64((String)imgUrl));
        }
        return decode;
    }

    private static class Header
    extends PdfPageEventHelper {
        private Header() {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            ColumnText.showTextAligned((PdfContentByte)pdfWriter.getDirectContent(), (int)2, (Phrase)new Phrase("Page:" + pdfWriter.getCurrentPageNumber()), (float)450.0f, (float)30.0f, (float)0.0f);
        }
    }
}

