/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.enums.EsdcEventEnum;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcWorkOrderRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTransactionService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcWorkOrderService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTransactionItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcWorkOrderItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcWorkOrderController
extends BaseController
implements EsdcWorkOrderRemote {
    @Autowired
    private EsdcWorkOrderService esdcWorkOrderService;
    @Autowired
    private EsdcTransactionService esdcTransactionService;

    @RequiresPermissions(value={"esdc:workorder"})
    public ModelAndView index() {
        return new ModelAndView("esdc/workorder/esdcWorkOrder");
    }

    @RequiresPermissions(value={"esdc:workorder:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcWorkOrderService.getItemById(id));
        }
        return new ModelAndView("esdc/workorder/editEsdcWorkOrder");
    }

    public ZKResultMsg save(EsdcWorkOrderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        item.setSessionId(sessionId);
        this.esdcWorkOrderService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:workorder:refresh"})
    public DxGrid list(EsdcWorkOrderItem codition) {
        Pager pager = this.esdcWorkOrderService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"esdc:workorder:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcWorkOrderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView dealWorkOrder(String from, String eventId) {
        if (StringUtils.isNotBlank((CharSequence)eventId)) {
            this.request.setAttribute("from", (Object)from);
            this.request.setAttribute("item", (Object)this.esdcWorkOrderService.getItemDetailByEventId(eventId));
        }
        return new ModelAndView("esdc/workorder/dealEsdcWorkOrder");
    }

    @RequiresPermissions(value={"esdc:workorder:getWorkOrderId"})
    public ModelAndView getWorkOrderId(String ids) {
        this.request.setAttribute("WorkOrderId", (Object)ids);
        return new ModelAndView("esdc/workorder/esdcModifyStatus");
    }

    @RequiresPermissions(value={"esdc:workorder:getWorkOrderId"})
    public ZKResultMsg modifyWorkOrderStatus(String workOrderId, String statusId, String describe) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        this.esdcWorkOrderService.modifyStatus(workOrderId, statusId, sessionId, describe);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView eventDetail(String id) {
        EsdcWorkOrderItem esdcWorkOrderItem = this.esdcWorkOrderService.getItemById(id);
        EsdcTransactionItem esdcTransactionItem = this.esdcTransactionService.getItemById(esdcWorkOrderItem.getEventCode());
        this.request.setAttribute("item", (Object)esdcTransactionItem);
        EsdcWorkOrderItem workOrderItem = this.esdcWorkOrderService.getItemByEventId(esdcWorkOrderItem.getId());
        this.request.setAttribute("status", (Object)workOrderItem.getStatus());
        String parentEventType = esdcTransactionItem.getParentEventType();
        if (StringUtils.isBlank((CharSequence)parentEventType)) {
            parentEventType = esdcTransactionItem.getEventType();
        }
        if (parentEventType.equals(EsdcEventEnum.KeyPerson.getType())) {
            return new ModelAndView("esdc/keyperson/esdcKeyPersonDetail");
        }
        if (parentEventType.equals(EsdcEventEnum.PassBack.getType())) {
            return new ModelAndView("esdc/passback/esdcPassbackDetail");
        }
        if (parentEventType.equals(EsdcEventEnum.LeavePost.getType())) {
            return new ModelAndView("esdc/leavepost/esdcLeavePostDetail");
        }
        if (parentEventType.equals(EsdcEventEnum.EntranceFence.getType())) {
            return new ModelAndView("esdc/entrancefence/esdcEntranceFenceDetail");
        }
        return null;
    }
}

