/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.esdc.constant.EsdcConstants;
import com.zkteco.zkbiosecurity.esdc.controller.EsdcExportController;
import com.zkteco.zkbiosecurity.esdc.enums.EsdcEventEnum;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcTransactionRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAccTransactionService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcBindingDeviceService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcParamsService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTransactionConfigService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTransactionService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcWorkOrderService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcAccTransactionItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcBindingDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcChannelItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcParamsItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTransactionConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTransactionItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcWorkOrderItem;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonnalListItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcTransactionController
extends EsdcExportController
implements EsdcTransactionRemote {
    @Autowired
    private EsdcTransactionService esdcTransactionService;
    @Autowired
    private EsdcWorkOrderService esdcWorkOrderService;
    @Autowired
    private EsdcTransactionConfigService esdcTransactionConfigService;
    @Autowired
    private EsdcAccTransactionService esdcAccTransactionService;
    @Autowired
    private EsdcBindingDeviceService esdcBindingDeviceService;
    @Autowired(required=false)
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private EsdcParamsService esdcParamsService;

    @RequiresPermissions(value={"esdc:transaction"})
    public ModelAndView index() {
        this.request.setAttribute("transactionConfigId", (Object)this.request.getParameter("transactionConfigId"));
        return new ModelAndView("esdc/transaction/esdcTransaction");
    }

    @RequiresPermissions(value={"esdc:transaction:focus"})
    public ModelAndView focus() {
        this.request.setAttribute("focus", (Object)true);
        return new ModelAndView("esdc/transaction/esdcFocusTransaction");
    }

    @RequiresPermissions(value={"esdc:transaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcTransactionService.getItemById(id));
        }
        return new ModelAndView("esdc/keyperson/esdcKeyPersonDetail");
    }

    @RequiresPermissions(value={"esdc:transaction:edit"})
    public ZKResultMsg save(EsdcTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.esdcTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:transaction:refresh"})
    public DxGrid list(EsdcTransactionItem codition) {
        if (StringUtils.isNotBlank((CharSequence)this.request.getParameter("transactionConfigIdtmp"))) {
            codition.setTransactionConfigId(this.request.getParameter("transactionConfigIdtmp"));
        }
        if (StringUtils.isNotBlank((CharSequence)codition.getTransactionConfigId())) {
            Object[] configIds = codition.getTransactionConfigId().split(",");
            boolean kp = codition.getTransactionConfigId().endsWith("_kp");
            boolean efDeal = codition.getTransactionConfigId().endsWith("_e1");
            boolean efNoDeal = codition.getTransactionConfigId().endsWith("_e2");
            if (kp) {
                if (configIds.length > 1) {
                    codition.setTransactionConfigIds(codition.getTransactionConfigId().substring(0, codition.getTransactionConfigId().length() - 3));
                    codition.setTransactionConfigId("");
                } else {
                    codition.setTransactionConfigId(codition.getTransactionConfigId().substring(0, codition.getTransactionConfigId().length() - 3));
                }
                codition.setStartTime(DateUtil.getDayBeginTime((Date)new Date()));
                codition.setEndTime(DateUtil.getDayEndTime((Date)new Date()));
            } else if (efDeal) {
                codition.setTransactionConfigId(codition.getTransactionConfigId().substring(0, codition.getTransactionConfigId().length() - 4));
                codition.setDealType("1");
                codition.setStartTime(DateUtil.getDayBeginTime((Date)new Date()));
                codition.setEndTime(DateUtil.getDayEndTime((Date)new Date()));
            } else if (efNoDeal) {
                codition.setTransactionConfigId(codition.getTransactionConfigId().substring(0, codition.getTransactionConfigId().length() - 4));
                codition.setStartTime(DateUtil.getDayBeginTime((Date)new Date()));
                codition.setEndTime(DateUtil.getDayEndTime((Date)new Date()));
            } else if (configIds.length > 1) {
                codition.setTransactionConfigIds(StringUtils.join((Object[])configIds, (String)","));
                codition.setTransactionConfigId("");
            }
        }
        long limit = this.getLimitCount();
        Pager pager = this.esdcTransactionService.pagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"esdc:transaction:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView viewDetail(String id) {
        String from = "";
        EsdcTransactionItem esdcTransactionItem = this.esdcTransactionService.getItemById(id);
        esdcTransactionItem.setFacePicPath(esdcTransactionItem.getFacePic());
        String captureImg = StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getCaptureImage()) ? FileEncryptUtil.getDecryptFileBase64((String)esdcTransactionItem.getCaptureImage()) : "";
        String facePic = StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getFacePic()) ? FileEncryptUtil.getDecryptFileBase64((String)esdcTransactionItem.getFacePic()) : "";
        EsdcParamsItem esdcParams = this.esdcParamsService.getEsdcParams();
        if ("true".equals(esdcParams.getCapturePrivacyEnable())) {
            captureImg = StringUtils.isNotBlank((CharSequence)captureImg) ? ImgEncodeUtil.base64BoxBlurFilter((String)captureImg) : "";
            facePic = StringUtils.isNotBlank((CharSequence)facePic) ? ImgEncodeUtil.base64BoxBlurFilter((String)facePic) : "";
        }
        esdcTransactionItem.setCaptureImage("data:image/jpeg;base64," + captureImg);
        esdcTransactionItem.setFacePic("data:image/jpeg;base64," + facePic);
        esdcTransactionItem.setLibFacePic(StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getLibFacePic()) ? esdcTransactionItem.getLibFacePic() : "");
        EsdcChannelItem esdcDeviceItem = this.esdcTransactionService.getItemsByChannelId(esdcTransactionItem.getDeviceId());
        EsdcWorkOrderItem workOrderItem = this.esdcWorkOrderService.getItemByEventId(id);
        if (esdcTransactionItem.getFaceMatchRate() != null) {
            esdcTransactionItem.setFaceMatchRate(Integer.valueOf(esdcTransactionItem.getFaceMatchRate() / 100));
        }
        EsdcTransactionConfigItem itemById = this.esdcTransactionConfigService.getItemById(esdcTransactionItem.getTransactionConfigId());
        from = StringUtils.isNotEmpty((CharSequence)esdcTransactionItem.getFacePic()) ? "faceScene" : "eventScene";
        EsdcWorkOrderItem esdcWorkOrderItem = this.esdcWorkOrderService.getItemByCode(esdcTransactionItem.getEventCode());
        this.request.setAttribute("item", (Object)esdcTransactionItem);
        this.request.setAttribute("deviceItem", (Object)esdcDeviceItem);
        this.request.setAttribute("focus", (Object)(esdcTransactionItem.getFocus() == null ? false : esdcTransactionItem.getFocus()));
        this.request.setAttribute("esdcWorkOrderItem", (Object)esdcWorkOrderItem);
        this.request.setAttribute("status", (Object)workOrderItem.getStatus());
        this.request.setAttribute("from", (Object)from);
        this.request.setAttribute("actionShow", (Object)true);
        String eventType = "";
        eventType = Objects.nonNull(itemById) ? itemById.getEventType() : esdcTransactionItem.getTransactionConfigId();
        if (EsdcConstants.KEY_PERSON.contains(eventType)) {
            return new ModelAndView("esdc/keyperson/esdcKeyPersonDetail");
        }
        if (EsdcConstants.PASS_BACK.contains(eventType)) {
            return new ModelAndView("esdc/passback/esdcPassbackDetail");
        }
        if (EsdcEventEnum.LeavePostEvent.getType().equals(eventType)) {
            return new ModelAndView("esdc/leavepost/esdcLeavePostDetail");
        }
        return new ModelAndView("esdc/entrancefence/esdcEntranceFenceDetail");
    }

    public ModelAndView viewDetailFromAll(String id, String idStr) {
        String facePic;
        EsdcTransactionItem esdcTransactionItem = this.esdcTransactionService.getItemById(id);
        EsdcTransactionConfigItem itemById = this.esdcTransactionConfigService.getItemById(esdcTransactionItem.getTransactionConfigId());
        EsdcChannelItem esdcDeviceItem = this.esdcTransactionService.getItemsByChannelId(esdcTransactionItem.getDeviceId());
        if (esdcTransactionItem.getFaceMatchRate() != null) {
            esdcTransactionItem.setFaceMatchRate(Integer.valueOf(esdcTransactionItem.getFaceMatchRate() / 100));
        }
        EsdcParamsItem esdcParams = this.esdcParamsService.getEsdcParams();
        String captureImage = StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getCaptureImage()) ? FileEncryptUtil.getDecryptFileBase64((String)esdcTransactionItem.getCaptureImage()) : "";
        String string = facePic = StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getFacePic()) ? FileEncryptUtil.getDecryptFileBase64((String)esdcTransactionItem.getFacePic()) : "";
        if ("true".equals(esdcParams.getCapturePrivacyEnable())) {
            captureImage = ImgEncodeUtil.base64BoxBlurFilter((String)captureImage);
            facePic = ImgEncodeUtil.base64BoxBlurFilter((String)facePic);
        }
        esdcTransactionItem.setCaptureImage(StringUtils.isNotBlank((CharSequence)captureImage) ? "data:image/jpeg;base64," + captureImage : "");
        esdcTransactionItem.setFacePic(StringUtils.isNotBlank((CharSequence)facePic) ? "data:image/jpeg;base64," + facePic : "");
        esdcTransactionItem.setLibFacePic(StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getLibFacePic()) ? esdcTransactionItem.getLibFacePic() : "");
        EsdcWorkOrderItem esdcWorkOrderItem = this.esdcWorkOrderService.getItemByCode(esdcTransactionItem.getEventCode());
        this.request.setAttribute("item", (Object)esdcTransactionItem);
        this.request.setAttribute("deviceItem", (Object)esdcDeviceItem);
        this.request.setAttribute("focus", (Object)(esdcTransactionItem.getFocus() == null ? false : esdcTransactionItem.getFocus()));
        this.request.setAttribute("esdcWorkOrderItem", (Object)esdcWorkOrderItem);
        this.request.setAttribute("actionShow", (Object)false);
        if ("focus".equals(idStr)) {
            this.request.setAttribute("idStr", (Object)"");
            this.request.setAttribute("from", (Object)"focusPage");
        } else {
            this.request.setAttribute("idStr", (Object)idStr);
            this.request.setAttribute("from", (Object)"all");
        }
        String eventType = "";
        eventType = Objects.nonNull(itemById) ? itemById.getEventType() : esdcTransactionItem.getTransactionConfigId();
        if (EsdcConstants.KEY_PERSON.contains(eventType)) {
            return new ModelAndView("esdc/keyperson/esdcKeyPersonDetail");
        }
        if (EsdcConstants.PASS_BACK.contains(eventType)) {
            return new ModelAndView("esdc/passback/esdcPassbackDetail");
        }
        if (EsdcEventEnum.LeavePostEvent.getType().equals(eventType)) {
            return new ModelAndView("esdc/leavepost/esdcLeavePostDetail");
        }
        return new ModelAndView("esdc/entrancefence/esdcEntranceFenceDetail");
    }

    public ModelAndView viewDetailByCode(String eventCode) {
        EsdcWorkOrderItem esdcWorkOrderItem = this.esdcWorkOrderService.getItemByCode(eventCode);
        return this.viewDetail(esdcWorkOrderItem.getEventId());
    }

    @RequiresPermissions(value={"esdc:transaction:entranceFenceEventDetail"})
    public ModelAndView entranceFenceEventDetail(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcTransactionService.getItemById(id));
        }
        return new ModelAndView("esdc/entrancefence/esdcEntranceFenceDetail");
    }

    @RequiresPermissions(value={"esdc:transaction:addFocus"})
    public ZKResultMsg addFocus(String id) {
        EsdcTransactionItem item;
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.nonNull(item = this.esdcTransactionService.getItemByIdNoBuild(id))) {
            item.setFocus(Boolean.valueOf(true));
            this.esdcTransactionService.saveItem(item);
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
    }

    @RequiresPermissions(value={"esdc:transaction:removeFocus"})
    public ZKResultMsg removeFocus(String id) {
        EsdcTransactionItem item;
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.nonNull(item = this.esdcTransactionService.getItemByIdNoBuild(id))) {
            item.setFocus(Boolean.valueOf(false));
            this.esdcTransactionService.saveItem(item);
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
    }

    @RequiresPermissions(value={"esdc:transaction:focusList"})
    public DxGrid focusList(EsdcTransactionItem condition) {
        condition.setFocus(Boolean.valueOf(true));
        Pager pager = this.esdcTransactionService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getTransactionList(EsdcTransactionItem condition) {
        Pager pager = this.esdcTransactionService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        List data = pager.getData();
        return new ZKResultMsg((Object)data);
    }

    public ZKResultMsg getKeyPersonDashboardData(String dataType, String timeType) {
        if ("pie".equals(dataType)) {
            return I18nUtil.i18nMsg((ZKResultMsg)this.esdcTransactionService.getEsdcEventPiesData(timeType));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.esdcTransactionService.getEsdcEventTrendsData(timeType));
    }

    public ZKResultMsg getEventGroupDashboardData(String timeType) {
        ZKResultMsg zsg = new ZKResultMsg();
        Map eventGroupDashboardData = this.esdcTransactionService.getEventGroupDashboardData(timeType);
        zsg.setData((Object)eventGroupDashboardData);
        return I18nUtil.i18nMsg((ZKResultMsg)zsg);
    }

    public ZKResultMsg getEventLineMapsData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.esdcTransactionService.getEventLineMapsData(timeType));
    }

    public ZKResultMsg getCaptureImgById(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ZKResultMsg zsg = new ZKResultMsg();
            String capturePrivacyEnable = this.esdcParamsService.getEsdcParams().getCapturePrivacyEnable();
            EsdcTransactionItem item = this.esdcTransactionService.getItemById(id);
            if ("true".equals(capturePrivacyEnable)) {
                item.setCaptureImage(StringUtils.isNotBlank((CharSequence)item.getCaptureImage()) ? "data:image/jpeg;base64," + ImgEncodeUtil.base64BoxBlurFilter((String)FileEncryptUtil.getDecryptFileBase64((String)item.getCaptureImage())) : "");
                item.setLibFacePic(StringUtils.isNotBlank((CharSequence)item.getLibFacePic()) ? "data:image/jpeg;base64," + ImgEncodeUtil.base64BoxBlurFilter((String)FileEncryptUtil.getDecryptFileBase64((String)item.getLibFacePic())) : "");
                item.setFacePic(StringUtils.isNotBlank((CharSequence)item.getFacePic()) ? "data:image/jpeg;base64," + ImgEncodeUtil.base64BoxBlurFilter((String)FileEncryptUtil.getDecryptFileBase64((String)item.getFacePic())) : "");
            } else {
                item.setCaptureImage(StringUtils.isNotBlank((CharSequence)item.getCaptureImage()) ? "data:image/jpeg;base64," + FileEncryptUtil.getDecryptFileBase64((String)item.getCaptureImage()) : "");
                item.setLibFacePic(StringUtils.isNotBlank((CharSequence)item.getLibFacePic()) ? "data:image/jpeg;base64," + FileEncryptUtil.getDecryptFileBase64((String)item.getLibFacePic()) : "");
                item.setFacePic(StringUtils.isNotBlank((CharSequence)item.getFacePic()) ? "data:image/jpeg;base64," + FileEncryptUtil.getDecryptFileBase64((String)item.getFacePic()) : "");
            }
            zsg.setData((Object)item);
            return I18nUtil.i18nMsg((ZKResultMsg)zsg);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
    }

    public EsdcWorkOrderItem getWorkOrderItemsById(String id) {
        EsdcTransactionItem esdcTransactionItem = this.esdcTransactionService.getItemById(id);
        EsdcWorkOrderItem esdcWorkOrderItem = this.esdcWorkOrderService.getItemByCode(esdcTransactionItem.getEventCode());
        return esdcWorkOrderItem;
    }

    public ZKResultMsg getEntranceFenceStatistics() {
        String sessionId = this.request.getSession().getId();
        return I18nUtil.i18nMsg((ZKResultMsg)this.esdcTransactionService.getEntranceFenceDate(sessionId));
    }

    public ZKResultMsg getEntranceFenceTopData(String timeType) {
        String sessionId = this.request.getSession().getId();
        EsdcTransactionConfigItem configItem = this.esdcTransactionConfigService.getItemByType(EsdcEventEnum.EntranceFenceEvent.getType());
        ZKResultMsg zkResultMsg = this.esdcTransactionService.getEntranceFenceTopData(sessionId, timeType, configItem);
        return zkResultMsg;
    }

    public ZKResultMsg getLeavePostData(String devId) {
        String sessionId = this.request.getSession().getId();
        Map map = this.esdcTransactionService.getLeavePostData(sessionId, devId);
        return new ZKResultMsg((Object)map);
    }

    public ZKResultMsg getLeavePostDeviceMonitor() {
        String sessionId = this.request.getSession().getId();
        List result = this.esdcTransactionService.getLeavePostDeviceMonitor(sessionId);
        return new ZKResultMsg((Object)result);
    }

    public ModelAndView getLeavePostDetaill(String deviceId, String deviceSn, String chartBase64Pic) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            Map result = this.esdcTransactionService.getLeavePostDetail(deviceId);
            this.request.setAttribute("result", (Object)result);
            this.request.setAttribute("deviceId", (Object)deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)chartBase64Pic)) {
            this.request.setAttribute("chartBase64Pic", (Object)chartBase64Pic);
        }
        this.request.setAttribute("videoPlayParam", (Object)deviceSn);
        return new ModelAndView("esdc/leavepost/esdcLeavePostDeviceDetail");
    }

    public ZKResultMsg getCurrentDayData() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        EsdcTransactionConfigItem configItem = this.esdcTransactionConfigService.getItemByType(EsdcEventEnum.KeyPerson.getType());
        Map map = this.esdcTransactionService.getCountByKeyPersonType(sessionId, configItem);
        zkResultMsg.setData((Object)map);
        return zkResultMsg;
    }

    public ZKResultMsg getAccEventData() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        List esdcLinkageAccList = this.esdcBindingDeviceService.getByCondition(new EsdcBindingDeviceItem());
        ArrayList<EsdcAccTransactionItem> list = new ArrayList<EsdcAccTransactionItem>();
        EsdcAccTransactionItem esdcAccTransactionItem = null;
        for (EsdcBindingDeviceItem esdcBindingDeviceItem : esdcLinkageAccList) {
            esdcAccTransactionItem = this.esdcAccTransactionService.getLastTransactionByDoorId(esdcBindingDeviceItem.getDeviceId());
            if (!Objects.nonNull(esdcAccTransactionItem)) continue;
            list.add(esdcAccTransactionItem);
        }
        zkResultMsg.setData(list);
        return zkResultMsg;
    }

    public EsdcTransactionItem getTransactionItemById(String id) {
        return this.esdcTransactionService.getItemById(id);
    }

    @RequiresPermissions(value={"esdc:transaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EsdcTransactionItem edcTransactionItem = new EsdcTransactionItem();
        this.setConditionValue((BaseItem)edcTransactionItem);
        List itemList = this.esdcTransactionService.getItemData(EsdcTransactionItem.class, request.getSession().getId(), (BaseItem)edcTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EsdcTransactionItem.class);
    }

    public List<SelectItem> getEventTypes() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List configItems = this.esdcTransactionConfigService.getByCondition(new EsdcTransactionConfigItem());
        if (configItems.size() > 0) {
            for (EsdcTransactionConfigItem configId : configItems) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue(configId.getId());
                selectItem.setText((Object)configId.getEventName());
                selectItems.add(selectItem);
            }
        }
        return selectItems;
    }

    public TreeItem eventTypeTree(int code) {
        return this.esdcTransactionService.eventTypeTree(code);
    }

    public List<SelectItem> getEventLevel() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List configItems = this.esdcTransactionConfigService.getByCondition(new EsdcTransactionConfigItem());
        if (configItems.size() > 0) {
            List result = configItems.stream().collect(Collectors.groupingBy(EsdcTransactionConfigItem::getEventLevel)).entrySet().stream().map(items -> {
                ArrayList levelIds = new ArrayList();
                ((List)items.getValue()).stream().forEach(item -> levelIds.add(item.getId()));
                String ids = String.join((CharSequence)";", levelIds);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("level", String.valueOf(((EsdcTransactionConfigItem)((List)items.getValue()).get(0)).getEventLevel()));
                map.put("ids", ids);
                return map;
            }).collect(Collectors.toList());
            for (Map map : result) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue((String)map.get("ids"));
                selectItem.setText((Object)I18nUtil.i18nCode((String)("esdc_transaction_level_" + (String)map.get("level")), (Object[])new Object[0]));
                selectItems.add(selectItem);
            }
        }
        return selectItems;
    }

    public ZKResultMsg getMoreKeyPersonRecord(EsdcTransactionItem item) {
        ZKResultMsg zs = new ZKResultMsg();
        JSONObject ret = new JSONObject();
        String sessionId = this.request.getSession().getId();
        Map filterAreaMap = this.esdcParamsService.getFilterAreaMap(sessionId);
        EsdcTransactionItem condition = new EsdcTransactionItem();
        EsdcTransactionConfigItem configItem = this.esdcTransactionConfigService.getItemByType(item.getEventType());
        condition.setTransactionConfigIds(configItem.getId());
        condition.setMoreRecordEndTime(item.getMoreRecordEndTime());
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)filterAreaMap.get("areaIds")))) {
            condition.setAreaIdIn((String)filterAreaMap.get("areaIds"));
        }
        boolean capturePrivacyFlag = false;
        EsdcParamsItem esdcParams = this.esdcParamsService.getEsdcParams();
        if ("true".equals(esdcParams.getCapturePrivacyEnable())) {
            capturePrivacyFlag = true;
        }
        List transactionList = this.esdcTransactionService.getTransactionListByPage(condition, item.getPageNo(), item.getPageSize());
        JSONArray rows = new JSONArray();
        for (EsdcTransactionItem esdcTransactionItem : transactionList) {
            EsdcChannelItem esdcDeviceItem = this.esdcTransactionService.getItemsByChannelId(esdcTransactionItem.getDeviceId());
            if (esdcDeviceItem == null) continue;
            JSONObject row = new JSONObject();
            JSONArray data = new JSONArray();
            data.add((Object)esdcTransactionItem.getEventCode());
            data.add((Object)esdcTransactionItem.getEventType());
            data.add((Object)DateUtil.dateToString((Date)esdcTransactionItem.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            data.add((Object)esdcTransactionItem.getEventName());
            data.add((Object)I18nUtil.i18nCode((String)("esdc_transaction_level_" + esdcTransactionItem.getEventLevel()), (Object[])new Object[0]));
            data.add((Object)esdcDeviceItem.getAuthAreaName());
            if (esdcDeviceItem != null) {
                data.add((Object)esdcDeviceItem.getDevAlias());
            } else {
                data.add((Object)"Device not exist");
            }
            data.add((Object)esdcTransactionItem.getName());
            data.add((Object)(esdcTransactionItem.getFaceMatchRate() / 100 + "%"));
            String facePic = "";
            if (StringUtils.isNotBlank((CharSequence)esdcTransactionItem.getFacePic())) {
                facePic = FileEncryptUtil.getDecryptFileBase64((String)esdcTransactionItem.getFacePic());
                if (capturePrivacyFlag) {
                    facePic = ImgEncodeUtil.base64BoxBlurFilter((String)facePic);
                }
            }
            data.add((Object)("data:image/jpeg;base64," + facePic));
            if (esdcTransactionItem.getLibFacePic() != null) {
                data.add((Object)esdcTransactionItem.getLibFacePic());
            } else {
                data.add((Object)"/images/esdc_user.png");
            }
            data.add((Object)esdcTransactionItem.getDeviceId());
            data.add((Object)esdcTransactionItem.getId());
            data.add((Object)esdcTransactionItem.getFacePic());
            if (esdcTransactionItem.getLibFacePic() != null) {
                data.add((Object)esdcTransactionItem.getLibFacePic());
            } else {
                data.add((Object)"/images/esdc_user.png");
            }
            rows.add((Object)data);
        }
        ret.put("rows", (Object)rows);
        zs.setData((Object)ret);
        return zs;
    }

    public ZKResultMsg getPassbackInitEvent() {
        ZKResultMsg mgs = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        List esdcEventShowItems = this.esdcTransactionService.getPassbackEvent(sessionId);
        mgs.setData((Object)esdcEventShowItems);
        return mgs;
    }

    public ZKResultMsg getEntranceFenceInitEvent() {
        String sessionId = this.request.getSession().getId();
        ZKResultMsg mgs = new ZKResultMsg();
        List esdcEventShowItems = this.esdcTransactionService.getEntranceFenceEvent(sessionId);
        mgs.setData((Object)esdcEventShowItems);
        return mgs;
    }

    public ZKResultMsg getKeyPersonInitEvent() {
        ZKResultMsg msg = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        List esdcEventShowItems = this.esdcTransactionService.getKeyPersonEvent(sessionId);
        msg.setData((Object)esdcEventShowItems);
        return msg;
    }

    public List<SelectItem> getLibName() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List personnalListItems = this.persPersonnalListService.getByCondition(new PersPersonnalListItem());
        if (!CollectionUtils.isEmpty((Collection)personnalListItems)) {
            for (PersPersonnalListItem item : personnalListItems) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue(item.getId());
                selectItem.setText((Object)item.getName());
                selectItems.add(selectItem);
            }
        }
        return selectItems;
    }
}

