/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcTransactionConfigRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTransactionConfigService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTransactionConfigItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcTransactionConfigController
extends BaseController
implements EsdcTransactionConfigRemote {
    @Autowired
    private EsdcTransactionConfigService esdcTransactionConfigService;

    @RequiresPermissions(value={"esdc:transactionconfig"})
    public ModelAndView index() {
        return new ModelAndView("esdc/transactionconfig/esdcTransactionConfig");
    }

    @RequiresPermissions(value={"esdc:transactionconfig:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcTransactionConfigService.getItemById(id));
        }
        return new ModelAndView("esdc/transactionconfig/editEsdcTransactionConfig");
    }

    @RequiresPermissions(value={"esdc:transactionconfig:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcTransactionConfigService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getTransactionConfigList(int eventName) {
        EsdcTransactionConfigItem condition = new EsdcTransactionConfigItem();
        List esdcLabelItemList = this.esdcTransactionConfigService.getByCondition(condition);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        for (EsdcTransactionConfigItem esdcTransactionConfigItem : esdcLabelItemList) {
            selectItem = new SelectItem();
            selectItem.setValue(esdcTransactionConfigItem.getEventType());
            selectItem.setText((Object)esdcTransactionConfigItem.getEventName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getTransactionById(String id) {
        EsdcTransactionConfigItem esdcTransactionConfigItem = this.esdcTransactionConfigService.getItemById(id);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = new SelectItem();
        selectItem.setValue(esdcTransactionConfigItem.getEventType());
        selectItem.setText((Object)esdcTransactionConfigItem.getEventName());
        selectItems.add(selectItem);
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getTransaction() {
        EsdcTransactionConfigItem condition = new EsdcTransactionConfigItem();
        List esdcLabelItemList = this.esdcTransactionConfigService.getByCondition(condition);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = new SelectItem();
        selectItem.setText((Object)"\u5168\u90e8");
        selectItem.setValue("");
        selectItems.add(selectItem);
        for (EsdcTransactionConfigItem esdcTransactionConfigItem : esdcLabelItemList) {
            selectItem = new SelectItem();
            selectItem.setValue(esdcTransactionConfigItem.getEventType());
            selectItem.setText((Object)esdcTransactionConfigItem.getEventName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }
}

