/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.controller.EsdcExportController;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcTrackReportRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcParamsService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTrackReportService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSearchResultEventItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTrackReportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcTrackReportController
extends EsdcExportController
implements EsdcTrackReportRemote {
    @Autowired
    private EsdcTrackReportService esdcTrackReportService;
    @Autowired
    private EsdcParamsService esdcParamsService;

    @RequiresPermissions(value={"esdc:trackreport"})
    public ModelAndView index() {
        return new ModelAndView("esdc/trackreport/esdcTrackReport");
    }

    @RequiresPermissions(value={"esdc:trackreport:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcTrackReportService.getItemById(id));
        }
        return new ModelAndView("esdc/trackreport/editEsdcTrackReport");
    }

    @RequiresPermissions(value={"esdc:trackreport:edit"})
    public ZKResultMsg save(EsdcTrackReportItem item) {
        ZKResultMsg res = new ZKResultMsg();
        EsdcTrackReportItem esdcTrackReportItem = this.esdcTrackReportService.saveItem(item);
        res.setData((Object)esdcTrackReportItem.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:trackreport:refresh"})
    public DxGrid list(EsdcTrackReportItem codition) {
        Pager pager = this.esdcTrackReportService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid eventListByReportId(EsdcSearchResultEventItem condition) {
        Pager pager = this.esdcTrackReportService.eventListByReportId(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg searchList(EsdcTrackReportItem codition) {
        ZKResultMsg zs = new ZKResultMsg();
        Pager pager = this.esdcTrackReportService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List data = pager.getData();
        zs.setData((Object)data);
        return zs;
    }

    @RequiresPermissions(value={"esdc:trackreport:del"})
    public ZKResultMsg delete(String ids) {
        String[] idArray;
        ZKResultMsg retMsg = new ZKResultMsg();
        for (String str : idArray = ids.split(",")) {
            List items = this.esdcTrackReportService.getByCondition(new EsdcTrackReportItem(str));
            EsdcTrackReportItem item = Optional.ofNullable(items).filter(list -> !list.isEmpty()).map(list -> (EsdcTrackReportItem)list.get(0)).orElse(null);
            String imagePath = FileUtils.getLocalFullPath((String)item.getLibFaceImage());
            if (!FileUtils.fileExists((String)item.getLibFaceImage())) continue;
            FileUtils.deleteFile((String)imagePath);
        }
        this.esdcTrackReportService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public boolean reportNameIsExist(String reportName) {
        return this.esdcTrackReportService.reportNameIsExist(reportName);
    }

    public void export(HttpServletRequest request, HttpServletResponse resp, Boolean isExport) {
        if (!isExport.booleanValue()) {
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        String filePath = "";
        String snapshotPath = "";
        try {
            String ids = request.getParameter("ids");
            String exportId = request.getParameter("exportId");
            String reportEchartsLocal = request.getParameter("reportEcharLocal");
            String fileName = System.currentTimeMillis() + ".jpg";
            snapshotPath = "upload/esdc/report/" + DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD) + "/";
            FileUtils.saveFile((String)snapshotPath, (String)fileName, (String)reportEchartsLocal, (boolean)false);
            filePath = snapshotPath + fileName;
            request.setAttribute("reportEcharLocal", (Object)filePath);
            List list = this.esdcTrackReportService.getItemData(exportId, 0, ids.split(",").length);
            this.excelExport(list, EsdcSearchResultEventItem.class);
        }
        catch (Exception e) {
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                String localFullPath = FileUtils.getLocalFullPath((String)snapshotPath);
                FileUtils.deleteDirectory((String)localFullPath);
            }
        }
    }

    public ZKResultMsg saveReportEchartsImg(String defaultBase64Img, String accDoorBase64Img) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        Map map = this.esdcTrackReportService.saveReportEchartsImg(defaultBase64Img, accDoorBase64Img);
        zkResultMsg.setData((Object)map);
        return zkResultMsg;
    }
}

