/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcTimeSegRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTimeSegService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTimeSegItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcTimeSegController
extends BaseController
implements EsdcTimeSegRemote {
    @Autowired
    private EsdcTimeSegService esdcTimeSegService;

    @RequiresPermissions(value={"esdc:timeseg"})
    public ModelAndView index() {
        return new ModelAndView("esdc/timeseg/esdcTimeSeg");
    }

    @RequiresPermissions(value={"esdc:timeseg:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcTimeSegService.getItemById(id));
        }
        return new ModelAndView("esdc/timeseg/editEsdcTimeSeg");
    }

    @RequiresPermissions(value={"esdc:timeseg:edit"})
    public ZKResultMsg save(EsdcTimeSegItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.esdcTimeSegService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:timeseg:refresh"})
    public DxGrid list(EsdcTimeSegItem codition) {
        Pager pager = this.esdcTimeSegService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"esdc:timeseg:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcTimeSegService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getTimeSegList() {
        List esdcTimeSegList = this.esdcTimeSegService.getByCondition(new EsdcTimeSegItem());
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        for (EsdcTimeSegItem esdcTimeSegItem : esdcTimeSegList) {
            selectItem = new SelectItem();
            selectItem.setValue(esdcTimeSegItem.getId());
            selectItem.setText((Object)esdcTimeSegItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public String isExist(String name) {
        return String.valueOf(this.esdcTimeSegService.getItemByName(name) == null);
    }
}

