/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcSdcDeviceRemote;
import com.zkteco.zkbiosecurity.esdc.service.Esdc4VidEdgeDeviceService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcSdcDeviceService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.sdc.EsdcCameraSearchReqItem;
import com.zkteco.zkbiosecurity.esdc.vo.sdc.EsdcChangePasswordItem;
import com.zkteco.zkbiosecurity.esdc.vo.sdc.EsdcSearchCameraItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcSdcDeviceController
extends BaseController
implements EsdcSdcDeviceRemote {
    @Autowired
    private EsdcSdcDeviceService esdcSdcDeviceService;
    @Autowired(required=false)
    private Esdc4VidEdgeDeviceService esdc4VidEdgeDeviceService;

    @RequiresPermissions(value={"esdc:sdcdevice"})
    public ModelAndView index() {
        return new ModelAndView("esdc/sdcdevice/esdcSdcDevice");
    }

    @RequiresPermissions(value={"esdc:sdcdevice:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcSdcDeviceService.getItemById(id));
        }
        return new ModelAndView("esdc/sdcdevice/editEsdcSdcDevice");
    }

    @LogRequest(module="esdc_module", object="esdc_sdc_device", opType="common_op_edit", requestParams={"deviceName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"esdc:sdcdevice:edit"})
    public ZKResultMsg save(EsdcDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean isAdd = StringUtils.isBlank((CharSequence)item.getId());
        this.esdcSdcDeviceService.saveItem(item);
        if (isAdd) {
            ArrayList<EsdcDeviceItem> esdcSdcDeviceItemList = new ArrayList<EsdcDeviceItem>();
            esdcSdcDeviceItemList.add(item);
            this.esdcSdcDeviceService.sendAllPersonnelListToDev(esdcSdcDeviceItemList);
            this.esdcSdcDeviceService.syncTime(item.getId());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:sdcdevice:refresh"})
    public DxGrid list(EsdcDeviceItem codition) {
        Pager pager = this.esdcSdcDeviceService.pagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="esdc_module", object="esdc_sdc_device", opType="common_op_del", requestParams={"ids"}, opContent="esdc_device_id")
    @RequiresPermissions(value={"esdc:sdcdevice:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcSdcDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView getSearchDevInfo() {
        String hostAddress = "192.168.212.1";
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
            hostAddress = address.getHostAddress();
            this.log.info("IP address is " + address.getHostAddress() + ", host name is " + address.getHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String startIp = hostAddress.substring(0, hostAddress.lastIndexOf(".")) + ".1";
        String endIp = hostAddress.substring(0, hostAddress.lastIndexOf(".")) + ".255";
        this.request.setAttribute("startIp", (Object)startIp);
        this.request.setAttribute("endIp", (Object)endIp);
        return new ModelAndView("esdc/sdcdevice/esdcSdcDeviceSearch");
    }

    public ZKResultMsg checkDeviceStatus(String ids) {
        boolean flag;
        if (StringUtils.isNotBlank((CharSequence)ids) && (flag = this.esdcSdcDeviceService.checkDeviceStatus(ids))) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    @RequiresPermissions(value={"esdc:sdcdevice:editSDKPassword"})
    public ModelAndView editSDKPassword(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcSdcDeviceService.getItemById(id));
        }
        return new ModelAndView("esdc/sdcdevice/modifySDKPassword");
    }

    public ZKResultMsg modifySDKPassword(EsdcChangePasswordItem changePasswordItem) {
        ZKResultMsg msg = new ZKResultMsg();
        String deviceId = this.request.getParameter("deviceId");
        ZKResultMsg resultMsg = this.esdcSdcDeviceService.modifySDKPassword(deviceId, changePasswordItem);
        msg.setRet(resultMsg.getRet());
        msg.setMsg(resultMsg.getMsg());
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    @LogRequest(module="esdc_module", object="esdc_sdc_device", opType="common_op_reboot", requestParams={"ids"}, opContent="esdc_device_id")
    @RequiresPermissions(value={"esdc:sdcdevice:reboot"})
    public ZKResultMsg rebootSdcDevice(String ids) {
        ZKResultMsg retMsg = this.esdcSdcDeviceService.rebootByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @LogRequest(module="esdc_module", object="esdc_sdc_device", opType="common_dev_syncTime", requestParams={"names"}, opContent="common_dev_syncTime")
    @RequiresPermissions(value={"esdc:sdcdevice:syncTime"})
    public ZKResultMsg syncTime(String ids) {
        return this.esdcSdcDeviceService.syncTime(ids);
    }

    public ZKResultMsg existIvsParentDevice() {
        if (Objects.nonNull(this.esdc4VidEdgeDeviceService)) {
            List edgeDeviceItems = this.esdc4VidEdgeDeviceService.getEdgeDeviceItems();
            if (CollectionUtils.isEmpty((Collection)edgeDeviceItems)) {
                throw new ZKBusinessException(I18nUtil.i18nCode((String)"esdc_ivs_parent_device_add", (Object[])new Object[0]));
            }
            return ZKResultMsg.successMsg();
        }
        throw new ZKBusinessException(I18nUtil.i18nCode((String)"esdc_ivs_no_import", (Object[])new Object[0]));
    }

    public ZKResultMsg getParentSelectItem() {
        return new ZKResultMsg((Object)this.esdcSdcDeviceService.getParentSelectItem(this.request.getSession().getId()));
    }

    public ZKResultMsg videoStorage(String deviceId, String parentId) {
        String sessionId = this.request.getSession().toString();
        return this.esdcSdcDeviceService.videoStorage(deviceId, parentId, sessionId);
    }

    public ZKResultMsg getItemById(String id) {
        ZKResultMsg res = new ZKResultMsg();
        EsdcDeviceItem sdcDeviceItem = this.esdcSdcDeviceService.getItemById(id);
        if (Objects.nonNull(sdcDeviceItem)) {
            res.setData((Object)sdcDeviceItem);
            return res;
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg getSdcList() {
        return this.esdcSdcDeviceService.getSdcList();
    }

    public ZKResultMsg addAllSdcDevice(List<EsdcDeviceItem> condition) {
        if (Objects.nonNull(condition) && condition.size() > 0) {
            return this.esdcSdcDeviceService.addAllSdcDevice(condition, this.request.getSession().getId());
        }
        return ZKResultMsg.failMsg();
    }

    @RequiresPermissions(value={"esdc:sdcdevice:searchDev"})
    public ZKResultMsg searchSdcDevice(EsdcCameraSearchReqItem condition) {
        return this.esdcSdcDeviceService.searchSdcDevice(condition);
    }

    public DxGrid getSearchSdcDevice(String isSearchFinish) {
        Pager pager = this.esdcSdcDeviceService.getSearchSdcDevice(isSearchFinish);
        return GridUtil.convert((Pager)pager, EsdcSearchCameraItem.class);
    }

    @RequiresPermissions(value={"esdc:sdcdevice:syncSdcDevice"})
    public ZKResultMsg syncSdcDevice() {
        return this.esdcSdcDeviceService.syncSdcDevice();
    }

    public ZKResultMsg delAllPersonnelList(String ids) {
        return this.esdcSdcDeviceService.delAllPersonnelList(ids);
    }
}

