/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcScheduleSegRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcScheduleSegService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcScheduleSegItem;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcScheduleSegController
extends BaseController
implements EsdcScheduleSegRemote {
    @Autowired
    private EsdcScheduleSegService esdcScheduleSegService;

    public ModelAndView index() {
        return new ModelAndView("/esdc/scheduleseg/esdcScheduleSeg");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EsdcScheduleSegItem esdcScheduleSegItem = this.esdcScheduleSegService.getItemById(id);
            this.request.setAttribute("item", (Object)esdcScheduleSegItem);
        }
        return new ModelAndView("/esdc/scheduleseg/editEsdcScheduleSeg");
    }

    public ZKResultMsg save(EsdcScheduleSegItem item) {
        EsdcScheduleSegItem esdcScheduleSegItem = this.esdcScheduleSegService.saveItem(item);
        if (Objects.nonNull(esdcScheduleSegItem)) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public DxGrid list(EsdcScheduleSegItem condition) {
        Pager pager = this.esdcScheduleSegService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        boolean flag = this.esdcScheduleSegService.deleteByIds(ids);
        if (!flag) {
            return ZKResultMsg.failMsg();
        }
        return ZKResultMsg.successMsg();
    }

    public List<SelectItem> getSelectionByTimeSegId(String timeSegId) {
        return this.esdcScheduleSegService.getSelectionByTimeSegId(timeSegId);
    }

    public ZKResultMsg getScheduleSegByTimeSegId(String timeSegId) {
        EsdcScheduleSegItem esdcScheduleSegItem;
        ZKResultMsg zsg = ZKResultMsg.failMsg();
        if (StringUtils.isNotBlank((CharSequence)timeSegId) && Objects.nonNull(esdcScheduleSegItem = this.esdcScheduleSegService.getScheduleSegByTimeSegId(timeSegId))) {
            zsg = ZKResultMsg.successMsg();
            zsg.setData((Object)esdcScheduleSegItem);
        }
        return zsg;
    }
}

