/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcSceneConfigRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcLicenseCheckService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcSceneConfigService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPassbackConfigSelectDoorItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSceneConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSceneEntranceFenceConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSceneKeyPersonConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSceneLeavePostConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcScenePassBackConfigSaveItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSceneSaveItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcSceneConfigController
extends BaseController
implements EsdcSceneConfigRemote {
    @Autowired
    private EsdcLicenseCheckService esdcLicenseCheckService;
    @Autowired
    private EsdcSceneConfigService esdcSceneConfigService;

    @RequiresPermissions(value={"esdc:sceneconfig"})
    public ModelAndView index() {
        Map licenseMap = this.esdcLicenseCheckService.checkSceneConfig();
        if (!licenseMap.containsValue(true)) {
            return new ModelAndView("esdc/license/licenseCheck");
        }
        return new ModelAndView("esdc/sceneconfig/esdcSceneConfig");
    }

    @RequiresPermissions(value={"esdc:sceneconfig:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcSceneConfigService.getItemById(id));
        }
        this.request.setAttribute("licenseMap", (Object)JSON.toJSONString((Object)this.esdcLicenseCheckService.checkSceneConfig()));
        return new ModelAndView("esdc/sceneconfig/editEsdcSceneConfig");
    }

    public ZKResultMsg save(EsdcSceneSaveItem esdcSceneSaveItem) {
        EsdcScenePassBackConfigSaveItem passBackConfigSaveItem;
        EsdcSceneLeavePostConfigItem leavePostConfigItem;
        EsdcSceneKeyPersonConfigItem keyPersonConfigItem;
        EsdcSceneEntranceFenceConfigItem entranceFenceConfigItem = esdcSceneSaveItem.getEntranceFenceConfigItem();
        if (Objects.nonNull(entranceFenceConfigItem)) {
            entranceFenceConfigItem.setDeviceId(esdcSceneSaveItem.getDeviceId());
        }
        if (Objects.nonNull(keyPersonConfigItem = esdcSceneSaveItem.getKeyPersonConfigItem())) {
            keyPersonConfigItem.setDeviceId(esdcSceneSaveItem.getDeviceId());
        }
        if (Objects.nonNull(leavePostConfigItem = esdcSceneSaveItem.getLeavePostConfigItem())) {
            leavePostConfigItem.setDeviceId(esdcSceneSaveItem.getDeviceId());
        }
        if (Objects.nonNull(passBackConfigSaveItem = esdcSceneSaveItem.getPassBackConfigSaveItem())) {
            passBackConfigSaveItem.setDeviceId(esdcSceneSaveItem.getDeviceId());
        }
        this.esdcSceneConfigService.save(esdcSceneSaveItem);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"esdc:sceneconfig:refresh"})
    public DxGrid list(EsdcSceneConfigItem codition) {
        Pager pager = this.esdcSceneConfigService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"esdc:sceneconfig:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcSceneConfigService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView editKeyPersonConfig(String deviceId) {
        EsdcSceneKeyPersonConfigItem keyPersonConfigByDeviceId = this.esdcSceneConfigService.getKeyPersonConfigByDeviceId(deviceId);
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            this.request.setAttribute("item", (Object)keyPersonConfigByDeviceId);
        }
        return new ModelAndView("esdc/sceneconfig/editKeyPersonConfig");
    }

    public ModelAndView editPassBackConfig(String deviceId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            this.request.setAttribute("item", (Object)this.esdcSceneConfigService.getPassbackConfigByChannelId(deviceId));
        }
        return new ModelAndView("esdc/sceneconfig/editPassBackConfig");
    }

    public ModelAndView editEntranceFenceConfig(String deviceId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            this.request.setAttribute("item", (Object)this.esdcSceneConfigService.getEntranceFenceConfigByDeviceId(deviceId));
        }
        return new ModelAndView("esdc/sceneconfig/editEntranceFenceConfig");
    }

    public ModelAndView editLeavePostConfig(String deviceId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            this.request.setAttribute("item", (Object)this.esdcSceneConfigService.getLeavePostConfigByDeviceId(deviceId));
        }
        return new ModelAndView("esdc/sceneconfig/editLeavePostConfig");
    }

    public DxGrid getNoPassBackConfigSelectAcc(EsdcPassbackConfigSelectDoorItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.esdcSceneConfigService.getNoPassBackConfigSelectDoor(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public String configIsLengthExceeds(int type, String configId) {
        String flag = this.esdcSceneConfigService.configIsLengthExceeds(type, configId);
        return flag;
    }

    public ModelAndView getDeviceItemsByDoorId(String doorId) {
        this.request.setAttribute("devices", (Object)this.esdcSceneConfigService.getDeviceItemsByDoorId(doorId));
        return new ModelAndView("esdc/passback/esdcPassbackDevicePreview");
    }
}

