/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcRankingWidgetRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcRankingWidgetService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcWidget2UserService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCustomizeSearchItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersPersonItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcRankingWidgetItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcWidget2UserItem;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonnalListItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcRankingWidgetController
extends BaseController
implements EsdcRankingWidgetRemote {
    @Autowired
    private EsdcRankingWidgetService esdcRankingWidgetService;
    @Autowired
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private EsdcWidget2UserService esdcWidget2UserService;

    public ModelAndView rankingWidgetConfig() {
        return new ModelAndView("esdc/ranking/setting/rankingWidgetConfig");
    }

    public ModelAndView setting() {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("/esdc/ranking/setting/rankingWidgetSetting");
        return modelAndView;
    }

    @LogRequest(module="esdc_module", object="esdc_rankingList", opType="common_op_edit", requestParams={"rankingName"}, opContent="esdc_ranking_name")
    public ZKResultMsg save(EsdcRankingWidgetItem item) {
        if (Objects.isNull(item)) {
            throw new ZKBusinessException("Ranking setting item can not be null!");
        }
        item.setUserId(this.getCurrentSubject().getUserId());
        this.esdcRankingWidgetService.saveItem(item);
        return ZKResultMsg.successMsg();
    }

    @LogRequest(module="esdc_module", object="esdc_rankingList", opType="common_op_edit", requestParams={"widgetId"}, opContent="esdc_ranking_name")
    public ZKResultMsg saveWidget2User(EsdcWidget2UserItem item) {
        String userId = this.getCurrentSubject().getUserId();
        return this.esdcRankingWidgetService.saveWidget2User(userId, item);
    }

    public ZKResultMsg list(String panelId) {
        List rankingWidgetItems = this.esdcRankingWidgetService.getAll();
        return new ZKResultMsg((Object)rankingWidgetItems);
    }

    public ZKResultMsg userWidgetList() {
        String userId = this.getCurrentSubject().getUserId();
        ZKResultMsg zkResultMsg = this.esdcWidget2UserService.userWidgetList(userId);
        return zkResultMsg;
    }

    public DxGrid getWidgetListByUser(EsdcRankingWidgetItem condition) {
        List esdcRankingWidgetItems = this.esdcRankingWidgetService.getWidgetListByUser(this.getCurrentSubject().getUserId());
        if (StringUtils.isNotBlank((CharSequence)condition.getRankingName())) {
            esdcRankingWidgetItems.removeIf(item -> !item.getRankingName().contains(condition.getRankingName()));
        }
        Pager pager = new Pager();
        pager.setData(esdcRankingWidgetItems);
        return GridUtil.convert((Pager)pager, EsdcRankingWidgetItem.class);
    }

    @LogRequest(module="esdc_module", object="esdc_rankingList", opType="common_op_del", requestParams={"ids"}, opContent="esdc_ranking_del_config")
    public ZKResultMsg delete(String ids, String delType) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcRankingWidgetService.deleteByIds(ids, this.getCurrentSubject().getUserId(), delType);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"esdc:ranking:edit"})
    public ModelAndView edit(String id) {
        ModelAndView modelAndView = new ModelAndView();
        EsdcRankingWidgetItem widgetItem = this.esdcRankingWidgetService.getById(id);
        if (Objects.nonNull(widgetItem)) {
            modelAndView.addObject("item", (Object)widgetItem);
            modelAndView.addObject("currentUserId", (Object)this.getCurrentSubject().getUserId());
        }
        modelAndView.setViewName("/esdc/ranking/setting/rankingWidgetSetting");
        return modelAndView;
    }

    public ModelAndView RankingMainView() {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("/esdc/ranking/esdcRankingMainView");
        return modelAndView;
    }

    public DxGrid queryTransaction(EsdcRankingWidgetItem condition) {
        EsdcRankingWidgetItem byId = this.esdcRankingWidgetService.getById(condition.getId());
        Pager pager = this.esdcRankingWidgetService.rankingQuery(byId);
        return GridUtil.convert((Pager)pager, EsdcCustomizeSearchItem.class);
    }

    public ModelAndView simpleRankingWidget(String rankingWidgetId) {
        ModelAndView modelAndView = new ModelAndView("/esdc/ranking/esdcSimpleWidget");
        EsdcRankingWidgetItem rankingWidgetItem = this.esdcRankingWidgetService.getById(rankingWidgetId);
        modelAndView.addObject("item", (Object)rankingWidgetItem);
        return modelAndView;
    }

    public ZKResultMsg getDefaultWidget() {
        String userId = this.getCurrentSubject().getUserId();
        return this.esdcRankingWidgetService.getDefaultWidget(userId);
    }

    public ZKResultMsg getLibType() {
        ArrayList selectItems = new ArrayList();
        List byCondition = this.persPersonnalListService.getByCondition(new PersPersonnalListItem());
        if (!CollectionUtils.isEmpty((Collection)byCondition)) {
            byCondition.forEach(item -> {
                SelectItem selectItem = new SelectItem();
                selectItem.setText((Object)I18nUtil.i18nCode((String)("2".equals(item.getType()) ? "esdc_ranking_condition_bannedList" : "esdc_ranking_condition_allowList"), (Object[])new Object[0]));
                int type = Integer.parseInt(item.getType());
                selectItem.setValue(String.valueOf(type - 1));
                selectItems.add(selectItem);
            });
        }
        TreeSet<SelectItem> setItem = new TreeSet<SelectItem>(Comparator.comparing(SelectItem::getValue));
        setItem.addAll(selectItems);
        return new ZKResultMsg(setItem);
    }

    public ZKResultMsg getLibTypeName() {
        ArrayList selectItems = new ArrayList();
        List byCondition = this.persPersonnalListService.getByCondition(new PersPersonnalListItem());
        if (!CollectionUtils.isEmpty((Collection)byCondition)) {
            byCondition.forEach(item -> {
                SelectItem selectItem = new SelectItem();
                selectItem.setText((Object)item.getName());
                selectItem.setValue(item.getName());
                selectItems.add(selectItem);
            });
        }
        return new ZKResultMsg(selectItems);
    }

    public DxGrid persPerson(EsdcPersPersonItem condition) {
        Pager pager = this.esdcRankingWidgetService.getPager(this.request.getSession().getId(), condition, Integer.valueOf(this.getPageNo()), Integer.valueOf(this.getPageSize()));
        DxGrid convert = GridUtil.convert((Pager)pager, condition.getClass());
        return convert;
    }

    public ZKResultMsg getInitWidget() {
        ArrayList selectItems = new ArrayList();
        List initWidget = this.esdcRankingWidgetService.getWidgetListByUser(this.getCurrentSubject().getUserId());
        if (initWidget.size() > 0) {
            initWidget.forEach(item -> {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue(item.getId());
                selectItem.setText((Object)I18nUtil.i18nCode((String)item.getRankingName(), (Object[])new Object[0]));
                selectItems.add(selectItem);
            });
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg recordWidgetsOrder(String widgetOrder) {
        String userId = this.getCurrentSubject().getUserId();
        ZKResultMsg zkResultMsg = this.esdcRankingWidgetService.recordWidgetsOrder(userId, widgetOrder);
        return zkResultMsg;
    }
}

