/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcPersonnelSearchRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcParamsService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcPersonnelSearchService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcSearchService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTrackReportService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcGetDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcGetPersPersonItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcParamsItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTrackReportItem;
import com.zkteco.zkbiosecurity.esdc.vo.search.EsdcSearchRequest;
import com.zkteco.zkbiosecurity.esdc.vo.search.SearchResult;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcPersonnelSearchController
extends BaseController
implements EsdcPersonnelSearchRemote {
    @Autowired
    private EsdcSearchService esdcSearchService;
    @Autowired
    private EsdcTrackReportService esdcTrackReportService;
    @Autowired
    private EsdcParamsService paramsService;
    @Autowired
    private EsdcPersonnelSearchService esdcPersonnelSearchService;

    @RequiresPermissions(value={"esdc:personnelSearch"})
    public ModelAndView index(EsdcSearchRequest esdcSearchRequest) {
        if (Objects.nonNull(esdcSearchRequest.getStartTime()) && Objects.nonNull(esdcSearchRequest.getEndTime())) {
            this.request.setAttribute("params", (Object)esdcSearchRequest);
        }
        if (Objects.nonNull(esdcSearchRequest.getIsJumpToResultsPage())) {
            this.request.setAttribute("isJumpToResultsPage", (Object)esdcSearchRequest.getIsJumpToResultsPage());
        }
        EsdcParamsItem esdcParams = this.paramsService.getEsdcParams();
        this.request.setAttribute("structuredParams", (Object)esdcParams);
        return new ModelAndView("esdc/personsearch/esdcPersonnelSearch");
    }

    public ModelAndView search(@RequestParam(value="uploadCoverPhoto", required=false) MultipartFile uploadCoverPhoto, EsdcSearchRequest esdcSearchRequest, String searchTypeChoose) {
        String sessionIds;
        List esdcGetDeviceItems;
        esdcSearchRequest.setPage(0);
        esdcSearchRequest.setSize(2700);
        String sessionId = this.request.getSession().getId();
        this.esdcPersonnelSearchService.getSearchResultFromCache("esdc:search:result:" + sessionId);
        if (Objects.nonNull(uploadCoverPhoto)) {
            try {
                String imgStr = Base64Util.encode((byte[])uploadCoverPhoto.getBytes());
                esdcSearchRequest.setPicBase64("data:image/jpeg;base64," + imgStr);
            }
            catch (IOException e) {
                this.log.error("Target search upload image error\uff1a" + e.getMessage());
            }
        }
        this.request.setAttribute("params", (Object)esdcSearchRequest);
        this.request.setAttribute("searchTypeChoose", (Object)searchTypeChoose);
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = sdf.format(esdcSearchRequest.getStartTime());
        String endTime = sdf.format(esdcSearchRequest.getEndTime());
        if (StringUtils.isNotBlank((CharSequence)esdcSearchRequest.getDeviceIds()) && (esdcGetDeviceItems = this.esdcSearchService.getDeviceList(sessionIds = this.request.getSession().getId())).size() > 0) {
            for (EsdcGetDeviceItem item : esdcGetDeviceItems) {
                if (!esdcSearchRequest.getDeviceIds().contains(item.getId())) continue;
                if ("ivs".equals(item.getSourceModule())) {
                    if (!StringUtils.isNotBlank((CharSequence)item.getParentDeviceId())) continue;
                    sb.append(item.getDeviceName()).append(",");
                    continue;
                }
                sb.append(item.getDeviceName()).append(",");
            }
        }
        this.request.setAttribute("modules", (Object)(StringUtils.isBlank((CharSequence)sb) ? "" : sb.substring(0, sb.length() - 1)));
        this.request.setAttribute("selectTime", (Object)(startTime + " - " + endTime));
        return new ModelAndView("esdc/personsearch/esdcPersonnelSearchResult");
    }

    public ZKResultMsg searchByPage(@RequestParam(value="uploadCoverPhoto", required=false) MultipartFile uploadCoverPhoto, EsdcSearchRequest esdcSearchRequest) {
        int page = esdcSearchRequest.getSize() / 27;
        if (esdcSearchRequest.getPage() >= page) {
            return new ZKResultMsg(new ArrayList());
        }
        if (Objects.nonNull(uploadCoverPhoto)) {
            try {
                String imgStr = Base64Util.encode((byte[])uploadCoverPhoto.getBytes());
                esdcSearchRequest.setPicBase64("data:image/jpeg;base64," + imgStr);
            }
            catch (IOException e) {
                this.log.error("Target search upload image error\uff1a" + e.getMessage());
            }
        }
        String sessionId = this.request.getSession().getId();
        List result = this.esdcSearchService.search(esdcSearchRequest, sessionId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", (Object)result);
        jsonObject.put("params", (Object)esdcSearchRequest);
        ZKResultMsg msg = new ZKResultMsg();
        msg.setData((Object)jsonObject);
        return msg;
    }

    public ZKResultMsg searchList(@RequestParam(value="uploadCoverPhoto", required=false) MultipartFile uploadCoverPhoto, EsdcSearchRequest esdcSearchRequest) {
        int page = esdcSearchRequest.getSize() / 27;
        if (esdcSearchRequest.getPage() >= page) {
            return new ZKResultMsg(new ArrayList());
        }
        String sessionId = this.request.getSession().getId();
        if (Objects.nonNull(uploadCoverPhoto)) {
            try {
                String imgStr = Base64Util.encode((byte[])uploadCoverPhoto.getBytes());
                esdcSearchRequest.setPicBase64("data:image/jpeg;base64," + imgStr);
            }
            catch (IOException e) {
                this.log.error("Target search upload image error\uff1a" + e.getMessage());
            }
        }
        SearchResult searchResult = this.esdcSearchService.searchByType(esdcSearchRequest, sessionId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", (Object)searchResult);
        jsonObject.put("params", (Object)esdcSearchRequest);
        ZKResultMsg msg = new ZKResultMsg();
        msg.setData((Object)jsonObject);
        return msg;
    }

    public ModelAndView report(String trackReportId, String jumpSign) {
        EsdcTrackReportItem esdcTrackReportItem = new EsdcTrackReportItem();
        if (StringUtils.isNotBlank((CharSequence)trackReportId)) {
            esdcTrackReportItem = this.esdcTrackReportService.getItemById(trackReportId);
        }
        this.request.setAttribute("itemResult", (Object)jumpSign);
        this.request.setAttribute("item", (Object)esdcTrackReportItem);
        return new ModelAndView("esdc/personsearch/esdcPersonSearchReportDetail");
    }

    public ZKResultMsg getPersonInfo(String pin) {
        EsdcGetPersPersonItem personInfo = this.esdcSearchService.getPersonInfo(pin);
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        zkResultMsg.setData((Object)personInfo);
        return zkResultMsg;
    }

    public DxGrid getDeviceList(EsdcGetDeviceItem condition) {
        ArrayList esdcGetDeviceItemList = new ArrayList();
        String sessionId = this.request.getSession().getId();
        Pager pager = new Pager();
        List deviceList = this.esdcSearchService.getDeviceList(sessionId);
        if (deviceList.size() > 0) {
            ArrayList deviceItems = new ArrayList();
            deviceList.forEach(deviceItem -> {
                if ("ivs".equals(deviceItem.getSourceModule())) {
                    if (StringUtils.isNotBlank((CharSequence)deviceItem.getParentDeviceId())) {
                        deviceItems.add(deviceItem);
                    }
                } else {
                    deviceItems.add(deviceItem);
                }
            });
            if (deviceItems.size() > 0 && StringUtils.isNotBlank((CharSequence)condition.getDeviceName())) {
                deviceItems.forEach(item -> {
                    if (StringUtils.isNotBlank((CharSequence)condition.getDeviceName()) && StringUtils.isNotBlank((CharSequence)item.getDeviceName()) && item.getDeviceName().contains(condition.getDeviceName())) {
                        esdcGetDeviceItemList.add(item);
                    }
                });
                pager.setData(esdcGetDeviceItemList);
            } else {
                pager.setData(deviceItems);
            }
        } else {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getDeviceIds() {
        ZKResultMsg msg = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        String deviceIds = this.esdcSearchService.getDeviceIds(sessionId);
        msg.setData((Object)deviceIds);
        return msg;
    }

    public DxGrid selectDeviceList(EsdcGetDeviceItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            String sessionId = this.request.getSession().getId();
            pager = this.esdcSearchService.getSelectDevice(sessionId, condition);
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg saveTemporaryFile(MultipartFile file) {
        File files;
        File[] fileList;
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String fileName = System.currentTimeMillis() + ".jpg";
        String snapshotPath = "upload/esdc/search/";
        JSONObject json = new JSONObject();
        String photoPath = snapshotPath + fileName;
        String originalFilename = file.getOriginalFilename();
        if (Objects.nonNull(file) && !file.isEmpty()) {
            FileUtils.saveMultipartFile((String)snapshotPath, (String)fileName, (MultipartFile)file, (boolean)false);
        }
        if ((fileList = (files = new File(FileUtils.systemFilePath + "/" + "upload/esdc/search/")).listFiles()) != null && fileList.length > 1) {
            File file1 = fileList[0];
            file1.delete();
        }
        json.put("photoPath", (Object)photoPath);
        json.put("fileName", (Object)originalFilename);
        zkResultMsg.setData((Object)json);
        return zkResultMsg;
    }

    public ModelAndView getEventDetail(String eventId, String faceRate, String searchTypeChoose) {
        Map map = this.esdcSearchService.getEventDetail(this.request.getSession().getId(), eventId);
        this.request.setAttribute("persPersonItem", map.get("persPersonItem"));
        this.request.setAttribute("eventItem", map.get("eventItem"));
        this.request.setAttribute("objCoordinate", map.get("objCoordinate"));
        this.request.setAttribute("searchTypeChoose", (Object)searchTypeChoose);
        this.request.setAttribute("actionShow", (Object)true);
        String rate = "0";
        if (Objects.nonNull(faceRate) && !"null".equals(faceRate)) {
            rate = String.valueOf((int)Float.parseFloat(faceRate));
        }
        this.request.setAttribute("faceRate", (Object)rate);
        return new ModelAndView("esdc/personsearch/esdcPersonSearchDetail");
    }

    public ZKResultMsg searchPerPerson() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List pinSort = this.esdcSearchService.getPersonInfo();
        pinSort.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getPhotoPath())) {
                String thumbPath = FileUtil.getThumbPath((String)item.getPhotoPath());
                if (FileUtil.fileExists((String)thumbPath)) {
                    item.setThumbPhotoPath(thumbPath);
                    String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setPhotoBase64("data:image/jpeg;base64," + photoBase64);
                } else {
                    String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)item.getPhotoPath());
                    item.setPhotoBase64("data:image/jpeg;base64," + photoBase64);
                }
            }
        });
        ArrayList nameSort = new ArrayList();
        Collections.sort(pinSort, new Comparator<EsdcGetPersPersonItem>(){

            @Override
            public int compare(EsdcGetPersPersonItem o1, EsdcGetPersPersonItem o2) {
                return o1.getPin().compareTo(o2.getPin());
            }
        });
        map.put("pinSort", pinSort);
        nameSort.addAll(pinSort);
        Collections.sort(nameSort, new Comparator<EsdcGetPersPersonItem>(){

            @Override
            public int compare(EsdcGetPersPersonItem o1, EsdcGetPersPersonItem o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        map.put("nameSort", nameSort);
        Map persPrivacyParam = this.paramsService.getPersPrivacyParam();
        boolean privacy = persPrivacyParam.containsValue(true);
        map.put("privacy", privacy);
        zkResultMsg.setData(map);
        return zkResultMsg;
    }
}

