/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcPersonnelListRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcPersnnelListService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcPersonnelListService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDevice2ListItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDevice2PersonItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersPersonItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersonSelectItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersonnelListItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersonnelListSelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class EsdcPersnnelListController
extends BaseController
implements EsdcPersonnelListRemote {
    @Autowired
    private EsdcPersonnelListService esdcPersonnelListService;
    @Autowired
    private EsdcPersnnelListService esdcPersnnelListService;

    public DxGrid getPersonnelList(EsdcDevice2ListItem condition) {
        Pager pager = this.esdcPersonnelListService.getPersonnelListByPage(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getPersonnelListPerson(EsdcDevice2PersonItem condition) {
        Pager pager = this.esdcPersonnelListService.getPersonnelListPersonByPage(condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            if (I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]).equals(row.getJSONArray("data").getString(3))) {
                row.put("style", (Object)"color:red");
            }
        });
        return data;
    }

    public ZKResultMsg delete(String deviceId, String personnelListIds) {
        return this.esdcPersonnelListService.delPersonnelList(deviceId, personnelListIds);
    }

    public ZKResultMsg delDeviceFace(EsdcDevice2PersonItem condition) {
        return this.esdcPersonnelListService.delDeviceFace(condition);
    }

    public ZKResultMsg addPerson(String deviceId, String devPersonnelListId, String personIds) {
        String clientId = this.request.getParameter("clientId");
        return this.esdcPersnnelListService.addPerson(clientId, deviceId, devPersonnelListId, personIds);
    }

    public DxGrid selectPersonnelList(EsdcPersonnelListSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.esdcPersonnelListService.getPersonnelList(condition, this.getPageNo(), this.getPageSize(), false);
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectPerson(EsdcPersonSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.esdcPersonnelListService.getNoExistPerson(condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData((List)Lists.newArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg addPersonnelList(String deviceId, String personnelListIds) {
        return this.esdcPersonnelListService.addPersonnelList(deviceId, personnelListIds);
    }

    public ZKResultMsg reSyncPersonnelList(String deviceId, String devPersonnelListIds) {
        return this.esdcPersonnelListService.reSyncPersonnelList(deviceId, devPersonnelListIds);
    }

    public ZKResultMsg reSyncPerson(String deviceId, String devPersonnelListId, String devPersonIds) {
        return this.esdcPersonnelListService.reSyncPerson(deviceId, devPersonnelListId, devPersonIds);
    }

    public ZKResultMsg checkAddPersonnelListStatus(String deviceId) {
        boolean flag;
        if (StringUtils.isNotBlank((CharSequence)deviceId) && (flag = this.esdcPersonnelListService.checkAddPersonnelListStatus(deviceId))) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"esdc_device_Library_syncPersonnelList", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return ZKResultMsg.successMsg();
    }

    public DxGrid getPersPersonnelList(EsdcPersonnelListItem condition) {
        Pager pager = this.esdcPersonnelListService.getPersPersonnelList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getPersonInfoByPin(String pin) {
        return this.esdcPersnnelListService.getPersonInfoByPin(pin);
    }

    public ZKResultMsg addStrangerToPers(EsdcPersPersonItem item, @RequestParam(value="personPhoto", required=false) MultipartFile file) {
        if (Objects.nonNull(file) && !file.isEmpty()) {
            String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(item.getPin() + ".jpg"), (MultipartFile)file);
            item.setPhotoPath(photoPath);
        } else if (StringUtils.isNotBlank((CharSequence)item.getPhoto())) {
            String[] photo = StringUtils.split((String)item.getPhoto(), (String)",");
            String photoStr = item.getPhoto();
            if (photo.length > 1) {
                photoStr = photo[1];
            }
            String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(item.getPin() + ".jpg"), (String)photoStr);
            item.setPhotoPath(photoPath);
        }
        return this.esdcPersonnelListService.addStrangerToPers(item);
    }
}

