/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcPassbackRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcLicenseCheckService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcPassbackConfigService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPassbackConfigSelectPsgReaderItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcPassbackController
extends BaseController
implements EsdcPassbackRemote {
    @Autowired
    private EsdcPassbackConfigService passbackConfigService;
    @Autowired
    private EsdcLicenseCheckService esdcLicenseCheckService;

    @RequiresPermissions(value={"esdc:quitJobPerson"})
    public ModelAndView index() {
        Boolean keyAccessControl = this.esdcLicenseCheckService.checkByModuleCode("keyaccesscontrol");
        if (keyAccessControl == null || !keyAccessControl.booleanValue()) {
            return new ModelAndView("esdc/license/licenseCheck");
        }
        return new ModelAndView("esdc/passback/esdcPassbackChart");
    }

    public DxGrid psgReaderPage(EsdcPassbackConfigSelectPsgReaderItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.passbackConfigService.getPsgReaderPage(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

