/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcParamsRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAlarmLinkageService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcParamsService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcParamsItem;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcParamsController
extends BaseController
implements EsdcParamsRemote {
    @Autowired
    private EsdcParamsService paramsService;
    @Autowired
    private EsdcAlarmLinkageService esdcAlarmLinkageService;

    public ModelAndView index() {
        boolean showAccBurglar = this.esdcAlarmLinkageService.checkShowAccBurglar();
        boolean showSMS = this.esdcAlarmLinkageService.checkShowSMS();
        boolean showWhatsApp = this.esdcAlarmLinkageService.checkShowWhatsApp();
        boolean showLine = this.esdcAlarmLinkageService.checkShowLine();
        EsdcParamsItem esdcParams = this.paramsService.getEsdcParams();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("item", (Object)esdcParams);
        modelAndView.addObject("showAccBurglar", (Object)showAccBurglar);
        modelAndView.addObject("showSMS", (Object)showSMS);
        modelAndView.addObject("showWhatsApp", (Object)showWhatsApp);
        modelAndView.addObject("showLine", (Object)showLine);
        modelAndView.setViewName("esdc/params/esdcParams");
        return modelAndView;
    }

    public ZKResultMsg save(EsdcParamsItem params) {
        this.paramsService.saveItem(params);
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg checkMailParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.paramsService.completeMailInfo());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getAreasByUser() {
        Map areaMap = this.paramsService.getFilterAreaMap(this.request.getSession().getId());
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (areaMap.size() > 0) {
            JSONObject dataJson = new JSONObject();
            dataJson.put("areaId", areaMap.get("areaIds"));
            dataJson.put("areaName", areaMap.get("areaName"));
            resultMsg.setData((Object)dataJson);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

