/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.controller.EsdcExportController;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcLeavePostReportRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcLeavePostReportService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcLeavePostReportItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcLeavePostReportSaveItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSearchResultEventItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcLeavePostReportController
extends EsdcExportController
implements EsdcLeavePostReportRemote {
    @Autowired
    private EsdcLeavePostReportService esdcLeavePostReportService;

    @RequiresPermissions(value={"esdc:leavePostReport"})
    public ModelAndView index() {
        return new ModelAndView("esdc/leavepost/report/esdcLeavePostReport");
    }

    @RequiresPermissions(value={"esdc:leavePostReport:edit"})
    public ZKResultMsg save(EsdcLeavePostReportItem item) {
        ZKResultMsg res = new ZKResultMsg();
        EsdcLeavePostReportItem esdcLeavePostReportItem = this.esdcLeavePostReportService.saveItem(item);
        res.setData((Object)esdcLeavePostReportItem.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:leavePostReport:refresh"})
    public DxGrid list(EsdcLeavePostReportItem condition) {
        Pager pager = this.esdcLeavePostReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"esdc:leavePostReport:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcLeavePostReportService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView buildAddReportInfo(EsdcLeavePostReportSaveItem item) {
        EsdcLeavePostReportSaveItem esdcLeavePostReportSaveItem = this.esdcLeavePostReportService.buildAddReportInfo(item);
        this.request.setAttribute("reportItem", (Object)esdcLeavePostReportSaveItem);
        return new ModelAndView("esdc/leavepost/report/esdcAddLeavePostPage");
    }

    public ModelAndView report(String leavePostReportId, String jumpSign) {
        EsdcLeavePostReportItem leavePostReportItem = this.esdcLeavePostReportService.getLeavePostReportInfo(leavePostReportId);
        this.request.setAttribute("itemResult", (Object)jumpSign);
        this.request.setAttribute("item", (Object)leavePostReportItem);
        return new ModelAndView("esdc/leavepost/report/esdcLeavePostReportDetail");
    }

    public boolean reportNameIsExist(String reportName) {
        return this.esdcLeavePostReportService.reportNameIsExist(reportName);
    }

    public DxGrid eventListByReportId(EsdcSearchResultEventItem condition) {
        Pager pager = this.esdcLeavePostReportService.eventListByReportId(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public void export(HttpServletRequest req, HttpServletResponse resp, Boolean isExport) {
        if (!isExport.booleanValue()) {
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        String decryptEchartPic = "";
        try {
            String eventIds = this.request.getParameter("eventIds");
            String exportId = this.request.getParameter("exportId");
            List esdcSearchResultEventItems = this.esdcLeavePostReportService.getItemData(exportId, 0, eventIds.split(",").length);
            HashMap<String, String> addReportDetailMap = new HashMap<String, String>();
            EsdcLeavePostReportItem reportItem = this.esdcLeavePostReportService.getItemById(exportId);
            if (StringUtils.isNotBlank((CharSequence)reportItem.getChartBase64PicUrl())) {
                String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)reportItem.getChartBase64PicUrl());
                String fileName = System.currentTimeMillis() + ".jpg";
                String snapshotPath = "upload/esdc/leavepostreport/" + DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD) + "/";
                FileUtils.saveFile((String)snapshotPath, (String)fileName, (String)decryptFileBase64, (boolean)false);
                decryptEchartPic = snapshotPath + fileName;
            }
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_track_report_report_name", (Object[])new Object[0]), reportItem.getReportName());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_personSearch_report_describe", (Object[])new Object[0]), reportItem.getDescription());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_personSearch_report_creater", (Object[])new Object[0]), reportItem.getCreaterName());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_track_report_time", (Object[])new Object[0]), reportItem.getCreateTime());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_point", (Object[])new Object[0]), reportItem.getDevicePosition());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_count", (Object[])new Object[0]), reportItem.getLeavePostCount());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_sum_time", (Object[])new Object[0]), reportItem.getSumTime());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_rate", (Object[])new Object[0]), reportItem.getRate());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_recently", (Object[])new Object[0]), reportItem.getRecently());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_longest", (Object[])new Object[0]), reportItem.getLongest());
            addReportDetailMap.put(I18nUtil.i18nCode((String)"esdc_leave_post_check_result_pic", (Object[])new Object[0]), decryptEchartPic);
            this.leavePostExport(esdcSearchResultEventItems, EsdcSearchResultEventItem.class, addReportDetailMap);
        }
        catch (Exception e) {
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)decryptEchartPic) && FileUtils.fileExists((String)decryptEchartPic)) {
                String chartPicUrl = FileUtils.getLocalFullPath((String)decryptEchartPic);
                FileUtils.deleteFile((String)chartPicUrl);
            }
        }
    }
}

