/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcIndustryConfigRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcIndustryConfigService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcIndustryConfigItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcIndustryConfigController
extends BaseController
implements EsdcIndustryConfigRemote {
    @Autowired
    private EsdcIndustryConfigService esdcIndustryConfigService;

    public ModelAndView index() {
        return new ModelAndView("/esdc/industry/esdcIndustryConfig");
    }

    public DxGrid list(EsdcIndustryConfigItem condition) {
        Pager pager = this.esdcIndustryConfigService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg save(EsdcIndustryConfigItem item) {
        EsdcIndustryConfigItem esdcIndustryConfigItem = this.esdcIndustryConfigService.saveItem(item);
        if (Objects.isNull(esdcIndustryConfigItem)) {
            return ZKResultMsg.failMsg();
        }
        return ZKResultMsg.successMsg();
    }

    public ModelAndView edit(String id) {
        EsdcIndustryConfigItem esdcIndustryConfigItem = this.esdcIndustryConfigService.getItemById(id);
        if (Objects.nonNull(esdcIndustryConfigItem)) {
            this.request.setAttribute("item", (Object)esdcIndustryConfigItem);
        }
        return new ModelAndView("/esdc/industry/editIndustryConfig");
    }

    public ZKResultMsg del(String ids) {
        return this.esdcIndustryConfigService.deleteByIds(ids);
    }

    public List<SelectItem> getIndustryCofigs() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List esdcIndustryConfigItemList = this.esdcIndustryConfigService.getByCondition(new EsdcIndustryConfigItem());
        if (esdcIndustryConfigItemList.size() > 0) {
            for (EsdcIndustryConfigItem configItem : esdcIndustryConfigItemList) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue(configItem.getId());
                selectItem.setText((Object)configItem.getName());
                selectItems.add(selectItem);
            }
        }
        return selectItems;
    }
}

