/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcGlobalLinkageRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAlarmLinkageService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcGlobalLinkageService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcParamsService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcChannelSelectItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcGlobalLinkageItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcParamsItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcGlobalLinkageController
extends BaseController
implements EsdcGlobalLinkageRemote {
    @Autowired
    private EsdcParamsService paramsService;
    @Autowired
    private EsdcAlarmLinkageService esdcAlarmLinkageService;
    @Autowired
    private EsdcGlobalLinkageService esdcGlobalLinkageService;

    public ModelAndView index() {
        return new ModelAndView("esdc/linkage/esdcGlobalLinkage");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EsdcGlobalLinkageItem item = this.esdcGlobalLinkageService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        boolean showAccBurglar = this.esdcAlarmLinkageService.checkShowAccBurglar();
        boolean showSMS = this.esdcAlarmLinkageService.checkShowSMS();
        boolean showWhatsApp = this.esdcAlarmLinkageService.checkShowWhatsApp();
        boolean showLine = this.esdcAlarmLinkageService.checkShowLine();
        EsdcParamsItem esdcParams = this.paramsService.getEsdcParams();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("showAccBurglar", (Object)showAccBurglar);
        modelAndView.addObject("showSMS", (Object)showSMS);
        modelAndView.addObject("showWhatsApp", (Object)showWhatsApp);
        modelAndView.addObject("showLine", (Object)showLine);
        modelAndView.setViewName("esdc/linkage/editEsdcLinkage");
        return modelAndView;
    }

    public ZKResultMsg saveItem(EsdcGlobalLinkageItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        this.esdcGlobalLinkageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid list(EsdcGlobalLinkageItem condition) {
        return GridUtil.convert((Pager)this.esdcGlobalLinkageService.list(condition, this.getPageNo(), this.getPageSize()), condition.getClass());
    }

    public ZKResultMsg getLinkTriggerOpt(String globalLinkageId) {
        return this.esdcGlobalLinkageService.getLinkTriggerOpt(globalLinkageId);
    }

    public DxGrid getGlobalLinkageSelectChannel(EsdcChannelSelectItem condition) {
        Pager pager = this.esdcGlobalLinkageService.getGlobalLinkageSelectChannel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg deleteGlobalLinkageByIds(String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        this.esdcGlobalLinkageService.deleteByIds(ids);
        return zkResultMsg;
    }

    public boolean isExistLinkageName(String name) {
        return this.esdcGlobalLinkageService.getItemByName(name) == null;
    }
}

