/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcDeviceRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineAreaService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcDeviceService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcParamsService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcSceneConfigService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcChannelItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcConfigSelectDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineAreaItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcSceneConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcZTreeItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcDeviceController
extends BaseController
implements EsdcDeviceRemote {
    @Autowired
    private EsdcCrosslineAreaService esdcCrosslineAreaService;
    @Autowired
    private EsdcSceneConfigService esdcSceneConfigService;
    @Autowired
    private EsdcParamsService esdcParamsService;
    @Autowired
    private EsdcDeviceService esdcDeviceService;

    public ModelAndView index() {
        return new ModelAndView("esdc/device/esdcDevice");
    }

    public DxGrid list(EsdcChannelItem condition) {
        String sessionId = this.request.getSession().getId();
        String authAreaIds = (String)this.esdcParamsService.getFilterAreaMap(sessionId).get("areaIds");
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.esdcDeviceService.list(condition, Integer.valueOf(this.getPageNo()), Integer.valueOf(this.getPageSize()));
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getById(String id) {
        return this.esdcDeviceService.getById(id);
    }

    public List<EsdcZTreeItem> zTree() {
        String authAreaId = this.request.getParameter("authAreaId");
        return this.esdcDeviceService.zTree(authAreaId);
    }

    public DxGrid listNoAreaDeviceList(EsdcConfigSelectDeviceItem condition) {
        String sessionId = this.request.getSession().getId();
        String authAreaIds = (String)this.esdcParamsService.getFilterAreaMap(sessionId).get("areaIds");
        List esdcCrosslineAreaItems = this.esdcCrosslineAreaService.getByCondition(new EsdcCrosslineAreaItem());
        EsdcChannelItem deviceCondition = new EsdcChannelItem();
        HashSet<String> idSet = new HashSet<String>();
        if (Objects.nonNull(esdcCrosslineAreaItems)) {
            esdcCrosslineAreaItems.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getDeviceId())) {
                    idSet.addAll(Arrays.asList(item.getDeviceId().split(",")));
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getAreaId())) {
            EsdcCrosslineAreaItem esdcCrosslineAreaItem = this.esdcCrosslineAreaService.getItemById(condition.getAreaId());
            String deviceIds = esdcCrosslineAreaItem.getDeviceId();
            idSet.removeIf(item -> deviceIds.indexOf((String)item) > -1);
        }
        if (idSet.size() > 0) {
            deviceCondition.setNotInId(idSet.stream().collect(Collectors.joining(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getDevAlias())) {
            deviceCondition.setDevAlias(condition.getDevAlias());
        }
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            deviceCondition.setAuthAreaIdIn(authAreaIds);
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getName())) {
            deviceCondition.setName(condition.getName());
        }
        Pager pager = this.esdcDeviceService.getItemsByPage(deviceCondition, Integer.valueOf(this.getPageNo()), Integer.valueOf(this.getPageSize()));
        return GridUtil.convert((Pager)pager, EsdcChannelItem.class);
    }

    public TreeItem getDeviceTree() {
        return this.esdcDeviceService.getDeviceTree(Integer.valueOf(this.getPageNo()), Integer.valueOf(this.getPageSize()));
    }

    public ZKResultMsg getDeviceIpAddress(String id) {
        return this.esdcDeviceService.getDeviceIpAddress(id);
    }

    public DxGrid listNoSceneConfigId(EsdcConfigSelectDeviceItem condition) {
        String sessionId = this.request.getSession().getId();
        String authAreaIds = (String)this.esdcParamsService.getFilterAreaMap(sessionId).get("areaIds");
        List esdcSceneConfigItems = this.esdcSceneConfigService.getByCondition(new EsdcSceneConfigItem());
        EsdcChannelItem esdcChannelItem = new EsdcChannelItem();
        if (Objects.nonNull(esdcSceneConfigItems)) {
            String ids = esdcSceneConfigItems.stream().map(item -> item.getDeviceId()).collect(Collectors.joining(","));
            esdcChannelItem.setNotInId(ids);
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getDevAlias())) {
            esdcChannelItem.setDevAlias(condition.getDevAlias());
        }
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            esdcChannelItem.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.esdcDeviceService.getItemsByPage(esdcChannelItem, Integer.valueOf(this.getPageNo()), Integer.valueOf(this.getPageSize()));
        return GridUtil.convert((Pager)pager, EsdcChannelItem.class);
    }
}

