/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.constant.EsdcConstants;
import com.zkteco.zkbiosecurity.esdc.enums.EsdcEventEnum;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcDashboardRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcDashboardService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcTransactionConfigService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcTransactionConfigItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcDashboardController
extends BaseController
implements EsdcDashboardRemote {
    @Autowired
    private EsdcTransactionConfigService esdcTransactionConfigService;
    @Autowired
    private EsdcDashboardService esdcDashboardService;

    @RequiresPermissions(value={"esdc:dashboard"})
    public ModelAndView index() {
        return new ModelAndView("esdc/dashboard/esdcDashboard");
    }

    public ZKResultMsg getEventBarData(String eventType, String timeType) {
        EsdcTransactionConfigItem esdcTransactionConfigItem = new EsdcTransactionConfigItem();
        if ("entrance".equals(eventType)) {
            esdcTransactionConfigItem = this.esdcTransactionConfigService.getItemByType(EsdcEventEnum.EntranceFenceEvent.getType());
        } else if ("leavePost".equals(eventType)) {
            esdcTransactionConfigItem = this.esdcTransactionConfigService.getItemByType(EsdcEventEnum.LeavePostEvent.getType());
        } else {
            return new ZKResultMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.esdcDashboardService.getEsdcEventBarData(timeType, esdcTransactionConfigItem));
    }

    public ZKResultMsg getEventStatisticData(String dataType, String eventType, String timeType) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String sessionId = this.request.getSession().getId();
        if ("keyPerson".equals(eventType)) {
            List configItem = this.esdcTransactionConfigService.getItemsByTypeList((Collection)EsdcConstants.KEY_PERSON);
            zkResultMsg = "pie".equals(dataType) ? this.esdcDashboardService.getEsdcEventPieData(timeType, configItem) : ("areaPie".equals(dataType) ? this.esdcDashboardService.getEsdcAreaPieData(timeType, configItem) : this.esdcDashboardService.getEsdcEventTrendsData(sessionId, timeType, configItem));
        } else if ("passBack".equals(eventType)) {
            List configItem = this.esdcTransactionConfigService.getItemsByTypeList((Collection)EsdcConstants.PASS_BACK);
            zkResultMsg = "pie".equals(dataType) ? this.esdcDashboardService.getEsdcEventPieData(timeType, configItem) : this.esdcDashboardService.getEsdcEventTrendsData(sessionId, timeType, configItem);
        }
        return zkResultMsg;
    }

    public ZKResultMsg getEntranceFencePieDate(String dataType, String eventType, String timeType) {
        String sessionId = this.request.getSession().getId();
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if ("entranceFence".equals(eventType)) {
            EsdcTransactionConfigItem configItem = this.esdcTransactionConfigService.getItemByType(EsdcEventEnum.EntranceFenceEvent.getType());
            if ("areaPie".equals(dataType)) {
                zkResultMsg = this.esdcDashboardService.getEntranceFenceDate(sessionId, timeType, configItem);
            }
        }
        return zkResultMsg;
    }
}

