/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineAreaService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineConfigImgService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineEventService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineAreaItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineByListItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineCalculationItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineConfigImgItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineEventItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDeviceItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;

@Controller
public class EsdcCrosslineMonitorWSController {
    @Autowired
    private EsdcCrosslineService esdcCrosslineService;
    @Autowired
    private EsdcCrosslineEventService esdcCrosslineEventService;
    @Autowired
    private EsdcCrosslineAreaService esdcCrosslineAreaService;
    @Autowired
    private EsdcCrosslineConfigImgService esdcCrosslineConfigImgService;

    @MessageMapping(value={"/esdcCrosslineEvent/getEventData"})
    @SendTo(value={"/topic/esdcCrosslineEvent/getEventData"})
    public JSONObject getDeviceEvents(String _params) {
        JSONObject paramJson = JSONObject.parseObject((String)_params);
        JSONObject resultJson = new JSONObject();
        String authAreaId = paramJson.getString("authAreaId");
        ArrayList<EsdcCrosslineCalculationItem> esdcCrosslineCalculationItemList = new ArrayList<EsdcCrosslineCalculationItem>();
        EsdcCrosslineCalculationItem esdcCrosslineCalculationItem = this.esdcCrosslineService.calculateByAreaId(authAreaId);
        esdcCrosslineCalculationItemList.add(esdcCrosslineCalculationItem);
        EsdcDeviceItem esdcDeviceItem = new EsdcDeviceItem();
        esdcDeviceItem.setAreaId(authAreaId);
        JSONArray rows = new JSONArray();
        Pager page = this.esdcCrosslineEventService.getItemsByPage((BaseItem)new EsdcCrosslineEventItem(), 0, 20);
        List esdcCrosslineEventItemList = page.getData();
        for (EsdcCrosslineEventItem item : esdcCrosslineEventItemList) {
            JSONObject row = new JSONObject();
            JSONArray data = new JSONArray();
            data.add((Object)item.getId());
            data.add((Object)DateUtil.dateToString((Date)item.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            data.add((Object)item.getEventName());
            data.add((Object)item.getAreaName());
            data.add((Object)item.getInOrOut());
            data.add((Object)item.getDeviceAlias());
            data.add((Object)item.getChannelCode());
            row.put("data", (Object)data);
            rows.add((Object)row);
        }
        resultJson.put("event", (Object)rows);
        resultJson.put("calculation", esdcCrosslineCalculationItemList);
        return resultJson;
    }

    @MessageMapping(value={"/esdcCrosslineList/getListData"})
    @SendTo(value={"/topic/esdcCrosslineList/getListData"})
    public JSONObject getCrosslineListEvents() {
        JSONObject resultJson = new JSONObject();
        ArrayList<EsdcCrosslineByListItem> crosslineByListItemList = new ArrayList<EsdcCrosslineByListItem>();
        List esdcCrosslineAreaItemList = this.esdcCrosslineAreaService.getByCondition(new EsdcCrosslineAreaItem());
        for (int i = 0; i < esdcCrosslineAreaItemList.size(); ++i) {
            EsdcCrosslineCalculationItem item = this.esdcCrosslineService.calculateByAreaId(((EsdcCrosslineAreaItem)esdcCrosslineAreaItemList.get(i)).getId());
            EsdcCrosslineByListItem crosslineByListItem = new EsdcCrosslineByListItem();
            crosslineByListItem.setAreaId(item.getAreaId());
            crosslineByListItem.setOrderNum(i + 1);
            crosslineByListItem.setAreaName(((EsdcCrosslineAreaItem)esdcCrosslineAreaItemList.get(i)).getName());
            crosslineByListItem.setCapacity(Integer.valueOf(item.getCapacity()));
            crosslineByListItem.setRatio(item.getRatio());
            crosslineByListItem.setCountTotal(item.getCapacity() - item.getTotalIn() + item.getTotalOut() - Optional.ofNullable(item.getCheckCount()).orElse(0));
            crosslineByListItemList.add(crosslineByListItem);
        }
        resultJson.put("crosslineByListItemList", crosslineByListItemList);
        return resultJson;
    }

    @MessageMapping(value={"/esdcCrosslineImgList/getImgListData"})
    @SendTo(value={"/topic/esdcCrosslineImgList/getImgListData"})
    public JSONObject getCrosslineConfigImgList() {
        JSONObject resultJson = new JSONObject();
        List esdcCrosslineConfigImgItems = this.esdcCrosslineConfigImgService.getByCondition(new EsdcCrosslineConfigImgItem());
        if (esdcCrosslineConfigImgItems.size() > 0) {
            resultJson.put("configImgList", (Object)esdcCrosslineConfigImgItems);
        } else {
            resultJson.put("configImgList", (Object)"");
        }
        return resultJson;
    }
}

